/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.common.util.concurrent;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import org.graylog.shaded.opensearch2.org.opensearch.action.ActionRunnable;
import org.graylog.shaded.opensearch2.org.opensearch.action.support.ContextPreservingActionListener;
import org.graylog.shaded.opensearch2.org.opensearch.common.collect.Tuple;
import org.graylog.shaded.opensearch2.org.opensearch.common.util.concurrent.BaseFuture;
import org.graylog.shaded.opensearch2.org.opensearch.common.util.concurrent.FutureUtils;
import org.graylog.shaded.opensearch2.org.opensearch.common.util.concurrent.OpenSearchExecutors;
import org.graylog.shaded.opensearch2.org.opensearch.common.util.concurrent.ThreadContext;
import org.graylog.shaded.opensearch2.org.opensearch.core.action.ActionListener;

public final class ListenableFuture<V>
extends BaseFuture<V>
implements ActionListener<V> {
    private volatile boolean done = false;
    private final List<Tuple<ActionListener<V>, ExecutorService>> listeners = new ArrayList<Tuple<ActionListener<V>, ExecutorService>>();

    public void addListener(ActionListener<V> listener, ExecutorService executor) {
        this.addListener(listener, executor, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(ActionListener<V> listener, ExecutorService executor, ThreadContext threadContext) {
        if (this.done) {
            this.notifyListener(listener, OpenSearchExecutors.newDirectExecutorService());
        } else {
            boolean run;
            ListenableFuture listenableFuture = this;
            synchronized (listenableFuture) {
                if (this.done) {
                    run = true;
                } else {
                    ActionListener<V> wrappedListener = threadContext == null ? listener : ContextPreservingActionListener.wrapPreservingContext(listener, threadContext);
                    this.listeners.add(new Tuple<ActionListener<V>, ExecutorService>(wrappedListener, executor));
                    run = false;
                }
            }
            if (run) {
                this.notifyListener(listener, OpenSearchExecutors.newDirectExecutorService());
            }
        }
    }

    @Override
    protected synchronized void done(boolean ignored) {
        this.done = true;
        this.listeners.forEach(t -> this.notifyListener((ActionListener)t.v1(), (ExecutorService)t.v2()));
        this.listeners.clear();
    }

    private void notifyListener(ActionListener<V> listener, ExecutorService executorService) {
        try {
            executorService.execute(new ActionRunnable<V>(listener){

                @Override
                protected void doRun() {
                    Object value = FutureUtils.get(ListenableFuture.this, 0L, TimeUnit.NANOSECONDS);
                    this.listener.onResponse(value);
                }

                public String toString() {
                    return "ListenableFuture notification";
                }
            });
        }
        catch (Exception e) {
            listener.onFailure(e);
        }
    }

    @Override
    public void onResponse(V v) {
        boolean set = this.set(v);
        if (!set) {
            throw new IllegalStateException("did not set value, value or exception already set?");
        }
    }

    @Override
    public void onFailure(Exception e) {
        boolean set = this.setException(e);
        if (!set) {
            throw new IllegalStateException("did not set exception, value already set or exception already set?");
        }
    }
}

