/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.common.xcontent;

import java.io.IOException;
import java.io.OutputStream;
import org.graylog.shaded.opensearch2.com.fasterxml.jackson.dataformat.cbor.CBORConstants;
import org.graylog.shaded.opensearch2.org.opensearch.common.annotation.PublicApi;
import org.graylog.shaded.opensearch2.org.opensearch.common.xcontent.cbor.CborXContent;
import org.graylog.shaded.opensearch2.org.opensearch.common.xcontent.json.JsonXContent;
import org.graylog.shaded.opensearch2.org.opensearch.common.xcontent.smile.SmileXContent;
import org.graylog.shaded.opensearch2.org.opensearch.common.xcontent.yaml.YamlXContent;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.io.stream.StreamOutput;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.MediaType;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.XContent;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.XContentBuilder;

@PublicApi(since="1.0.0")
public enum XContentType implements MediaType
{
    JSON(0){

        @Override
        public String mediaTypeWithoutParameters() {
            return "application/json";
        }

        @Override
        public String mediaType() {
            return "application/json; charset=UTF-8";
        }

        @Override
        public String subtype() {
            return "json";
        }

        @Override
        public XContent xContent() {
            return JsonXContent.jsonXContent;
        }

        @Override
        public boolean detectedXContent(byte[] bytes, int offset, int length) {
            return bytes[offset] == 123;
        }

        @Override
        public boolean detectedXContent(CharSequence content, int length) {
            return content.charAt(0) == '{';
        }

        @Override
        public XContentBuilder contentBuilder() throws IOException {
            return JsonXContent.contentBuilder();
        }

        @Override
        public XContentBuilder contentBuilder(OutputStream os) throws IOException {
            return new XContentBuilder(JsonXContent.jsonXContent, os);
        }
    }
    ,
    SMILE(1){

        @Override
        public String mediaTypeWithoutParameters() {
            return "application/smile";
        }

        @Override
        public String subtype() {
            return "smile";
        }

        @Override
        public XContent xContent() {
            return SmileXContent.smileXContent;
        }

        @Override
        public boolean detectedXContent(byte[] bytes, int offset, int length) {
            return length > 2 && bytes[offset] == 58 && bytes[offset + 1] == 41 && bytes[offset + 2] == 10;
        }

        @Override
        public boolean detectedXContent(CharSequence content, int length) {
            return length > 2 && content.charAt(0) == ':' && content.charAt(1) == ')' && content.charAt(2) == '\n';
        }

        @Override
        public XContentBuilder contentBuilder() throws IOException {
            return SmileXContent.contentBuilder();
        }

        @Override
        public XContentBuilder contentBuilder(OutputStream os) throws IOException {
            return new XContentBuilder(SmileXContent.smileXContent, os);
        }
    }
    ,
    YAML(2){

        @Override
        public String mediaTypeWithoutParameters() {
            return "application/yaml";
        }

        @Override
        public String subtype() {
            return "yaml";
        }

        @Override
        public XContent xContent() {
            return YamlXContent.yamlXContent;
        }

        @Override
        public boolean detectedXContent(byte[] bytes, int offset, int length) {
            return length > 2 && bytes[offset] == 45 && bytes[offset + 1] == 45 && bytes[offset + 2] == 45;
        }

        @Override
        public boolean detectedXContent(CharSequence content, int length) {
            return length > 2 && content.charAt(0) == '-' && content.charAt(1) == '-' && content.charAt(2) == '-';
        }

        @Override
        public XContentBuilder contentBuilder() throws IOException {
            return YamlXContent.contentBuilder();
        }

        @Override
        public XContentBuilder contentBuilder(OutputStream os) throws IOException {
            return new XContentBuilder(YamlXContent.yamlXContent, os);
        }
    }
    ,
    CBOR(3){

        @Override
        public String mediaTypeWithoutParameters() {
            return "application/cbor";
        }

        @Override
        public String subtype() {
            return "cbor";
        }

        @Override
        public XContent xContent() {
            return CborXContent.cborXContent;
        }

        @Override
        public boolean detectedXContent(byte[] bytes, int offset, int length) {
            if (bytes[offset] == -65 && length > 1) {
                return true;
            }
            if (CBORConstants.hasMajorType(6, bytes[offset]) && length > 2 && bytes[offset] == -39 && bytes[offset + 1] == -39 && bytes[offset + 2] == -9) {
                return true;
            }
            return CBORConstants.hasMajorType(5, bytes[offset]);
        }

        @Override
        public boolean detectedXContent(CharSequence content, int length) {
            return false;
        }

        @Override
        public XContentBuilder contentBuilder() throws IOException {
            return CborXContent.contentBuilder();
        }

        @Override
        public XContentBuilder contentBuilder(OutputStream os) throws IOException {
            return new XContentBuilder(CborXContent.cborXContent, os);
        }
    };

    private int index;

    private XContentType(int index) {
        this.index = index;
    }

    public int index() {
        return this.index;
    }

    @Override
    public String type() {
        return "application";
    }

    @Override
    public String format() {
        return this.subtype();
    }

    @Override
    public void writeTo(StreamOutput output) throws IOException {
        output.writeString(this.mediaType());
    }
}

