/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.core.xcontent;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Locale;
import org.graylog.shaded.opensearch2.org.opensearch.common.annotation.PublicApi;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.io.stream.Writeable;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.MediaTypeRegistry;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.XContent;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.XContentBuilder;

@PublicApi(since="2.1.0")
public interface MediaType
extends Writeable {
    public String type();

    public String subtype();

    public String format();

    default public String typeWithSubtype() {
        return this.type() + "/" + this.subtype();
    }

    public XContent xContent();

    public boolean detectedXContent(byte[] var1, int var2, int var3);

    public boolean detectedXContent(CharSequence var1, int var2);

    default public String mediaType() {
        return this.mediaTypeWithoutParameters();
    }

    public String mediaTypeWithoutParameters();

    public XContentBuilder contentBuilder() throws IOException;

    public XContentBuilder contentBuilder(OutputStream var1) throws IOException;

    public static MediaType fromFormat(String mediaType) {
        return MediaTypeRegistry.fromFormat(mediaType);
    }

    public static MediaType fromMediaType(String mediaTypeHeaderValue) {
        mediaTypeHeaderValue = MediaType.removeVersionInMediaType(mediaTypeHeaderValue);
        return MediaTypeRegistry.fromMediaType(mediaTypeHeaderValue);
    }

    private static String removeVersionInMediaType(String mediaType) {
        if (mediaType != null && (mediaType = mediaType.toLowerCase(Locale.ROOT)).contains("vnd.opensearch")) {
            return mediaType.replaceAll("vnd.opensearch\\+", "").replaceAll("\\s*;\\s*compatible-with=\\d+", "");
        }
        return mediaType;
    }
}

