/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.discovery;

import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.coordination.ClusterStatePublisher;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.node.DiscoveryNode;
import org.graylog.shaded.opensearch2.org.opensearch.discovery.BlockingClusterStatePublishResponseHandler;

public class AckClusterStatePublishResponseHandler
extends BlockingClusterStatePublishResponseHandler {
    private static final Logger logger = LogManager.getLogger(AckClusterStatePublishResponseHandler.class);
    private final ClusterStatePublisher.AckListener ackListener;

    public AckClusterStatePublishResponseHandler(Set<DiscoveryNode> publishingToNodes, ClusterStatePublisher.AckListener ackListener) {
        super(publishingToNodes);
        this.ackListener = ackListener;
    }

    @Override
    public void onResponse(DiscoveryNode node) {
        super.onResponse(node);
        this.onNodeAck(this.ackListener, node, null);
    }

    @Override
    public void onFailure(DiscoveryNode node, Exception e) {
        try {
            super.onFailure(node, e);
        }
        finally {
            this.onNodeAck(this.ackListener, node, e);
        }
    }

    private void onNodeAck(ClusterStatePublisher.AckListener ackListener, DiscoveryNode node, Exception e) {
        try {
            ackListener.onNodeAck(node, e);
        }
        catch (Exception inner) {
            inner.addSuppressed(e);
            logger.debug(() -> new ParameterizedMessage("error while processing ack for node [{}]", (Object)node), (Throwable)inner);
        }
    }
}

