/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.gateway;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.logging.log4j.Logger;
import org.graylog.shaded.opensearch2.org.opensearch.action.FailedNodeException;
import org.graylog.shaded.opensearch2.org.opensearch.action.support.nodes.BaseNodeResponse;
import org.graylog.shaded.opensearch2.org.opensearch.action.support.nodes.BaseNodesResponse;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.ClusterManagerMetrics;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.node.DiscoveryNode;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.node.DiscoveryNodes;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.routing.allocation.RoutingAllocation;
import org.graylog.shaded.opensearch2.org.opensearch.common.Nullable;
import org.graylog.shaded.opensearch2.org.opensearch.common.lease.Releasable;
import org.graylog.shaded.opensearch2.org.opensearch.common.logging.Loggers;
import org.graylog.shaded.opensearch2.org.opensearch.core.action.ActionListener;
import org.graylog.shaded.opensearch2.org.opensearch.core.index.shard.ShardId;
import org.graylog.shaded.opensearch2.org.opensearch.gateway.AsyncShardFetchCache;
import org.graylog.shaded.opensearch2.org.opensearch.indices.store.ShardAttributes;
import org.graylog.shaded.opensearch2.reactor.util.annotation.NonNull;

public abstract class AsyncShardFetch<T extends BaseNodeResponse>
implements Releasable {
    protected final Logger logger;
    protected final String type;
    protected final Map<ShardId, ShardAttributes> shardAttributesMap;
    private final Lister<BaseNodesResponse<T>, T> action;
    protected final AsyncShardFetchCache<T> cache;
    private final AtomicLong round = new AtomicLong();
    private boolean closed;
    final String reroutingKey;
    private final Map<ShardId, Set<String>> shardToIgnoreNodes = new HashMap<ShardId, Set<String>>();

    protected AsyncShardFetch(Logger logger, String type, ShardId shardId, String customDataPath, Lister<? extends BaseNodesResponse<T>, T> action, ClusterManagerMetrics clusterManagerMetrics) {
        this.logger = logger;
        this.type = type;
        this.shardAttributesMap = new HashMap<ShardId, ShardAttributes>();
        this.shardAttributesMap.put(shardId, new ShardAttributes(customDataPath));
        this.action = action;
        this.reroutingKey = "ShardId=[" + shardId.toString() + "]";
        this.cache = new ShardCache<T>(logger, this.reroutingKey, type, clusterManagerMetrics);
    }

    protected AsyncShardFetch(Logger logger, String type, Map<ShardId, ShardAttributes> shardAttributesMap, Lister<? extends BaseNodesResponse<T>, T> action, String batchId, AsyncShardFetchCache<T> cache) {
        this.logger = logger;
        this.type = type;
        this.shardAttributesMap = shardAttributesMap;
        this.action = action;
        this.reroutingKey = "BatchID=[" + batchId + "]";
        this.cache = cache;
    }

    @Override
    public synchronized void close() {
        this.closed = true;
    }

    public synchronized FetchResult<T> fetchData(DiscoveryNodes nodes, Map<ShardId, Set<String>> ignoreNodes) {
        if (this.closed) {
            throw new IllegalStateException(this.reroutingKey + ": can't fetch data on closed async fetch");
        }
        if (this.shardAttributesMap.size() == 1) {
            if (ignoreNodes.size() > 1) {
                throw new IllegalStateException("Fetching Shard Data, " + this.reroutingKey + "Can only have atmost one shardfor non-batch mode");
            }
            if (ignoreNodes.size() == 1 && !this.shardAttributesMap.containsKey(ignoreNodes.keySet().iterator().next())) {
                throw new IllegalStateException("Shard Id must be same as initialized in AsyncShardFetch. Expecting = " + this.reroutingKey);
            }
        }
        for (Map.Entry<ShardId, Set<String>> ignoreNodesEntry : ignoreNodes.entrySet()) {
            Set ignoreNodesSet = this.shardToIgnoreNodes.getOrDefault(ignoreNodesEntry.getKey(), new HashSet());
            ignoreNodesSet.addAll((Collection)ignoreNodesEntry.getValue());
            this.shardToIgnoreNodes.put(ignoreNodesEntry.getKey(), ignoreNodesSet);
        }
        this.cache.fillShardCacheWithDataNodes(nodes);
        List<String> nodeIds = this.cache.findNodesToFetch();
        if (!nodeIds.isEmpty()) {
            long fetchingRound = this.round.incrementAndGet();
            this.cache.markAsFetching(nodeIds, fetchingRound);
            DiscoveryNode[] discoNodesToFetch = (DiscoveryNode[])nodeIds.stream().map(nodes::get).toArray(DiscoveryNode[]::new);
            this.asyncFetch(discoNodesToFetch, fetchingRound);
        }
        if (this.cache.hasAnyNodeFetching()) {
            return new FetchResult(null, Collections.emptyMap());
        }
        HashSet<String> failedNodes = new HashSet<String>();
        Map<DiscoveryNode, T> fetchData = this.cache.getCacheData(nodes, failedNodes);
        Map<ShardId, Set<String>> allIgnoreNodesMap = Collections.unmodifiableMap(new HashMap<ShardId, Set<String>>(this.shardToIgnoreNodes));
        this.shardToIgnoreNodes.clear();
        if (!failedNodes.isEmpty() || allIgnoreNodesMap.values().stream().anyMatch(ignoreNodeSet -> !ignoreNodeSet.isEmpty())) {
            this.reroute(this.reroutingKey, "nodes failed [" + failedNodes.size() + "], ignored [" + allIgnoreNodesMap.values().stream().mapToInt(Set::size).sum() + "]");
        }
        return new FetchResult<T>(fetchData, allIgnoreNodesMap);
    }

    protected synchronized void processAsyncFetch(List<T> responses, List<FailedNodeException> failures, long fetchingRound) {
        if (this.closed) {
            this.logger.trace("{} ignoring fetched [{}] results, already closed", (Object)this.reroutingKey, (Object)this.type);
            return;
        }
        this.logger.trace("{} processing fetched [{}] results", (Object)this.reroutingKey, (Object)this.type);
        if (responses != null) {
            this.cache.processResponses(responses, fetchingRound);
        }
        if (failures != null) {
            this.cache.processFailures(failures, fetchingRound);
        }
        this.reroute(this.reroutingKey, "post_response");
    }

    public synchronized int getNumberOfInFlightFetches() {
        return this.cache.getInflightFetches();
    }

    protected abstract void reroute(String var1, String var2);

    synchronized void clearCacheForNode(String nodeId) {
        this.cache.remove(nodeId);
    }

    void asyncFetch(final DiscoveryNode[] nodes, final long fetchingRound) {
        this.logger.trace("{} fetching [{}] from {}", (Object)this.reroutingKey, (Object)this.type, (Object)nodes);
        this.action.list(this.shardAttributesMap, nodes, new ActionListener<BaseNodesResponse<T>>(){

            @Override
            public void onResponse(BaseNodesResponse<T> response) {
                AsyncShardFetch.this.processAsyncFetch(response.getNodes(), response.failures(), fetchingRound);
            }

            @Override
            public void onFailure(Exception e) {
                ArrayList<FailedNodeException> failures = new ArrayList<FailedNodeException>(nodes.length);
                for (DiscoveryNode node : nodes) {
                    failures.add(new FailedNodeException(node.getId(), "total failure in fetching", e));
                }
                AsyncShardFetch.this.processAsyncFetch(null, failures, fetchingRound);
            }
        });
    }

    public static interface Lister<NodesResponse extends BaseNodesResponse<NodeResponse>, NodeResponse extends BaseNodeResponse> {
        public void list(Map<ShardId, ShardAttributes> var1, DiscoveryNode[] var2, ActionListener<NodesResponse> var3);
    }

    static class ShardCache<K extends BaseNodeResponse>
    extends AsyncShardFetchCache<K> {
        private final Map<String, NodeEntry<K>> cache = new HashMap<String, NodeEntry<K>>();

        public ShardCache(Logger logger, String logKey, String type, ClusterManagerMetrics clusterManagerMetrics) {
            super(Loggers.getLogger(logger, "_" + logKey), type, clusterManagerMetrics);
        }

        @Override
        public void initData(DiscoveryNode node) {
            this.cache.put(node.getId(), new NodeEntry(node.getId()));
        }

        @Override
        public void putData(DiscoveryNode node, K response) {
            this.cache.get(node.getId()).doneFetching(response);
        }

        @Override
        public K getData(DiscoveryNode node) {
            return this.cache.get(node.getId()).getValue();
        }

        @Override
        @NonNull
        public Map<String, ? extends AsyncShardFetchCache.BaseNodeEntry> getCache() {
            return this.cache;
        }

        @Override
        public void deleteShard(ShardId shardId) {
            this.cache.clear();
        }

        static class NodeEntry<U extends BaseNodeResponse>
        extends AsyncShardFetchCache.BaseNodeEntry {
            @Nullable
            private U value;

            void doneFetching(U value) {
                super.doneFetching();
                this.value = value;
            }

            NodeEntry(String nodeId) {
                super(nodeId);
            }

            U getValue() {
                return this.value;
            }
        }
    }

    public static class FetchResult<T extends BaseNodeResponse> {
        private final Map<DiscoveryNode, T> data;
        private final Map<ShardId, Set<String>> ignoredShardToNodes;

        public FetchResult(Map<DiscoveryNode, T> data, Map<ShardId, Set<String>> ignoreNodes) {
            this.data = data;
            this.ignoredShardToNodes = ignoreNodes;
        }

        public boolean hasData() {
            return this.data != null;
        }

        public Map<DiscoveryNode, T> getData() {
            assert (this.data != null) : "getData should only be called if there is data to be fetched, please check hasData first";
            return this.data;
        }

        public void processAllocation(RoutingAllocation allocation) {
            for (Map.Entry<ShardId, Set<String>> entry : this.ignoredShardToNodes.entrySet()) {
                ShardId shardId = entry.getKey();
                Set<String> ignoreNodes = entry.getValue();
                if (ignoreNodes.isEmpty()) continue;
                ignoreNodes.forEach(nodeId -> allocation.addIgnoreShardForNode(shardId, (String)nodeId));
            }
        }
    }
}

