/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.gateway;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.logging.log4j.Logger;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.node.DiscoveryNode;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.routing.RoutingNodes;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.routing.ShardRouting;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.routing.ShardRoutingState;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.routing.UnassignedInfo;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.routing.allocation.AllocateUnassignedDecision;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.routing.allocation.NodeAllocationResult;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.routing.allocation.RoutingAllocation;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.routing.allocation.decider.Decision;
import org.graylog.shaded.opensearch2.org.opensearch.common.collect.Tuple;
import org.graylog.shaded.opensearch2.org.opensearch.core.index.shard.ShardId;
import org.graylog.shaded.opensearch2.org.opensearch.gateway.AsyncShardFetch;
import org.graylog.shaded.opensearch2.org.opensearch.gateway.ReplicaShardAllocator;
import org.graylog.shaded.opensearch2.org.opensearch.indices.store.TransportNodesListShardStoreMetadata;
import org.graylog.shaded.opensearch2.org.opensearch.indices.store.TransportNodesListShardStoreMetadataBatch;
import org.graylog.shaded.opensearch2.org.opensearch.indices.store.TransportNodesListShardStoreMetadataHelper;

public abstract class ReplicaShardBatchAllocator
extends ReplicaShardAllocator {
    public void processExistingRecoveries(RoutingAllocation allocation, List<List<ShardRouting>> shardBatches) {
        ArrayList<Runnable> shardCancellationActions = new ArrayList<Runnable>();
        HashMap initReplicasFromRouting = new HashMap();
        allocation.routingNodes().shardsWithState(ShardRoutingState.INITIALIZING).stream().filter(r -> !r.primary()).forEach(r -> {
            initReplicasFromRouting.putIfAbsent(r.shardId(), new ArrayList());
            ((List)initReplicasFromRouting.get(r.shardId())).add(r);
        });
        for (List<ShardRouting> shardBatch : shardBatches) {
            ArrayList<ShardRouting> eligibleShards = new ArrayList<ShardRouting>();
            ArrayList<ShardRouting> ineligibleShards = new ArrayList<ShardRouting>();
            for (ShardRouting shard : shardBatch) {
                if (shard == null || shard.primary()) continue;
                if (!initReplicasFromRouting.containsKey(shard.shardId())) {
                    this.logger.trace("skipping the shardRouting {} as the state is updated in routing table", (Object)shard);
                    continue;
                }
                if (this.shouldSkipFetchForRecovery(shard)) continue;
                eligibleShards.add(shard);
            }
            AsyncShardFetch.FetchResult<TransportNodesListShardStoreMetadataBatch.NodeStoreFilesMetadataBatch> shardState = this.fetchData(eligibleShards, ineligibleShards, allocation);
            if (!shardState.hasData()) {
                this.logger.trace("{}: fetching new stores for initializing shard batch", eligibleShards);
                continue;
            }
            for (ShardRouting shard : eligibleShards) {
                for (ShardRouting initShardsFromAllocation : (List)initReplicasFromRouting.get(shard.shardId())) {
                    Map<DiscoveryNode, TransportNodesListShardStoreMetadataHelper.StoreFilesMetadata> nodeShardStores;
                    Runnable cancellationAction = this.cancelExistingRecoveryForBetterMatch(initShardsFromAllocation, allocation, nodeShardStores = this.convertToNodeStoreFilesMetadataMap(initShardsFromAllocation, shardState));
                    if (cancellationAction == null) continue;
                    shardCancellationActions.add(cancellationAction);
                }
            }
        }
        for (Runnable action : shardCancellationActions) {
            action.run();
        }
    }

    protected abstract AsyncShardFetch.FetchResult<TransportNodesListShardStoreMetadataBatch.NodeStoreFilesMetadataBatch> fetchData(List<ShardRouting> var1, List<ShardRouting> var2, RoutingAllocation var3);

    @Override
    protected AsyncShardFetch.FetchResult<TransportNodesListShardStoreMetadata.NodeStoreFilesMetadata> fetchData(ShardRouting shard, RoutingAllocation allocation) {
        this.logger.error("fetchData for single shard called via batch allocator");
        throw new IllegalStateException("ReplicaShardBatchAllocator should only be used for a batch of shards");
    }

    @Override
    public AllocateUnassignedDecision makeAllocationDecision(ShardRouting unassignedShard, RoutingAllocation allocation, Logger logger) {
        Supplier<Map<DiscoveryNode, TransportNodesListShardStoreMetadataHelper.StoreFilesMetadata>> fetchDataResultSupplier = () -> this.convertToNodeStoreFilesMetadataMap(unassignedShard, this.fetchData(List.of(unassignedShard), Collections.emptyList(), allocation));
        return this.getUnassignedShardAllocationDecision(unassignedShard, allocation, fetchDataResultSupplier);
    }

    public void allocateUnassignedBatch(List<ShardRouting> shardRoutings, RoutingAllocation allocation) {
        this.logger.trace("Starting shard allocation execution for unassigned replica shards: {}", (Object)shardRoutings.size());
        ArrayList<ShardRouting> eligibleShards = new ArrayList<ShardRouting>();
        ArrayList<ShardRouting> ineligibleShards = new ArrayList<ShardRouting>();
        HashMap<ShardRouting, Object> ineligibleShardAllocationDecisions = new HashMap<ShardRouting, Object>();
        for (ShardRouting shard : shardRoutings) {
            AllocateUnassignedDecision shardDecisionWithoutFetch = this.getUnassignedShardAllocationDecision(shard, allocation, null);
            if (shardDecisionWithoutFetch != null) {
                ineligibleShards.add(shard);
                ineligibleShardAllocationDecisions.put(shard, shardDecisionWithoutFetch);
                continue;
            }
            eligibleShards.add(shard);
        }
        AsyncShardFetch.FetchResult<TransportNodesListShardStoreMetadataBatch.NodeStoreFilesMetadataBatch> shardsState = this.fetchData(eligibleShards, ineligibleShards, allocation);
        HashSet<ShardId> shardIdsFromBatch = new HashSet<ShardId>();
        for (ShardRouting shardRouting : shardRoutings) {
            ShardId shardId = shardRouting.shardId();
            shardIdsFromBatch.add(shardId);
        }
        RoutingNodes.UnassignedShards.UnassignedIterator iterator = allocation.routingNodes().unassigned().iterator();
        while (iterator.hasNext()) {
            ShardRouting unassignedShard = iterator.next();
            if (unassignedShard.primary() || !shardIdsFromBatch.contains(unassignedShard.shardId())) continue;
            AllocateUnassignedDecision allocateUnassignedDecision = ineligibleShardAllocationDecisions.containsKey(unassignedShard) ? (AllocateUnassignedDecision)ineligibleShardAllocationDecisions.get(unassignedShard) : this.getUnassignedShardAllocationDecision(unassignedShard, allocation, () -> this.convertToNodeStoreFilesMetadataMap(unassignedShard, shardsState));
            this.executeDecision(unassignedShard, allocateUnassignedDecision, allocation, iterator);
        }
        this.logger.trace("Finished shard allocation execution for unassigned replica shards: {}", (Object)shardRoutings.size());
    }

    private AllocateUnassignedDecision getUnassignedShardAllocationDecision(ShardRouting shardRouting, RoutingAllocation allocation, Supplier<Map<DiscoveryNode, TransportNodesListShardStoreMetadataHelper.StoreFilesMetadata>> nodeStoreFileMetaDataMapSupplier) {
        if (!this.isResponsibleFor(shardRouting)) {
            return AllocateUnassignedDecision.NOT_TAKEN;
        }
        Tuple<Decision, Map<String, NodeAllocationResult>> result = ReplicaShardBatchAllocator.canBeAllocatedToAtLeastOneNode(shardRouting, allocation);
        boolean explain = allocation.debugDecision();
        Decision allocationDecision = result.v1();
        if (!(allocationDecision.type() == Decision.Type.YES || explain && this.hasInitiatedFetching(shardRouting))) {
            this.logger.trace("{}: ignoring allocation, can't be allocated on any node. Decision: {}", (Object)shardRouting, (Object)allocationDecision.type());
            return AllocateUnassignedDecision.no(UnassignedInfo.AllocationStatus.fromDecision(allocationDecision.type()), (List<NodeAllocationResult>)(result.v2() != null ? new ArrayList<NodeAllocationResult>(result.v2().values()) : null));
        }
        if (nodeStoreFileMetaDataMapSupplier != null) {
            Map<DiscoveryNode, TransportNodesListShardStoreMetadataHelper.StoreFilesMetadata> discoveryNodeStoreFilesMetadataMap = nodeStoreFileMetaDataMapSupplier.get();
            return this.getAllocationDecision(shardRouting, allocation, discoveryNodeStoreFilesMetadataMap, result, this.logger);
        }
        return null;
    }

    private Map<DiscoveryNode, TransportNodesListShardStoreMetadataHelper.StoreFilesMetadata> convertToNodeStoreFilesMetadataMap(ShardRouting unassignedShard, AsyncShardFetch.FetchResult<TransportNodesListShardStoreMetadataBatch.NodeStoreFilesMetadataBatch> data) {
        if (!data.hasData()) {
            return null;
        }
        HashMap<DiscoveryNode, TransportNodesListShardStoreMetadataHelper.StoreFilesMetadata> map = new HashMap<DiscoveryNode, TransportNodesListShardStoreMetadataHelper.StoreFilesMetadata>();
        data.getData().forEach((discoveryNode, value) -> {
            Map<ShardId, TransportNodesListShardStoreMetadataBatch.NodeStoreFilesMetadata> batch = value.getNodeStoreFilesMetadataBatch();
            TransportNodesListShardStoreMetadataBatch.NodeStoreFilesMetadata metadata = batch.get(unassignedShard.shardId());
            if (metadata != null) {
                map.put((DiscoveryNode)discoveryNode, metadata.storeFilesMetadata());
            }
        });
        return map;
    }
}

