/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.gateway;

import java.io.IOException;
import java.util.Objects;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.graylog.shaded.opensearch2.org.opensearch.OpenSearchException;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.metadata.IndexMetadata;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.node.DiscoveryNode;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.service.ClusterService;
import org.graylog.shaded.opensearch2.org.opensearch.common.settings.Settings;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.io.stream.StreamInput;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.io.stream.StreamOutput;
import org.graylog.shaded.opensearch2.org.opensearch.core.index.shard.ShardId;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.NamedXContentRegistry;
import org.graylog.shaded.opensearch2.org.opensearch.env.NodeEnvironment;
import org.graylog.shaded.opensearch2.org.opensearch.index.IndexSettings;
import org.graylog.shaded.opensearch2.org.opensearch.index.shard.IndexShard;
import org.graylog.shaded.opensearch2.org.opensearch.index.shard.ShardPath;
import org.graylog.shaded.opensearch2.org.opensearch.index.shard.ShardStateMetadata;
import org.graylog.shaded.opensearch2.org.opensearch.index.store.Store;
import org.graylog.shaded.opensearch2.org.opensearch.indices.IndicesService;
import org.graylog.shaded.opensearch2.org.opensearch.indices.replication.checkpoint.ReplicationCheckpoint;

public class TransportNodesGatewayStartedShardHelper {
    public static final String INDEX_NOT_FOUND = "node doesn't have meta data for index";

    public static GatewayStartedShard getShardInfoOnLocalNode(Logger logger, ShardId shardId, NamedXContentRegistry namedXContentRegistry, NodeEnvironment nodeEnv, IndicesService indicesService, String shardDataPathInRequest, Settings settings, ClusterService clusterService) throws IOException {
        logger.trace("{} loading local shard state info", (Object)shardId);
        ShardStateMetadata shardStateMetadata = ShardStateMetadata.FORMAT.loadLatestState(logger, namedXContentRegistry, nodeEnv.availableShardPaths(shardId));
        if (shardStateMetadata != null) {
            if (indicesService.getShardOrNull(shardId) == null && shardStateMetadata.indexDataLocation == ShardStateMetadata.IndexDataLocation.LOCAL) {
                String customDataPath;
                if (shardDataPathInRequest != null) {
                    customDataPath = shardDataPathInRequest;
                } else {
                    IndexMetadata metadata = clusterService.state().metadata().index(shardId.getIndex());
                    if (metadata != null) {
                        customDataPath = new IndexSettings(metadata, settings).customDataPath();
                    } else {
                        logger.trace("{} node doesn't have meta data for the requests index", (Object)shardId);
                        throw new OpenSearchException("node doesn't have meta data for index " + String.valueOf(shardId.getIndex()), new Object[0]);
                    }
                }
                ShardPath shardPath = null;
                try {
                    shardPath = ShardPath.loadShardPath(logger, nodeEnv, shardId, customDataPath);
                    if (shardPath == null) {
                        throw new IllegalStateException(String.valueOf(shardId) + " no shard path found");
                    }
                    Store.tryOpenIndex(shardPath.resolveIndex(), shardId, nodeEnv::shardLock, logger);
                }
                catch (Exception exception) {
                    ShardPath finalShardPath = shardPath;
                    logger.trace(() -> new ParameterizedMessage("{} can't open index for shard [{}] in path [{}]", new Object[]{shardId, shardStateMetadata, finalShardPath != null ? finalShardPath.resolveIndex() : ""}), (Throwable)exception);
                    String allocationId = shardStateMetadata.allocationId != null ? shardStateMetadata.allocationId.getId() : null;
                    return new GatewayStartedShard(allocationId, shardStateMetadata.primary, null, exception);
                }
            }
            logger.debug("{} shard state info found: [{}]", (Object)shardId, (Object)shardStateMetadata);
            String allocationId = shardStateMetadata.allocationId != null ? shardStateMetadata.allocationId.getId() : null;
            IndexShard shard = (IndexShard)indicesService.getShardOrNull(shardId);
            return new GatewayStartedShard(allocationId, shardStateMetadata.primary, shard != null ? shard.getLatestReplicationCheckpoint() : null);
        }
        logger.trace("{} no local shard info found", (Object)shardId);
        return new GatewayStartedShard(null, false, null);
    }

    public static class GatewayStartedShard {
        private final String allocationId;
        private final boolean primary;
        private final Exception storeException;
        private final ReplicationCheckpoint replicationCheckpoint;

        public GatewayStartedShard(StreamInput in) throws IOException {
            this.allocationId = in.readOptionalString();
            this.primary = in.readBoolean();
            this.storeException = in.readBoolean() ? in.readException() : null;
            this.replicationCheckpoint = in.readBoolean() ? new ReplicationCheckpoint(in) : null;
        }

        public GatewayStartedShard(String allocationId, boolean primary, ReplicationCheckpoint replicationCheckpoint) {
            this(allocationId, primary, replicationCheckpoint, null);
        }

        public GatewayStartedShard(String allocationId, boolean primary, ReplicationCheckpoint replicationCheckpoint, Exception storeException) {
            this.allocationId = allocationId;
            this.primary = primary;
            this.replicationCheckpoint = replicationCheckpoint;
            this.storeException = storeException;
        }

        public String allocationId() {
            return this.allocationId;
        }

        public boolean primary() {
            return this.primary;
        }

        public ReplicationCheckpoint replicationCheckpoint() {
            return this.replicationCheckpoint;
        }

        public Exception storeException() {
            return this.storeException;
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeOptionalString(this.allocationId);
            out.writeBoolean(this.primary);
            if (this.storeException != null) {
                out.writeBoolean(true);
                out.writeException(this.storeException);
            } else {
                out.writeBoolean(false);
            }
            if (this.replicationCheckpoint != null) {
                out.writeBoolean(true);
                this.replicationCheckpoint.writeTo(out);
            } else {
                out.writeBoolean(false);
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            GatewayStartedShard that = (GatewayStartedShard)o;
            return this.primary == that.primary && Objects.equals(this.allocationId, that.allocationId) && Objects.equals(this.storeException, that.storeException) && Objects.equals(this.replicationCheckpoint, that.replicationCheckpoint);
        }

        public int hashCode() {
            int result = this.allocationId != null ? this.allocationId.hashCode() : 0;
            result = 31 * result + (this.primary ? 1 : 0);
            result = 31 * result + (this.storeException != null ? this.storeException.hashCode() : 0);
            result = 31 * result + (this.replicationCheckpoint != null ? this.replicationCheckpoint.hashCode() : 0);
            return result;
        }

        public String toString() {
            StringBuilder buf = new StringBuilder();
            buf.append("NodeGatewayStartedShards[").append("allocationId=").append(this.allocationId).append(",primary=").append(this.primary);
            if (this.storeException != null) {
                buf.append(",storeException=").append(this.storeException);
            }
            if (this.replicationCheckpoint != null) {
                buf.append(",ReplicationCheckpoint=").append(this.replicationCheckpoint.toString());
            }
            buf.append("]");
            return buf.toString();
        }

        public static boolean isEmpty(GatewayStartedShard gatewayStartedShard) {
            return gatewayStartedShard.allocationId() == null && !gatewayStartedShard.primary() && gatewayStartedShard.storeException() == null && gatewayStartedShard.replicationCheckpoint() == null;
        }
    }

    public static class NodeGatewayStartedShard
    extends GatewayStartedShard {
        private final DiscoveryNode node;

        public NodeGatewayStartedShard(String allocationId, boolean primary, ReplicationCheckpoint replicationCheckpoint, Exception storeException, DiscoveryNode node) {
            super(allocationId, primary, replicationCheckpoint, storeException);
            this.node = node;
        }

        public DiscoveryNode getNode() {
            return this.node;
        }
    }
}

