/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.gateway;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.graylog.shaded.opensearch2.org.opensearch.action.ActionType;
import org.graylog.shaded.opensearch2.org.opensearch.action.FailedNodeException;
import org.graylog.shaded.opensearch2.org.opensearch.action.support.ActionFilters;
import org.graylog.shaded.opensearch2.org.opensearch.action.support.nodes.BaseNodeRequest;
import org.graylog.shaded.opensearch2.org.opensearch.action.support.nodes.BaseNodeResponse;
import org.graylog.shaded.opensearch2.org.opensearch.action.support.nodes.BaseNodesRequest;
import org.graylog.shaded.opensearch2.org.opensearch.action.support.nodes.BaseNodesResponse;
import org.graylog.shaded.opensearch2.org.opensearch.action.support.nodes.TransportNodesAction;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.ClusterName;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.node.DiscoveryNode;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.service.ClusterService;
import org.graylog.shaded.opensearch2.org.opensearch.common.inject.Inject;
import org.graylog.shaded.opensearch2.org.opensearch.common.settings.Settings;
import org.graylog.shaded.opensearch2.org.opensearch.core.action.ActionListener;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.io.stream.StreamInput;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.io.stream.StreamOutput;
import org.graylog.shaded.opensearch2.org.opensearch.core.index.shard.ShardId;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.NamedXContentRegistry;
import org.graylog.shaded.opensearch2.org.opensearch.env.NodeEnvironment;
import org.graylog.shaded.opensearch2.org.opensearch.gateway.AsyncShardFetch;
import org.graylog.shaded.opensearch2.org.opensearch.gateway.TransportNodesGatewayStartedShardHelper;
import org.graylog.shaded.opensearch2.org.opensearch.indices.IndicesService;
import org.graylog.shaded.opensearch2.org.opensearch.indices.store.ShardAttributes;
import org.graylog.shaded.opensearch2.org.opensearch.threadpool.ThreadPool;
import org.graylog.shaded.opensearch2.org.opensearch.transport.TransportService;

public class TransportNodesListGatewayStartedShardsBatch
extends TransportNodesAction<Request, NodesGatewayStartedShardsBatch, NodeRequest, NodeGatewayStartedShardsBatch>
implements AsyncShardFetch.Lister<NodesGatewayStartedShardsBatch, NodeGatewayStartedShardsBatch> {
    public static final String ACTION_NAME = "internal:gateway/local/started_shards_batch";
    public static final ActionType<NodesGatewayStartedShardsBatch> TYPE = new ActionType<NodesGatewayStartedShardsBatch>("internal:gateway/local/started_shards_batch", NodesGatewayStartedShardsBatch::new);
    private final Settings settings;
    private final NodeEnvironment nodeEnv;
    private final IndicesService indicesService;
    private final NamedXContentRegistry namedXContentRegistry;

    @Inject
    public TransportNodesListGatewayStartedShardsBatch(Settings settings, ThreadPool threadPool, ClusterService clusterService, TransportService transportService, ActionFilters actionFilters, NodeEnvironment env, IndicesService indicesService, NamedXContentRegistry namedXContentRegistry) {
        super(ACTION_NAME, threadPool, clusterService, transportService, actionFilters, Request::new, NodeRequest::new, "fetch_shard_started", NodeGatewayStartedShardsBatch.class);
        this.settings = settings;
        this.nodeEnv = env;
        this.indicesService = indicesService;
        this.namedXContentRegistry = namedXContentRegistry;
    }

    @Override
    public void list(Map<ShardId, ShardAttributes> shardAttributesMap, DiscoveryNode[] nodes, ActionListener<NodesGatewayStartedShardsBatch> listener) {
        this.execute(new Request(nodes, shardAttributesMap), listener);
    }

    @Override
    protected NodeRequest newNodeRequest(Request request) {
        return new NodeRequest(request);
    }

    @Override
    protected NodeGatewayStartedShardsBatch newNodeResponse(StreamInput in) throws IOException {
        return new NodeGatewayStartedShardsBatch(in);
    }

    @Override
    protected NodesGatewayStartedShardsBatch newResponse(Request request, List<NodeGatewayStartedShardsBatch> responses, List<FailedNodeException> failures) {
        return new NodesGatewayStartedShardsBatch(this.clusterService.getClusterName(), responses, failures);
    }

    @Override
    protected NodeGatewayStartedShardsBatch nodeOperation(NodeRequest request) {
        HashMap<ShardId, TransportNodesGatewayStartedShardHelper.GatewayStartedShard> shardsOnNode = new HashMap<ShardId, TransportNodesGatewayStartedShardHelper.GatewayStartedShard>();
        for (Map.Entry<ShardId, ShardAttributes> shardAttr : request.shardAttributes.entrySet()) {
            ShardId shardId = shardAttr.getKey();
            try {
                shardsOnNode.put(shardId, TransportNodesGatewayStartedShardHelper.getShardInfoOnLocalNode(this.logger, shardId, this.namedXContentRegistry, this.nodeEnv, this.indicesService, shardAttr.getValue().getCustomDataPath(), this.settings, this.clusterService));
            }
            catch (Exception e) {
                if (e instanceof IllegalStateException || e.getMessage().contains("node doesn't have meta data for index") || e instanceof IOException) {
                    shardsOnNode.put(shardId, null);
                    continue;
                }
                shardsOnNode.put(shardId, new TransportNodesGatewayStartedShardHelper.GatewayStartedShard(null, false, null, e));
            }
        }
        return new NodeGatewayStartedShardsBatch(this.clusterService.localNode(), shardsOnNode);
    }

    public static class NodeGatewayStartedShardsBatch
    extends BaseNodeResponse {
        private final Map<ShardId, TransportNodesGatewayStartedShardHelper.GatewayStartedShard> nodeGatewayStartedShardsBatch;

        public Map<ShardId, TransportNodesGatewayStartedShardHelper.GatewayStartedShard> getNodeGatewayStartedShardsBatch() {
            return this.nodeGatewayStartedShardsBatch;
        }

        public NodeGatewayStartedShardsBatch(StreamInput in) throws IOException {
            super(in);
            this.nodeGatewayStartedShardsBatch = in.readMap(ShardId::new, i -> {
                if (i.readBoolean()) {
                    return new TransportNodesGatewayStartedShardHelper.GatewayStartedShard(i);
                }
                return null;
            });
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeMap(this.nodeGatewayStartedShardsBatch, (o, k) -> k.writeTo(o), (o, v) -> {
                if (v != null) {
                    o.writeBoolean(true);
                    v.writeTo(o);
                } else {
                    o.writeBoolean(false);
                }
            });
        }

        public NodeGatewayStartedShardsBatch(DiscoveryNode node, Map<ShardId, TransportNodesGatewayStartedShardHelper.GatewayStartedShard> nodeGatewayStartedShardsBatch) {
            super(node);
            this.nodeGatewayStartedShardsBatch = nodeGatewayStartedShardsBatch;
        }
    }

    public static class Request
    extends BaseNodesRequest<Request> {
        private final Map<ShardId, ShardAttributes> shardAttributes;

        public Request(StreamInput in) throws IOException {
            super(in);
            this.shardAttributes = in.readMap(ShardId::new, ShardAttributes::new);
        }

        public Request(DiscoveryNode[] nodes, Map<ShardId, ShardAttributes> shardAttributes) {
            super(false, nodes);
            this.shardAttributes = Objects.requireNonNull(shardAttributes);
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeMap(this.shardAttributes, (o, k) -> k.writeTo(o), (o, v) -> v.writeTo(o));
        }

        public Map<ShardId, ShardAttributes> getShardAttributes() {
            return this.shardAttributes;
        }
    }

    public static class NodeRequest
    extends BaseNodeRequest {
        private final Map<ShardId, ShardAttributes> shardAttributes;

        public NodeRequest(StreamInput in) throws IOException {
            super(in);
            this.shardAttributes = in.readMap(ShardId::new, ShardAttributes::new);
        }

        public NodeRequest(Request request) {
            this.shardAttributes = Objects.requireNonNull(request.getShardAttributes());
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeMap(this.shardAttributes, (o, k) -> k.writeTo(o), (o, v) -> v.writeTo(o));
        }
    }

    public static class NodesGatewayStartedShardsBatch
    extends BaseNodesResponse<NodeGatewayStartedShardsBatch> {
        public NodesGatewayStartedShardsBatch(StreamInput in) throws IOException {
            super(in);
        }

        public NodesGatewayStartedShardsBatch(ClusterName clusterName, List<NodeGatewayStartedShardsBatch> nodes, List<FailedNodeException> failures) {
            super(clusterName, nodes, failures);
        }

        @Override
        protected List<NodeGatewayStartedShardsBatch> readNodesFrom(StreamInput in) throws IOException {
            return in.readList(NodeGatewayStartedShardsBatch::new);
        }

        @Override
        protected void writeNodesTo(StreamOutput out, List<NodeGatewayStartedShardsBatch> nodes) throws IOException {
            out.writeList(nodes);
        }
    }
}

