/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.gateway.remote;

import java.util.Collections;
import java.util.Map;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.ClusterState;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.DiffableUtils;
import org.graylog.shaded.opensearch2.org.opensearch.common.remote.AbstractClusterMetadataWriteableBlobEntity;
import org.graylog.shaded.opensearch2.org.opensearch.common.remote.AbstractRemoteWritableEntityManager;
import org.graylog.shaded.opensearch2.org.opensearch.common.remote.RemoteWriteableEntityBlobStore;
import org.graylog.shaded.opensearch2.org.opensearch.core.action.ActionListener;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.io.stream.NamedWriteableRegistry;
import org.graylog.shaded.opensearch2.org.opensearch.gateway.remote.ClusterMetadataManifest;
import org.graylog.shaded.opensearch2.org.opensearch.gateway.remote.RemoteStateTransferException;
import org.graylog.shaded.opensearch2.org.opensearch.gateway.remote.model.RemoteReadResult;
import org.graylog.shaded.opensearch2.org.opensearch.index.translog.transfer.BlobStoreTransferService;
import org.graylog.shaded.opensearch2.org.opensearch.repositories.blobstore.BlobStoreRepository;
import org.graylog.shaded.opensearch2.org.opensearch.threadpool.ThreadPool;

public class RemoteClusterStateAttributesManager
extends AbstractRemoteWritableEntityManager {
    public static final String CLUSTER_STATE_ATTRIBUTE = "cluster_state_attribute";
    public static final String DISCOVERY_NODES = "nodes";
    public static final String CLUSTER_BLOCKS = "blocks";
    public static final int CLUSTER_STATE_ATTRIBUTES_CURRENT_CODEC_VERSION = 1;

    RemoteClusterStateAttributesManager(String clusterName, BlobStoreRepository blobStoreRepository, BlobStoreTransferService blobStoreTransferService, NamedWriteableRegistry namedWriteableRegistry, ThreadPool threadpool) {
        this.remoteWritableEntityStores.put(DISCOVERY_NODES, new RemoteWriteableEntityBlobStore(blobStoreTransferService, blobStoreRepository, clusterName, threadpool, "remote_state_read", "cluster-state"));
        this.remoteWritableEntityStores.put(CLUSTER_BLOCKS, new RemoteWriteableEntityBlobStore(blobStoreTransferService, blobStoreRepository, clusterName, threadpool, "remote_state_read", "cluster-state"));
        this.remoteWritableEntityStores.put("cluster-state-custom", new RemoteWriteableEntityBlobStore(blobStoreTransferService, blobStoreRepository, clusterName, threadpool, "remote_state_read", "cluster-state"));
    }

    @Override
    protected ActionListener<Void> getWrappedWriteListener(String component, AbstractClusterMetadataWriteableBlobEntity remoteEntity, ActionListener<ClusterMetadataManifest.UploadedMetadata> listener) {
        return ActionListener.wrap(resp -> listener.onResponse(remoteEntity.getUploadedMetadata()), ex -> listener.onFailure(new RemoteStateTransferException("Upload failed for " + component, remoteEntity, (Throwable)ex)));
    }

    @Override
    protected ActionListener<Object> getWrappedReadListener(String component, AbstractClusterMetadataWriteableBlobEntity remoteEntity, ActionListener<RemoteReadResult> listener) {
        return ActionListener.wrap(response -> listener.onResponse(new RemoteReadResult(response, CLUSTER_STATE_ATTRIBUTE, component)), ex -> listener.onFailure(new RemoteStateTransferException("Download failed for " + component, remoteEntity, (Throwable)ex)));
    }

    public DiffableUtils.MapDiff<String, ClusterState.Custom, Map<String, ClusterState.Custom>> getUpdatedCustoms(ClusterState clusterState, ClusterState previousClusterState, boolean isRemotePublicationEnabled, boolean isFirstUpload) {
        if (!isRemotePublicationEnabled) {
            return DiffableUtils.diff(Collections.emptyMap(), Collections.emptyMap(), DiffableUtils.getStringKeySerializer(), DiffableUtils.NonDiffableValueSerializer.getAbstractInstance());
        }
        if (isFirstUpload) {
            return DiffableUtils.diff(Collections.emptyMap(), clusterState.customs(), DiffableUtils.getStringKeySerializer(), DiffableUtils.NonDiffableValueSerializer.getAbstractInstance());
        }
        return DiffableUtils.diff(previousClusterState.customs(), clusterState.customs(), DiffableUtils.getStringKeySerializer(), DiffableUtils.NonDiffableValueSerializer.getAbstractInstance());
    }
}

