/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.gateway.remote;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.function.LongSupplier;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.graylog.shaded.opensearch2.org.opensearch.action.LatchedActionListener;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.ClusterName;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.ClusterState;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.Diff;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.DiffableUtils;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.block.ClusterBlocks;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.coordination.CoordinationMetadata;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.coordination.PersistedStateStats;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.metadata.DiffableStringMap;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.metadata.IndexMetadata;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.metadata.Metadata;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.metadata.TemplatesMetadata;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.node.DiscoveryNodes;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.routing.IndexRoutingTable;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.routing.RoutingTable;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.routing.StringKeyDiffProvider;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.routing.remote.RemoteRoutingTableService;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.routing.remote.RemoteRoutingTableServiceFactory;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.service.ClusterService;
import org.graylog.shaded.opensearch2.org.opensearch.common.Nullable;
import org.graylog.shaded.opensearch2.org.opensearch.common.annotation.InternalApi;
import org.graylog.shaded.opensearch2.org.opensearch.common.blobstore.BlobContainer;
import org.graylog.shaded.opensearch2.org.opensearch.common.blobstore.BlobStore;
import org.graylog.shaded.opensearch2.org.opensearch.common.settings.ClusterSettings;
import org.graylog.shaded.opensearch2.org.opensearch.common.settings.Setting;
import org.graylog.shaded.opensearch2.org.opensearch.common.settings.Settings;
import org.graylog.shaded.opensearch2.org.opensearch.common.unit.TimeValue;
import org.graylog.shaded.opensearch2.org.opensearch.common.util.io.IOUtils;
import org.graylog.shaded.opensearch2.org.opensearch.core.action.ActionListener;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.io.stream.NamedWriteableRegistry;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.ToXContent;
import org.graylog.shaded.opensearch2.org.opensearch.gateway.PersistedClusterStateService;
import org.graylog.shaded.opensearch2.org.opensearch.gateway.remote.ClusterMetadataManifest;
import org.graylog.shaded.opensearch2.org.opensearch.gateway.remote.ClusterStateChecksum;
import org.graylog.shaded.opensearch2.org.opensearch.gateway.remote.ClusterStateDiffManifest;
import org.graylog.shaded.opensearch2.org.opensearch.gateway.remote.IndexMetadataUploadListener;
import org.graylog.shaded.opensearch2.org.opensearch.gateway.remote.RemoteClusterStateAttributesManager;
import org.graylog.shaded.opensearch2.org.opensearch.gateway.remote.RemoteClusterStateCache;
import org.graylog.shaded.opensearch2.org.opensearch.gateway.remote.RemoteClusterStateCleanupManager;
import org.graylog.shaded.opensearch2.org.opensearch.gateway.remote.RemoteClusterStateUtils;
import org.graylog.shaded.opensearch2.org.opensearch.gateway.remote.RemoteGlobalMetadataManager;
import org.graylog.shaded.opensearch2.org.opensearch.gateway.remote.RemoteIndexMetadataManager;
import org.graylog.shaded.opensearch2.org.opensearch.gateway.remote.RemoteManifestManager;
import org.graylog.shaded.opensearch2.org.opensearch.gateway.remote.RemotePersistenceStats;
import org.graylog.shaded.opensearch2.org.opensearch.gateway.remote.RemoteStateTransferException;
import org.graylog.shaded.opensearch2.org.opensearch.gateway.remote.model.RemoteClusterBlocks;
import org.graylog.shaded.opensearch2.org.opensearch.gateway.remote.model.RemoteClusterStateCustoms;
import org.graylog.shaded.opensearch2.org.opensearch.gateway.remote.model.RemoteClusterStateManifestInfo;
import org.graylog.shaded.opensearch2.org.opensearch.gateway.remote.model.RemoteCoordinationMetadata;
import org.graylog.shaded.opensearch2.org.opensearch.gateway.remote.model.RemoteCustomMetadata;
import org.graylog.shaded.opensearch2.org.opensearch.gateway.remote.model.RemoteDiscoveryNodes;
import org.graylog.shaded.opensearch2.org.opensearch.gateway.remote.model.RemoteHashesOfConsistentSettings;
import org.graylog.shaded.opensearch2.org.opensearch.gateway.remote.model.RemoteIndexMetadata;
import org.graylog.shaded.opensearch2.org.opensearch.gateway.remote.model.RemotePersistentSettingsMetadata;
import org.graylog.shaded.opensearch2.org.opensearch.gateway.remote.model.RemoteReadResult;
import org.graylog.shaded.opensearch2.org.opensearch.gateway.remote.model.RemoteTemplatesMetadata;
import org.graylog.shaded.opensearch2.org.opensearch.gateway.remote.model.RemoteTransientSettingsMetadata;
import org.graylog.shaded.opensearch2.org.opensearch.index.translog.transfer.BlobStoreTransferService;
import org.graylog.shaded.opensearch2.org.opensearch.node.remotestore.RemoteStoreNodeAttribute;
import org.graylog.shaded.opensearch2.org.opensearch.repositories.RepositoriesService;
import org.graylog.shaded.opensearch2.org.opensearch.repositories.Repository;
import org.graylog.shaded.opensearch2.org.opensearch.repositories.blobstore.BlobStoreRepository;
import org.graylog.shaded.opensearch2.org.opensearch.threadpool.ThreadPool;

@InternalApi
public class RemoteClusterStateService
implements Closeable {
    private static final Logger logger = LogManager.getLogger(RemoteClusterStateService.class);
    public static final String REMOTE_PUBLICATION_SETTING_KEY = "cluster.remote_store.publication.enabled";
    public static final Setting<Boolean> REMOTE_PUBLICATION_SETTING = Setting.boolSetting("cluster.remote_store.publication.enabled", false, Setting.Property.NodeScope, Setting.Property.Dynamic);
    public static final Setting<Boolean> REMOTE_CLUSTER_STATE_ENABLED_SETTING = Setting.boolSetting("cluster.remote_store.state.enabled", false, Setting.Property.NodeScope, Setting.Property.Final);
    public static final TimeValue REMOTE_STATE_READ_TIMEOUT_DEFAULT = TimeValue.timeValueMillis(20000L);
    public static final Setting<TimeValue> REMOTE_STATE_READ_TIMEOUT_SETTING = Setting.timeSetting("cluster.remote_store.state.read_timeout", REMOTE_STATE_READ_TIMEOUT_DEFAULT, Setting.Property.Dynamic, Setting.Property.NodeScope);
    public static final Setting<RemoteClusterStateValidationMode> REMOTE_CLUSTER_STATE_CHECKSUM_VALIDATION_MODE_SETTING = new Setting<RemoteClusterStateValidationMode>("cluster.remote_store.state.checksum_validation.mode", RemoteClusterStateValidationMode.NONE.name(), RemoteClusterStateValidationMode::parseString, Setting.Property.Dynamic, Setting.Property.NodeScope);
    public static final Setting<String> CLUSTER_REMOTE_STORE_STATE_PATH_PREFIX = Setting.simpleString("cluster.remote_store.state.path.prefix", "", Setting.Property.NodeScope, Setting.Property.Final);
    private TimeValue remoteStateReadTimeout;
    private final String nodeId;
    private final Supplier<RepositoriesService> repositoriesService;
    private final Settings settings;
    private final LongSupplier relativeTimeNanosSupplier;
    private final ThreadPool threadpool;
    private final List<IndexMetadataUploadListener> indexMetadataUploadListeners;
    private BlobStoreRepository blobStoreRepository;
    private BlobStoreTransferService blobStoreTransferService;
    private RemoteRoutingTableService remoteRoutingTableService;
    private volatile TimeValue slowWriteLoggingThreshold;
    private RemoteClusterStateValidationMode remoteClusterStateValidationMode;
    private final RemotePersistenceStats remoteStateStats;
    private RemoteClusterStateCleanupManager remoteClusterStateCleanupManager;
    private RemoteIndexMetadataManager remoteIndexMetadataManager;
    private RemoteGlobalMetadataManager remoteGlobalMetadataManager;
    private RemoteClusterStateAttributesManager remoteClusterStateAttributesManager;
    private RemoteManifestManager remoteManifestManager;
    private ClusterSettings clusterSettings;
    private final NamedWriteableRegistry namedWriteableRegistry;
    private final String CLUSTER_STATE_UPLOAD_TIME_LOG_STRING = "writing cluster state for version [{}] took [{}ms]";
    private final String METADATA_UPDATE_LOG_STRING = "wrote metadata for [{}] indices and skipped [{}] unchanged indices, coordination metadata updated : [{}], settings metadata updated : [{}], templates metadata updated : [{}], custom metadata updated : [{}], indices routing updated : [{}]";
    private volatile AtomicBoolean isPublicationEnabled;
    private final String remotePathPrefix;
    private final RemoteClusterStateCache remoteClusterStateCache;
    public static final ToXContent.Params FORMAT_PARAMS;

    public RemoteClusterStateService(String nodeId, Supplier<RepositoriesService> repositoriesService, Settings settings, ClusterService clusterService, LongSupplier relativeTimeNanosSupplier, ThreadPool threadPool, List<IndexMetadataUploadListener> indexMetadataUploadListeners, NamedWriteableRegistry namedWriteableRegistry) {
        assert (RemoteStoreNodeAttribute.isRemoteClusterStateConfigured(settings)) : "Remote cluster state is not configured";
        this.nodeId = nodeId;
        this.repositoriesService = repositoriesService;
        this.settings = settings;
        this.relativeTimeNanosSupplier = relativeTimeNanosSupplier;
        this.threadpool = threadPool;
        this.clusterSettings = clusterService.getClusterSettings();
        this.slowWriteLoggingThreshold = this.clusterSettings.get(PersistedClusterStateService.SLOW_WRITE_LOGGING_THRESHOLD);
        this.clusterSettings.addSettingsUpdateConsumer(PersistedClusterStateService.SLOW_WRITE_LOGGING_THRESHOLD, this::setSlowWriteLoggingThreshold);
        this.remoteStateReadTimeout = this.clusterSettings.get(REMOTE_STATE_READ_TIMEOUT_SETTING);
        this.clusterSettings.addSettingsUpdateConsumer(REMOTE_STATE_READ_TIMEOUT_SETTING, this::setRemoteStateReadTimeout);
        this.remoteClusterStateValidationMode = REMOTE_CLUSTER_STATE_CHECKSUM_VALIDATION_MODE_SETTING.get(settings);
        this.clusterSettings.addSettingsUpdateConsumer(REMOTE_CLUSTER_STATE_CHECKSUM_VALIDATION_MODE_SETTING, this::setChecksumValidationMode);
        this.remoteStateStats = new RemotePersistenceStats();
        this.namedWriteableRegistry = namedWriteableRegistry;
        this.indexMetadataUploadListeners = indexMetadataUploadListeners;
        this.isPublicationEnabled = new AtomicBoolean(this.clusterSettings.get(REMOTE_PUBLICATION_SETTING) != false && RemoteStoreNodeAttribute.isRemoteStoreClusterStateEnabled(settings) && RemoteStoreNodeAttribute.isRemoteRoutingTableConfigured(settings));
        this.clusterSettings.addSettingsUpdateConsumer(REMOTE_PUBLICATION_SETTING, this::setRemotePublicationSetting);
        this.remotePathPrefix = CLUSTER_REMOTE_STORE_STATE_PATH_PREFIX.get(settings);
        this.remoteRoutingTableService = RemoteRoutingTableServiceFactory.getService(repositoriesService, settings, this.clusterSettings, this.threadpool, ClusterName.CLUSTER_NAME_SETTING.get(settings).value());
        this.remoteClusterStateCleanupManager = new RemoteClusterStateCleanupManager(this, clusterService, this.remoteRoutingTableService);
        this.remoteClusterStateCache = new RemoteClusterStateCache();
    }

    @Nullable
    public RemoteClusterStateManifestInfo writeFullMetadata(ClusterState clusterState, String previousClusterUUID) throws IOException {
        long startTimeNanos = this.relativeTimeNanosSupplier.getAsLong();
        if (!clusterState.nodes().isLocalNodeElectedClusterManager()) {
            logger.error("Local node is not elected cluster manager. Exiting");
            return null;
        }
        boolean publicationEnabled = this.isPublicationEnabled.get();
        RemoteClusterStateUtils.UploadedMetadataResults uploadedMetadataResults = this.writeMetadataInParallel(clusterState, new ArrayList<IndexMetadata>(clusterState.metadata().indices().values()), Collections.emptyMap(), RemoteGlobalMetadataManager.filterCustoms(clusterState.metadata().customs(), publicationEnabled), true, true, true, publicationEnabled, publicationEnabled, publicationEnabled, publicationEnabled ? clusterState.customs() : Collections.emptyMap(), publicationEnabled, this.remoteRoutingTableService.getIndicesRouting(clusterState.getRoutingTable()), null);
        ClusterStateDiffManifest clusterStateDiffManifest = new ClusterStateDiffManifest(clusterState, ClusterState.EMPTY_STATE, 4, null, null);
        RemoteClusterStateManifestInfo manifestDetails = this.remoteManifestManager.uploadManifest(clusterState, uploadedMetadataResults, previousClusterUUID, clusterStateDiffManifest, !this.remoteClusterStateValidationMode.equals((Object)RemoteClusterStateValidationMode.NONE) ? new ClusterStateChecksum(clusterState, this.threadpool) : null, false);
        long durationMillis = TimeValue.nsecToMSec(this.relativeTimeNanosSupplier.getAsLong() - startTimeNanos);
        this.remoteStateStats.stateUploadSucceeded();
        this.remoteStateStats.stateUploadTook(durationMillis);
        if (durationMillis >= this.slowWriteLoggingThreshold.getMillis()) {
            logger.warn("writing cluster state took [{}ms] which is above the warn threshold of [{}]; wrote full state with [{}] indices and [{}] indicesRouting", (Object)durationMillis, (Object)this.slowWriteLoggingThreshold, (Object)uploadedMetadataResults.uploadedIndexMetadata.size(), (Object)uploadedMetadataResults.uploadedIndicesRoutingMetadata.size());
        } else {
            logger.debug("writing cluster state took [{}ms]; wrote full state with [{}] indices, [{}] indicesRouting and global metadata", (Object)durationMillis, (Object)uploadedMetadataResults.uploadedIndexMetadata.size(), (Object)uploadedMetadataResults.uploadedIndicesRoutingMetadata.size());
        }
        return manifestDetails;
    }

    public RemoteClusterStateManifestInfo writeIncrementalMetadata(ClusterState previousClusterState, ClusterState clusterState, ClusterMetadataManifest previousManifest) throws IOException {
        if (previousClusterState == null) {
            throw new IllegalArgumentException("previousClusterState cannot be null");
        }
        if (clusterState == null) {
            throw new IllegalArgumentException("clusterState cannot be null");
        }
        if (previousManifest == null) {
            throw new IllegalArgumentException("previousManifest cannot be null");
        }
        logger.trace("WRITING INCREMENTAL STATE");
        long startTimeNanos = this.relativeTimeNanosSupplier.getAsLong();
        if (!clusterState.nodes().isLocalNodeElectedClusterManager()) {
            logger.error("Local node is not elected cluster manager. Exiting");
            return null;
        }
        boolean firstUploadForSplitGlobalMetadata = !previousManifest.hasMetadataAttributesFiles();
        DiffableUtils.MapDiff<String, Metadata.Custom, Map<String, Metadata.Custom>> customsDiff = this.remoteGlobalMetadataManager.getCustomsDiff(clusterState, previousClusterState, firstUploadForSplitGlobalMetadata, this.isPublicationEnabled.get());
        DiffableUtils.MapDiff<String, ClusterState.Custom, Map<String, ClusterState.Custom>> clusterStateCustomsDiff = this.remoteClusterStateAttributesManager.getUpdatedCustoms(clusterState, previousClusterState, this.isPublicationEnabled.get(), false);
        HashMap<String, ClusterMetadataManifest.UploadedMetadataAttribute> allUploadedCustomMap = new HashMap<String, ClusterMetadataManifest.UploadedMetadataAttribute>(previousManifest.getCustomMetadataMap());
        HashMap<String, ClusterMetadataManifest.UploadedMetadataAttribute> allUploadedClusterStateCustomsMap = new HashMap<String, ClusterMetadataManifest.UploadedMetadataAttribute>(previousManifest.getClusterStateCustomMap());
        HashMap<String, IndexMetadata> indicesToBeDeletedFromRemote = new HashMap<String, IndexMetadata>(previousClusterState.metadata().indices());
        int numIndicesUpdated = 0;
        int numIndicesUnchanged = 0;
        Map allUploadedIndexMetadata = previousManifest.getIndices().stream().collect(Collectors.toMap(ClusterMetadataManifest.UploadedIndexMetadata::getIndexName, Function.identity()));
        ArrayList<IndexMetadata> toUpload = new ArrayList<IndexMetadata>();
        HashMap<String, IndexMetadata> prevIndexMetadataByName = new HashMap<String, IndexMetadata>();
        for (IndexMetadata indexMetadata : clusterState.metadata().indices().values()) {
            Long previousVersion;
            String indexName = indexMetadata.getIndex().getName();
            IndexMetadata prevIndexMetadata = (IndexMetadata)indicesToBeDeletedFromRemote.get(indexName);
            Long l = previousVersion = prevIndexMetadata != null ? Long.valueOf(prevIndexMetadata.getVersion()) : null;
            if (previousVersion == null || indexMetadata.getVersion() != previousVersion.longValue()) {
                logger.debug("updating metadata for [{}], changing version from [{}] to [{}]", (Object)indexMetadata.getIndex(), (Object)previousVersion, (Object)indexMetadata.getVersion());
                ++numIndicesUpdated;
                toUpload.add(indexMetadata);
                prevIndexMetadataByName.put(indexName, prevIndexMetadata);
            } else {
                ++numIndicesUnchanged;
            }
            indicesToBeDeletedFromRemote.remove(indexMetadata.getIndex().getName());
        }
        ArrayList<IndexRoutingTable> indicesRoutingToUpload = new ArrayList<IndexRoutingTable>();
        ArrayList<String> deletedIndicesRouting = new ArrayList<String>();
        StringKeyDiffProvider<IndexRoutingTable> routingTableDiff = this.remoteRoutingTableService.getIndicesRoutingMapDiff(previousClusterState.getRoutingTable(), clusterState.getRoutingTable());
        if (routingTableDiff != null && routingTableDiff.provideDiff() != null) {
            routingTableDiff.provideDiff().getDiffs().forEach((k, v) -> indicesRoutingToUpload.add(clusterState.getRoutingTable().index((String)k)));
            routingTableDiff.provideDiff().getUpserts().forEach((k, v) -> indicesRoutingToUpload.add((IndexRoutingTable)v));
            deletedIndicesRouting.addAll(routingTableDiff.provideDiff().getDeletes());
        }
        boolean updateCoordinationMetadata = firstUploadForSplitGlobalMetadata || !Metadata.isCoordinationMetadataEqual(previousClusterState.metadata(), clusterState.metadata());
        boolean updateSettingsMetadata = firstUploadForSplitGlobalMetadata || !Metadata.isSettingsMetadataEqual(previousClusterState.metadata(), clusterState.metadata());
        boolean updateTransientSettingsMetadata = !Metadata.isTransientSettingsMetadataEqual(previousClusterState.metadata(), clusterState.metadata());
        boolean updateTemplatesMetadata = firstUploadForSplitGlobalMetadata || !Metadata.isTemplatesMetadataEqual(previousClusterState.metadata(), clusterState.metadata());
        boolean updateDiscoveryNodes = this.isPublicationEnabled.get() && clusterState.getNodes().delta(previousClusterState.getNodes()).hasChanges();
        boolean updateClusterBlocks = this.isPublicationEnabled.get() && !clusterState.blocks().equals(previousClusterState.blocks());
        boolean updateHashesOfConsistentSettings = this.isPublicationEnabled.get() && !Metadata.isHashesOfConsistentSettingsEqual(previousClusterState.metadata(), clusterState.metadata());
        RemoteClusterStateUtils.UploadedMetadataResults uploadedMetadataResults = this.writeMetadataInParallel(clusterState, toUpload, prevIndexMetadataByName, customsDiff.getUpserts(), updateCoordinationMetadata, updateSettingsMetadata, updateTemplatesMetadata, updateDiscoveryNodes, updateClusterBlocks, updateTransientSettingsMetadata, clusterStateCustomsDiff.getUpserts(), updateHashesOfConsistentSettings, indicesRoutingToUpload, routingTableDiff);
        uploadedMetadataResults.uploadedIndexMetadata.forEach(uploadedIndexMetadata -> allUploadedIndexMetadata.put(uploadedIndexMetadata.getIndexName(), uploadedIndexMetadata));
        allUploadedCustomMap.putAll(uploadedMetadataResults.uploadedCustomMetadataMap);
        allUploadedClusterStateCustomsMap.putAll(uploadedMetadataResults.uploadedClusterStateCustomMetadataMap);
        customsDiff.getDeletes().forEach(allUploadedCustomMap::remove);
        indicesToBeDeletedFromRemote.keySet().forEach(allUploadedIndexMetadata::remove);
        clusterStateCustomsDiff.getDeletes().forEach(allUploadedClusterStateCustomsMap::remove);
        if (!updateCoordinationMetadata) {
            uploadedMetadataResults.uploadedCoordinationMetadata = previousManifest.getCoordinationMetadata();
        }
        if (!updateSettingsMetadata) {
            uploadedMetadataResults.uploadedSettingsMetadata = previousManifest.getSettingsMetadata();
        }
        if (!updateTransientSettingsMetadata) {
            uploadedMetadataResults.uploadedTransientSettingsMetadata = previousManifest.getTransientSettingsMetadata();
        }
        if (!updateTemplatesMetadata) {
            uploadedMetadataResults.uploadedTemplatesMetadata = previousManifest.getTemplatesMetadata();
        }
        if (!updateDiscoveryNodes) {
            uploadedMetadataResults.uploadedDiscoveryNodes = previousManifest.getDiscoveryNodesMetadata();
        }
        if (!updateClusterBlocks) {
            uploadedMetadataResults.uploadedClusterBlocks = previousManifest.getClusterBlocksMetadata();
        }
        if (!updateHashesOfConsistentSettings) {
            uploadedMetadataResults.uploadedHashesOfConsistentSettings = previousManifest.getHashesOfConsistentSettings();
        }
        uploadedMetadataResults.uploadedCustomMetadataMap = allUploadedCustomMap;
        uploadedMetadataResults.uploadedClusterStateCustomMetadataMap = allUploadedClusterStateCustomsMap;
        uploadedMetadataResults.uploadedIndexMetadata = new ArrayList(allUploadedIndexMetadata.values());
        uploadedMetadataResults.uploadedIndicesRoutingMetadata = this.remoteRoutingTableService.getAllUploadedIndicesRouting(previousManifest, uploadedMetadataResults.uploadedIndicesRoutingMetadata, deletedIndicesRouting);
        ClusterStateDiffManifest clusterStateDiffManifest = new ClusterStateDiffManifest(clusterState, previousClusterState, 4, routingTableDiff, uploadedMetadataResults.uploadedIndicesRoutingDiffMetadata != null ? uploadedMetadataResults.uploadedIndicesRoutingDiffMetadata.getUploadedFilename() : null);
        RemoteClusterStateManifestInfo manifestDetails = this.remoteManifestManager.uploadManifest(clusterState, uploadedMetadataResults, previousManifest.getPreviousClusterUUID(), clusterStateDiffManifest, !this.remoteClusterStateValidationMode.equals((Object)RemoteClusterStateValidationMode.NONE) ? new ClusterStateChecksum(clusterState, this.threadpool) : null, false);
        long durationMillis = TimeValue.nsecToMSec(this.relativeTimeNanosSupplier.getAsLong() - startTimeNanos);
        this.remoteStateStats.stateUploadSucceeded();
        this.remoteStateStats.stateUploadTook(durationMillis);
        ParameterizedMessage clusterStateUploadTimeMessage = new ParameterizedMessage("writing cluster state for version [{}] took [{}ms]", (Object)manifestDetails.getClusterMetadataManifest().getStateVersion(), (Object)durationMillis);
        ParameterizedMessage metadataUpdateMessage = new ParameterizedMessage("wrote metadata for [{}] indices and skipped [{}] unchanged indices, coordination metadata updated : [{}], settings metadata updated : [{}], templates metadata updated : [{}], custom metadata updated : [{}], indices routing updated : [{}]", new Object[]{numIndicesUpdated, numIndicesUnchanged, updateCoordinationMetadata, updateSettingsMetadata, updateTemplatesMetadata, customsDiff.getUpserts().size(), indicesRoutingToUpload.size()});
        if (durationMillis >= this.slowWriteLoggingThreshold.getMillis()) {
            logger.warn("writing cluster state took [{}ms] which is above the warn threshold of [{}]; wrote  metadata for [{}] indices and skipped [{}] unchanged indices, coordination metadata updated : [{}], settings metadata updated : [{}], templates metadata updated : [{}], custom metadata updated : [{}]", (Object)durationMillis, (Object)this.slowWriteLoggingThreshold, (Object)numIndicesUpdated, (Object)numIndicesUnchanged, (Object)updateCoordinationMetadata, (Object)updateSettingsMetadata, (Object)updateTemplatesMetadata, (Object)customsDiff.getUpserts().size());
        } else {
            logger.debug("{}; {}", (Object)clusterStateUploadTimeMessage, (Object)metadataUpdateMessage);
            logger.debug("writing cluster state for version [{}] took [{}ms]; wrote metadata for [{}] indices and skipped [{}] unchanged indices, coordination metadata updated : [{}], settings metadata updated : [{}], templates metadata updated : [{}], custom metadata updated : [{}]", (Object)manifestDetails.getClusterMetadataManifest().getStateVersion(), (Object)durationMillis, (Object)numIndicesUpdated, (Object)numIndicesUnchanged, (Object)updateCoordinationMetadata, (Object)updateSettingsMetadata, (Object)updateTemplatesMetadata, (Object)customsDiff.getUpserts().size());
        }
        return manifestDetails;
    }

    RemoteClusterStateUtils.UploadedMetadataResults writeMetadataInParallel(ClusterState clusterState, List<IndexMetadata> indexToUpload, Map<String, IndexMetadata> prevIndexMetadataByName, Map<String, Metadata.Custom> customToUpload, boolean uploadCoordinationMetadata, boolean uploadSettingsMetadata, boolean uploadTemplateMetadata, boolean uploadDiscoveryNodes, boolean uploadClusterBlock, boolean uploadTransientSettingMetadata, Map<String, ClusterState.Custom> clusterStateCustomToUpload, boolean uploadHashesOfConsistentSettings, List<IndexRoutingTable> indicesRoutingToUpload, StringKeyDiffProvider<IndexRoutingTable> routingTableDiff) throws IOException {
        assert (Objects.nonNull(this.indexMetadataUploadListeners)) : "indexMetadataUploadListeners can not be null";
        int totalUploadTasks = indexToUpload.size() + this.indexMetadataUploadListeners.size() + customToUpload.size() + (uploadCoordinationMetadata ? 1 : 0) + (uploadSettingsMetadata ? 1 : 0) + (uploadTemplateMetadata ? 1 : 0) + (uploadDiscoveryNodes ? 1 : 0) + (uploadClusterBlock ? 1 : 0) + (uploadTransientSettingMetadata ? 1 : 0) + clusterStateCustomToUpload.size() + (uploadHashesOfConsistentSettings ? 1 : 0) + indicesRoutingToUpload.size() + (routingTableDiff != null && routingTableDiff.provideDiff() != null && (!routingTableDiff.provideDiff().getDiffs().isEmpty() || !routingTableDiff.provideDiff().getDeletes().isEmpty() || !routingTableDiff.provideDiff().getUpserts().isEmpty()) ? 1 : 0);
        CountDownLatch latch = new CountDownLatch(totalUploadTasks);
        List<String> uploadTasks = Collections.synchronizedList(new ArrayList(totalUploadTasks));
        ConcurrentHashMap<String, ClusterMetadataManifest.UploadedMetadata> results = new ConcurrentHashMap<String, ClusterMetadataManifest.UploadedMetadata>(totalUploadTasks);
        List<Exception> exceptionList = Collections.synchronizedList(new ArrayList(totalUploadTasks));
        LatchedActionListener<ClusterMetadataManifest.UploadedMetadata> listener = new LatchedActionListener<ClusterMetadataManifest.UploadedMetadata>(ActionListener.wrap(uploadedMetadata -> {
            logger.trace(String.format(Locale.ROOT, "Metadata component %s uploaded successfully.", uploadedMetadata.getComponent()));
            results.put(uploadedMetadata.getComponent(), (ClusterMetadataManifest.UploadedMetadata)uploadedMetadata);
        }, ex -> {
            logger.error(() -> new ParameterizedMessage("Exception during transfer of Metadata Fragment to Remote {}", (Object)ex.getMessage()), (Throwable)ex);
            exceptionList.add((Exception)ex);
        }), latch);
        if (uploadSettingsMetadata) {
            uploadTasks.add("settings");
            this.remoteGlobalMetadataManager.writeAsync("settings", new RemotePersistentSettingsMetadata(clusterState.metadata().persistentSettings(), clusterState.metadata().version(), clusterState.metadata().clusterUUID(), this.blobStoreRepository.getCompressor(), this.blobStoreRepository.getNamedXContentRegistry()), listener);
        }
        if (uploadTransientSettingMetadata) {
            uploadTasks.add("transient-settings");
            this.remoteGlobalMetadataManager.writeAsync("transient-settings", new RemoteTransientSettingsMetadata(clusterState.metadata().transientSettings(), clusterState.metadata().version(), clusterState.metadata().clusterUUID(), this.blobStoreRepository.getCompressor(), this.blobStoreRepository.getNamedXContentRegistry()), listener);
        }
        if (uploadCoordinationMetadata) {
            uploadTasks.add("coordination");
            this.remoteGlobalMetadataManager.writeAsync("coordination", new RemoteCoordinationMetadata(clusterState.metadata().coordinationMetadata(), clusterState.metadata().version(), clusterState.metadata().clusterUUID(), this.blobStoreRepository.getCompressor(), this.blobStoreRepository.getNamedXContentRegistry()), listener);
        }
        if (uploadTemplateMetadata) {
            uploadTasks.add("templates");
            this.remoteGlobalMetadataManager.writeAsync("templates", new RemoteTemplatesMetadata(clusterState.metadata().templatesMetadata(), clusterState.metadata().version(), clusterState.metadata().clusterUUID(), this.blobStoreRepository.getCompressor(), this.blobStoreRepository.getNamedXContentRegistry()), listener);
        }
        if (uploadDiscoveryNodes) {
            uploadTasks.add("nodes");
            this.remoteClusterStateAttributesManager.writeAsync("nodes", new RemoteDiscoveryNodes(clusterState.nodes(), clusterState.version(), clusterState.metadata().clusterUUID(), this.blobStoreRepository.getCompressor()), listener);
        }
        if (uploadClusterBlock) {
            uploadTasks.add("blocks");
            this.remoteClusterStateAttributesManager.writeAsync("blocks", new RemoteClusterBlocks(clusterState.blocks(), clusterState.version(), clusterState.metadata().clusterUUID(), this.blobStoreRepository.getCompressor()), listener);
        }
        if (uploadHashesOfConsistentSettings) {
            uploadTasks.add("hashes-of-consistent-settings");
            this.remoteGlobalMetadataManager.writeAsync("hashes-of-consistent-settings", new RemoteHashesOfConsistentSettings((DiffableStringMap)clusterState.metadata().hashesOfConsistentSettings(), clusterState.metadata().version(), clusterState.metadata().clusterUUID(), this.blobStoreRepository.getCompressor()), listener);
        }
        customToUpload.forEach((key, value) -> {
            String customComponent = String.join((CharSequence)"--", "custom", key);
            uploadTasks.add(customComponent);
            this.remoteGlobalMetadataManager.writeAsync(customComponent, new RemoteCustomMetadata((Metadata.Custom)value, (String)key, clusterState.metadata().version(), clusterState.metadata().clusterUUID(), this.blobStoreRepository.getCompressor(), this.namedWriteableRegistry), listener);
        });
        indexToUpload.forEach(indexMetadata -> {
            uploadTasks.add(indexMetadata.getIndex().getName());
            this.remoteIndexMetadataManager.writeAsync(indexMetadata.getIndex().getName(), new RemoteIndexMetadata((IndexMetadata)indexMetadata, clusterState.metadata().clusterUUID(), this.blobStoreRepository.getCompressor(), this.blobStoreRepository.getNamedXContentRegistry(), this.remoteIndexMetadataManager.getPathTypeSetting(), this.remoteIndexMetadataManager.getPathHashAlgoSetting(), this.remotePathPrefix), listener);
        });
        clusterStateCustomToUpload.forEach((key, value) -> {
            uploadTasks.add((String)key);
            this.remoteClusterStateAttributesManager.writeAsync("cluster-state-custom", new RemoteClusterStateCustoms((ClusterState.Custom)value, (String)key, clusterState.version(), clusterState.metadata().clusterUUID(), this.blobStoreRepository.getCompressor(), this.namedWriteableRegistry), listener);
        });
        indicesRoutingToUpload.forEach(indexRoutingTable -> {
            uploadTasks.add("indexRouting--" + indexRoutingTable.getIndex().getName());
            this.remoteRoutingTableService.getAsyncIndexRoutingWriteAction(clusterState.metadata().clusterUUID(), clusterState.term(), clusterState.version(), (IndexRoutingTable)indexRoutingTable, listener);
        });
        if (!(routingTableDiff == null || routingTableDiff.provideDiff() == null || routingTableDiff.provideDiff().getDiffs().isEmpty() && routingTableDiff.provideDiff().getDeletes().isEmpty() && routingTableDiff.provideDiff().getUpserts().isEmpty())) {
            uploadTasks.add("routing_table_diff");
            this.remoteRoutingTableService.getAsyncIndexRoutingDiffWriteAction(clusterState.metadata().clusterUUID(), clusterState.term(), clusterState.version(), routingTableDiff, listener);
        }
        this.invokeIndexMetadataUploadListeners(indexToUpload, prevIndexMetadataByName, latch, exceptionList);
        try {
            if (!latch.await(this.remoteGlobalMetadataManager.getGlobalMetadataUploadTimeout().millis(), TimeUnit.MILLISECONDS)) {
                RemoteStateTransferException ex2 = new RemoteStateTransferException(String.format(Locale.ROOT, "Timed out waiting for transfer of following metadata to complete - %s", String.join((CharSequence)", ", uploadTasks)));
                exceptionList.forEach(ex2::addSuppressed);
                throw ex2;
            }
        }
        catch (InterruptedException ex3) {
            exceptionList.forEach(ex3::addSuppressed);
            RemoteStateTransferException exception = new RemoteStateTransferException(String.format(Locale.ROOT, "Timed out waiting for transfer of metadata to complete - %s", String.join((CharSequence)", ", uploadTasks)), ex3);
            Thread.currentThread().interrupt();
            throw exception;
        }
        if (!exceptionList.isEmpty()) {
            RemoteStateTransferException exception = new RemoteStateTransferException(String.format(Locale.ROOT, "Exception during transfer of following metadata to Remote - %s", String.join((CharSequence)", ", uploadTasks)));
            exceptionList.forEach(exception::addSuppressed);
            throw exception;
        }
        if (results.size() != uploadTasks.size()) {
            throw new RemoteStateTransferException(String.format(Locale.ROOT, "Some metadata components were not uploaded successfully. Objects to be uploaded: %s, uploaded objects: %s", String.join((CharSequence)", ", uploadTasks), String.join((CharSequence)", ", results.keySet())));
        }
        RemoteClusterStateUtils.UploadedMetadataResults response = new RemoteClusterStateUtils.UploadedMetadataResults();
        results.forEach((name, uploadedMetadata) -> {
            if (uploadedMetadata.getClass().equals(ClusterMetadataManifest.UploadedIndexMetadata.class) && uploadedMetadata.getComponent().contains("indexRouting--")) {
                response.uploadedIndicesRoutingMetadata.add((ClusterMetadataManifest.UploadedIndexMetadata)uploadedMetadata);
            } else if ("routing_table_diff".equals(name)) {
                response.uploadedIndicesRoutingDiffMetadata = (ClusterMetadataManifest.UploadedMetadataAttribute)uploadedMetadata;
            } else if (name.startsWith("custom")) {
                String custom = name.split("__")[0].split("--")[1];
                response.uploadedCustomMetadataMap.put(custom, new ClusterMetadataManifest.UploadedMetadataAttribute(custom, uploadedMetadata.getUploadedFilename()));
            } else if (name.startsWith("cluster-state-custom")) {
                String custom = name.split("__")[0].split("--")[1];
                response.uploadedClusterStateCustomMetadataMap.put(custom, new ClusterMetadataManifest.UploadedMetadataAttribute(custom, uploadedMetadata.getUploadedFilename()));
            } else if ("coordination".equals(name)) {
                response.uploadedCoordinationMetadata = (ClusterMetadataManifest.UploadedMetadataAttribute)uploadedMetadata;
            } else if ("settings".equals(name)) {
                response.uploadedSettingsMetadata = (ClusterMetadataManifest.UploadedMetadataAttribute)uploadedMetadata;
            } else if ("templates".equals(name)) {
                response.uploadedTemplatesMetadata = (ClusterMetadataManifest.UploadedMetadataAttribute)uploadedMetadata;
            } else if (name.contains("index--")) {
                response.uploadedIndexMetadata.add((ClusterMetadataManifest.UploadedIndexMetadata)uploadedMetadata);
            } else if ("transient-settings".equals(name)) {
                response.uploadedTransientSettingsMetadata = (ClusterMetadataManifest.UploadedMetadataAttribute)uploadedMetadata;
            } else if ("nodes".equals(uploadedMetadata.getComponent())) {
                response.uploadedDiscoveryNodes = (ClusterMetadataManifest.UploadedMetadataAttribute)uploadedMetadata;
            } else if ("blocks".equals(uploadedMetadata.getComponent())) {
                response.uploadedClusterBlocks = (ClusterMetadataManifest.UploadedMetadataAttribute)uploadedMetadata;
            } else if ("hashes-of-consistent-settings".equals(uploadedMetadata.getComponent())) {
                response.uploadedHashesOfConsistentSettings = (ClusterMetadataManifest.UploadedMetadataAttribute)uploadedMetadata;
            } else {
                throw new IllegalStateException("Unknown metadata component name " + name);
            }
        });
        logger.trace("response {}", (Object)response.uploadedIndicesRoutingMetadata.toString());
        return response;
    }

    private void invokeIndexMetadataUploadListeners(List<IndexMetadata> updatedIndexMetadataList, Map<String, IndexMetadata> prevIndexMetadataByName, CountDownLatch latch, List<Exception> exceptionList) {
        for (IndexMetadataUploadListener listener : this.indexMetadataUploadListeners) {
            String listenerName = listener.getClass().getSimpleName();
            listener.onUpload(updatedIndexMetadataList, prevIndexMetadataByName, this.getIndexMetadataUploadActionListener(updatedIndexMetadataList, prevIndexMetadataByName, latch, exceptionList, listenerName));
        }
    }

    private ActionListener<Void> getIndexMetadataUploadActionListener(List<IndexMetadata> newIndexMetadataList, Map<String, IndexMetadata> prevIndexMetadataByName, CountDownLatch latch, List<Exception> exceptionList, String listenerName) {
        long startTime = System.nanoTime();
        return new LatchedActionListener<Void>(ActionListener.wrap(ignored -> logger.trace((Message)new ParameterizedMessage("listener={} : Invoked successfully with indexMetadataList={} prevIndexMetadataList={} tookTimeNs={}", new Object[]{listenerName, newIndexMetadataList, prevIndexMetadataByName.values(), System.nanoTime() - startTime})), ex -> {
            logger.error((Message)new ParameterizedMessage("listener={} : Exception during invocation with indexMetadataList={} prevIndexMetadataList={} tookTimeNs={}", new Object[]{listenerName, newIndexMetadataList, prevIndexMetadataByName.values(), System.nanoTime() - startTime}), (Throwable)ex);
            exceptionList.add((Exception)ex);
        }), latch);
    }

    public RemoteManifestManager getRemoteManifestManager() {
        return this.remoteManifestManager;
    }

    public RemoteClusterStateCleanupManager getCleanupManager() {
        return this.remoteClusterStateCleanupManager;
    }

    @Nullable
    public RemoteClusterStateManifestInfo markLastStateAsCommitted(ClusterState clusterState, ClusterMetadataManifest previousManifest, boolean commitVotingConfig) throws IOException {
        assert (clusterState != null) : "Last accepted cluster state is not set";
        if (!clusterState.nodes().isLocalNodeElectedClusterManager()) {
            logger.error("Local node is not elected cluster manager. Exiting");
            return null;
        }
        assert (previousManifest != null) : "Last cluster metadata manifest is not set";
        ClusterMetadataManifest.UploadedMetadataAttribute uploadedCoordinationMetadata = previousManifest.getCoordinationMetadata();
        if (commitVotingConfig) {
            uploadedCoordinationMetadata = this.writeMetadataInParallel((ClusterState)clusterState, Collections.emptyList(), Collections.emptyMap(), Collections.emptyMap(), (boolean)true, (boolean)false, (boolean)false, (boolean)false, (boolean)false, (boolean)false, Collections.emptyMap(), (boolean)false, Collections.emptyList(), null).uploadedCoordinationMetadata;
        }
        RemoteClusterStateUtils.UploadedMetadataResults uploadedMetadataResults = new RemoteClusterStateUtils.UploadedMetadataResults(previousManifest.getIndices(), previousManifest.getCustomMetadataMap(), uploadedCoordinationMetadata, previousManifest.getSettingsMetadata(), previousManifest.getTemplatesMetadata(), previousManifest.getTransientSettingsMetadata(), previousManifest.getDiscoveryNodesMetadata(), previousManifest.getClusterBlocksMetadata(), previousManifest.getIndicesRouting(), previousManifest.getHashesOfConsistentSettings(), previousManifest.getClusterStateCustomMap());
        RemoteClusterStateManifestInfo committedManifestDetails = this.remoteManifestManager.uploadManifest(clusterState, uploadedMetadataResults, previousManifest.getPreviousClusterUUID(), previousManifest.getDiffManifest(), !this.remoteClusterStateValidationMode.equals((Object)RemoteClusterStateValidationMode.NONE) ? new ClusterStateChecksum(clusterState, this.threadpool) : null, true);
        if (!previousManifest.isClusterUUIDCommitted() && committedManifestDetails.getClusterMetadataManifest().isClusterUUIDCommitted()) {
            this.remoteClusterStateCleanupManager.deleteStaleClusterUUIDs(clusterState, committedManifestDetails.getClusterMetadataManifest());
        }
        return committedManifestDetails;
    }

    public Optional<ClusterMetadataManifest> getLatestClusterMetadataManifest(String clusterName, String clusterUUID) {
        return this.remoteManifestManager.getLatestClusterMetadataManifest(clusterName, clusterUUID);
    }

    public ClusterMetadataManifest getClusterMetadataManifestByFileName(String clusterUUID, String fileName) {
        return this.remoteManifestManager.getRemoteClusterMetadataManifestByFileName(clusterUUID, fileName);
    }

    public Optional<ClusterMetadataManifest> getClusterMetadataManifestByTermVersion(String clusterName, String clusterUUID, long term, long version) {
        return this.remoteManifestManager.getClusterMetadataManifestByTermVersion(clusterName, clusterUUID, term, version);
    }

    @Override
    public void close() throws IOException {
        this.remoteClusterStateCleanupManager.close();
        if (this.blobStoreRepository != null) {
            IOUtils.close((Closeable)this.blobStoreRepository);
        }
        this.remoteRoutingTableService.close();
    }

    public void start() {
        assert (RemoteStoreNodeAttribute.isRemoteClusterStateConfigured(this.settings)) : "Remote cluster state is not enabled";
        String remoteStoreRepo = RemoteStoreNodeAttribute.getClusterStateRepoName(this.settings);
        assert (remoteStoreRepo != null) : "Remote Cluster State repository is not configured";
        Repository repository = this.repositoriesService.get().repository(remoteStoreRepo);
        assert (repository instanceof BlobStoreRepository) : "Repository should be instance of BlobStoreRepository";
        this.blobStoreRepository = (BlobStoreRepository)repository;
        String clusterName = ClusterName.CLUSTER_NAME_SETTING.get(this.settings).value();
        this.blobStoreTransferService = new BlobStoreTransferService(this.getBlobStore(), this.threadpool);
        this.remoteGlobalMetadataManager = new RemoteGlobalMetadataManager(this.clusterSettings, clusterName, this.blobStoreRepository, this.blobStoreTransferService, this.namedWriteableRegistry, this.threadpool);
        this.remoteIndexMetadataManager = new RemoteIndexMetadataManager(this.clusterSettings, clusterName, this.blobStoreRepository, this.blobStoreTransferService, this.threadpool);
        this.remoteManifestManager = new RemoteManifestManager(this.clusterSettings, clusterName, this.nodeId, this.blobStoreRepository, this.blobStoreTransferService, this.threadpool);
        this.remoteClusterStateAttributesManager = new RemoteClusterStateAttributesManager(clusterName, this.blobStoreRepository, this.blobStoreTransferService, this.namedWriteableRegistry, this.threadpool);
        this.remoteRoutingTableService.start();
        this.remoteClusterStateCleanupManager.start();
    }

    private void setSlowWriteLoggingThreshold(TimeValue slowWriteLoggingThreshold) {
        this.slowWriteLoggingThreshold = slowWriteLoggingThreshold;
    }

    private void setChecksumValidationMode(RemoteClusterStateValidationMode remoteClusterStateValidationMode) {
        this.remoteClusterStateValidationMode = remoteClusterStateValidationMode;
    }

    private void setRemotePublicationSetting(boolean remotePublicationSetting) {
        if (!remotePublicationSetting) {
            this.isPublicationEnabled.set(false);
        } else {
            this.isPublicationEnabled.set(RemoteStoreNodeAttribute.isRemoteStoreClusterStateEnabled(this.settings) && RemoteStoreNodeAttribute.isRemoteRoutingTableConfigured(this.settings));
        }
    }

    RemoteRoutingTableService getRemoteRoutingTableService() {
        return this.remoteRoutingTableService;
    }

    ThreadPool getThreadpool() {
        return this.threadpool;
    }

    BlobStoreRepository getBlobStoreRepository() {
        return this.blobStoreRepository;
    }

    BlobStore getBlobStore() {
        return this.blobStoreRepository.blobStore();
    }

    public ClusterState getLatestClusterState(String clusterName, String clusterUUID, boolean includeEphemeral) throws IOException {
        Optional<ClusterMetadataManifest> clusterMetadataManifest = this.remoteManifestManager.getLatestClusterMetadataManifest(clusterName, clusterUUID);
        if (clusterMetadataManifest.isEmpty()) {
            throw new IllegalStateException(String.format(Locale.ROOT, "Latest cluster metadata manifest is not present for the provided clusterUUID: %s", clusterUUID));
        }
        return this.getClusterStateForManifest(clusterName, clusterMetadataManifest.get(), this.nodeId, includeEphemeral);
    }

    ClusterState readClusterStateInParallel(ClusterState previousState, ClusterMetadataManifest manifest, String clusterUUID, String localNodeId, List<ClusterMetadataManifest.UploadedIndexMetadata> indicesToRead, Map<String, ClusterMetadataManifest.UploadedMetadataAttribute> customToRead, boolean readCoordinationMetadata, boolean readSettingsMetadata, boolean readTransientSettingsMetadata, boolean readTemplatesMetadata, boolean readDiscoveryNodes, boolean readClusterBlocks, List<ClusterMetadataManifest.UploadedIndexMetadata> indicesRoutingToRead, boolean readHashesOfConsistentSettings, Map<String, ClusterMetadataManifest.UploadedMetadataAttribute> clusterStateCustomToRead, boolean readIndexRoutingTableDiff, boolean includeEphemeral) {
        int totalReadTasks = indicesToRead.size() + customToRead.size() + (readCoordinationMetadata ? 1 : 0) + (readSettingsMetadata ? 1 : 0) + (readTemplatesMetadata ? 1 : 0) + (readDiscoveryNodes ? 1 : 0) + (readClusterBlocks ? 1 : 0) + (readTransientSettingsMetadata ? 1 : 0) + (readHashesOfConsistentSettings ? 1 : 0) + clusterStateCustomToRead.size() + indicesRoutingToRead.size() + (readIndexRoutingTableDiff ? 1 : 0);
        CountDownLatch latch = new CountDownLatch(totalReadTasks);
        List readResults = Collections.synchronizedList(new ArrayList());
        List readIndexRoutingTableResults = Collections.synchronizedList(new ArrayList());
        AtomicReference readIndexRoutingTableDiffResults = new AtomicReference();
        List exceptionList = Collections.synchronizedList(new ArrayList(totalReadTasks));
        LatchedActionListener<RemoteReadResult> listener = new LatchedActionListener<RemoteReadResult>(ActionListener.wrap(response -> {
            logger.debug("Successfully read cluster state component from remote");
            readResults.add(response);
        }, ex -> {
            logger.error("Failed to read cluster state from remote", (Throwable)ex);
            exceptionList.add(ex);
        }), latch);
        for (ClusterMetadataManifest.UploadedIndexMetadata uploadedIndexMetadata : indicesToRead) {
            this.remoteIndexMetadataManager.readAsync(uploadedIndexMetadata.getIndexName(), new RemoteIndexMetadata(RemoteClusterStateUtils.getFormattedIndexFileName(uploadedIndexMetadata.getUploadedFilename()), clusterUUID, this.blobStoreRepository.getCompressor(), this.blobStoreRepository.getNamedXContentRegistry()), listener);
        }
        LatchedActionListener<IndexRoutingTable> routingTableLatchedActionListener = new LatchedActionListener<IndexRoutingTable>(ActionListener.wrap(response -> {
            logger.debug(() -> new ParameterizedMessage("Successfully read index-routing for index {}", (Object)response.getIndex().getName()));
            readIndexRoutingTableResults.add(response);
        }, ex -> {
            logger.error(() -> new ParameterizedMessage("Failed to read index-routing from remote", new Object[0]), (Throwable)ex);
            exceptionList.add(ex);
        }), latch);
        for (ClusterMetadataManifest.UploadedIndexMetadata uploadedIndexMetadata : indicesRoutingToRead) {
            this.remoteRoutingTableService.getAsyncIndexRoutingReadAction(clusterUUID, uploadedIndexMetadata.getUploadedFilename(), routingTableLatchedActionListener);
        }
        LatchedActionListener<Diff<RoutingTable>> latchedActionListener = new LatchedActionListener<Diff<RoutingTable>>(ActionListener.wrap(response -> {
            logger.debug("Successfully read routing table diff component from remote");
            readIndexRoutingTableDiffResults.set(response);
        }, ex -> {
            logger.error("Failed to read routing table diff from remote", (Throwable)ex);
            exceptionList.add(ex);
        }), latch);
        if (readIndexRoutingTableDiff) {
            this.remoteRoutingTableService.getAsyncIndexRoutingTableDiffReadAction(clusterUUID, manifest.getDiffManifest().getIndicesRoutingDiffPath(), latchedActionListener);
        }
        for (Map.Entry<String, ClusterMetadataManifest.UploadedMetadataAttribute> entry : customToRead.entrySet()) {
            this.remoteGlobalMetadataManager.readAsync(entry.getValue().getAttributeName(), new RemoteCustomMetadata(entry.getValue().getUploadedFilename(), entry.getKey(), clusterUUID, this.blobStoreRepository.getCompressor(), this.namedWriteableRegistry, manifest.getOpensearchVersion()), listener);
        }
        if (readCoordinationMetadata) {
            this.remoteGlobalMetadataManager.readAsync("coordination", new RemoteCoordinationMetadata(manifest.getCoordinationMetadata().getUploadedFilename(), clusterUUID, this.blobStoreRepository.getCompressor(), this.blobStoreRepository.getNamedXContentRegistry()), listener);
        }
        if (readSettingsMetadata) {
            this.remoteGlobalMetadataManager.readAsync("settings", new RemotePersistentSettingsMetadata(manifest.getSettingsMetadata().getUploadedFilename(), clusterUUID, this.blobStoreRepository.getCompressor(), this.blobStoreRepository.getNamedXContentRegistry()), listener);
        }
        if (readTransientSettingsMetadata) {
            this.remoteGlobalMetadataManager.readAsync("transient-settings", new RemoteTransientSettingsMetadata(manifest.getTransientSettingsMetadata().getUploadedFilename(), clusterUUID, this.blobStoreRepository.getCompressor(), this.blobStoreRepository.getNamedXContentRegistry()), listener);
        }
        if (readTemplatesMetadata) {
            this.remoteGlobalMetadataManager.readAsync("templates", new RemoteTemplatesMetadata(manifest.getTemplatesMetadata().getUploadedFilename(), clusterUUID, this.blobStoreRepository.getCompressor(), this.blobStoreRepository.getNamedXContentRegistry()), listener);
        }
        if (readDiscoveryNodes) {
            this.remoteClusterStateAttributesManager.readAsync("nodes", new RemoteDiscoveryNodes(manifest.getDiscoveryNodesMetadata().getUploadedFilename(), clusterUUID, this.blobStoreRepository.getCompressor()), listener);
        }
        if (readClusterBlocks) {
            this.remoteClusterStateAttributesManager.readAsync("blocks", new RemoteClusterBlocks(manifest.getClusterBlocksMetadata().getUploadedFilename(), clusterUUID, this.blobStoreRepository.getCompressor()), listener);
        }
        if (readHashesOfConsistentSettings) {
            this.remoteGlobalMetadataManager.readAsync("hashes-of-consistent-settings", new RemoteHashesOfConsistentSettings(manifest.getHashesOfConsistentSettings().getUploadedFilename(), clusterUUID, this.blobStoreRepository.getCompressor()), listener);
        }
        for (Map.Entry<String, ClusterMetadataManifest.UploadedMetadataAttribute> entry : clusterStateCustomToRead.entrySet()) {
            this.remoteClusterStateAttributesManager.readAsync(String.join((CharSequence)"--", "cluster-state-custom", entry.getKey()), new RemoteClusterStateCustoms(entry.getValue().getUploadedFilename(), entry.getValue().getAttributeName(), clusterUUID, this.blobStoreRepository.getCompressor(), this.namedWriteableRegistry), listener);
        }
        try {
            if (!latch.await(this.remoteStateReadTimeout.getMillis(), TimeUnit.MILLISECONDS)) {
                RemoteStateTransferException remoteStateTransferException = new RemoteStateTransferException("Timed out waiting to read cluster state from remote within timeout " + String.valueOf(this.remoteStateReadTimeout));
                exceptionList.forEach(remoteStateTransferException::addSuppressed);
                throw remoteStateTransferException;
            }
        }
        catch (InterruptedException interruptedException) {
            exceptionList.forEach(interruptedException::addSuppressed);
            RemoteStateTransferException ex2 = new RemoteStateTransferException("Interrupted while waiting to read cluster state from metadata");
            Thread.currentThread().interrupt();
            throw ex2;
        }
        if (!exceptionList.isEmpty()) {
            RemoteStateTransferException remoteStateTransferException = new RemoteStateTransferException("Exception during reading cluster state from remote");
            exceptionList.forEach(remoteStateTransferException::addSuppressed);
            throw remoteStateTransferException;
        }
        ClusterState.Builder builder = ClusterState.builder(previousState);
        AtomicReference<DiscoveryNodes.Builder> discoveryNodesBuilder = new AtomicReference<DiscoveryNodes.Builder>(DiscoveryNodes.builder());
        Metadata.Builder metadataBuilder = Metadata.builder(previousState.metadata());
        metadataBuilder.version(manifest.getMetadataVersion());
        metadataBuilder.clusterUUID(manifest.getClusterUUID());
        metadataBuilder.clusterUUIDCommitted(manifest.isClusterUUIDCommitted());
        HashMap<String, IndexMetadata> indexMetadataMap = new HashMap<String, IndexMetadata>();
        HashMap<String, IndexRoutingTable> indicesRouting = new HashMap<String, IndexRoutingTable>(previousState.routingTable().getIndicesRouting());
        readResults.forEach(remoteReadResult -> {
            switch (remoteReadResult.getComponent()) {
                case "index": {
                    IndexMetadata indexMetadata = (IndexMetadata)remoteReadResult.getObj();
                    indexMetadataMap.put(indexMetadata.getIndex().getName(), indexMetadata);
                    break;
                }
                case "custom": {
                    Metadata.Custom metadataCustom = (Metadata.Custom)remoteReadResult.getObj();
                    if (!includeEphemeral && (includeEphemeral || !metadataCustom.context().contains((Object)Metadata.XContentContext.GATEWAY))) break;
                    metadataBuilder.putCustom(remoteReadResult.getComponentName(), (Metadata.Custom)remoteReadResult.getObj());
                    break;
                }
                case "coordination": {
                    metadataBuilder.coordinationMetadata((CoordinationMetadata)remoteReadResult.getObj());
                    break;
                }
                case "settings": {
                    metadataBuilder.persistentSettings((Settings)remoteReadResult.getObj());
                    break;
                }
                case "transient-settings": {
                    metadataBuilder.transientSettings((Settings)remoteReadResult.getObj());
                    break;
                }
                case "templates": {
                    metadataBuilder.templates((TemplatesMetadata)remoteReadResult.getObj());
                    break;
                }
                case "hashes-of-consistent-settings": {
                    metadataBuilder.hashesOfConsistentSettings((DiffableStringMap)remoteReadResult.getObj());
                    break;
                }
                case "cluster_state_attribute": {
                    if (remoteReadResult.getComponentName().equals("nodes")) {
                        discoveryNodesBuilder.set(DiscoveryNodes.builder((DiscoveryNodes)remoteReadResult.getObj()));
                        break;
                    }
                    if (remoteReadResult.getComponentName().equals("blocks")) {
                        clusterStateBuilder.blocks((ClusterBlocks)remoteReadResult.getObj());
                        break;
                    }
                    if (!remoteReadResult.getComponentName().startsWith("cluster-state-custom")) break;
                    String custom = remoteReadResult.getComponentName().split("--")[1];
                    clusterStateBuilder.putCustom(custom, (ClusterState.Custom)remoteReadResult.getObj());
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown component: " + remoteReadResult.getComponent());
                }
            }
        });
        metadataBuilder.indices(indexMetadataMap);
        if (readDiscoveryNodes) {
            builder.nodes(discoveryNodesBuilder.get().localNodeId(localNodeId));
        }
        builder.metadata(metadataBuilder).version(manifest.getStateVersion()).stateUUID(manifest.getStateUUID());
        readIndexRoutingTableResults.forEach(indexRoutingTable -> indicesRouting.put(indexRoutingTable.getIndex().getName(), (IndexRoutingTable)indexRoutingTable));
        Diff routingTableDiff = (Diff)readIndexRoutingTableDiffResults.get();
        RoutingTable newRoutingTable = new RoutingTable(manifest.getRoutingTableVersion(), indicesRouting);
        if (routingTableDiff != null) {
            newRoutingTable = routingTableDiff.apply(previousState.getRoutingTable());
        }
        builder.routingTable(newRoutingTable);
        return builder.build();
    }

    public ClusterState getClusterStateForManifest(String clusterName, ClusterMetadataManifest manifest, String localNodeId, boolean includeEphemeral) throws IOException {
        try {
            ClusterState clusterState;
            ClusterState stateFromCache = this.remoteClusterStateCache.getState(clusterName, manifest);
            if (stateFromCache != null) {
                logger.trace(() -> new ParameterizedMessage("Found cluster state in cache for term {} and version {}", (Object)manifest.getClusterTerm(), (Object)manifest.getStateVersion()));
                return stateFromCache;
            }
            logger.info(() -> new ParameterizedMessage("Cluster state not found in cache for term {} and version {}", (Object)manifest.getClusterTerm(), (Object)manifest.getStateVersion()));
            long startTimeNanos = this.relativeTimeNanosSupplier.getAsLong();
            if (manifest.onOrAfterCodecVersion(2)) {
                clusterState = this.readClusterStateInParallel(ClusterState.builder(new ClusterName(clusterName)).build(), manifest, manifest.getClusterUUID(), localNodeId, manifest.getIndices(), manifest.getCustomMetadataMap(), manifest.getCoordinationMetadata() != null, manifest.getSettingsMetadata() != null, includeEphemeral && manifest.getTransientSettingsMetadata() != null, manifest.getTemplatesMetadata() != null, includeEphemeral && manifest.getDiscoveryNodesMetadata() != null, includeEphemeral && manifest.getClusterBlocksMetadata() != null, includeEphemeral ? manifest.getIndicesRouting() : Collections.emptyList(), includeEphemeral && manifest.getHashesOfConsistentSettings() != null, includeEphemeral ? manifest.getClusterStateCustomMap() : Collections.emptyMap(), false, includeEphemeral);
                if (includeEphemeral && !this.remoteClusterStateValidationMode.equals((Object)RemoteClusterStateValidationMode.NONE) && manifest.getClusterStateChecksum() != null) {
                    this.validateClusterStateFromChecksum(manifest, clusterState, clusterName, localNodeId, true);
                }
            } else {
                ClusterState state = this.readClusterStateInParallel(ClusterState.builder(new ClusterName(clusterName)).build(), manifest, manifest.getClusterUUID(), localNodeId, manifest.getIndices(), Collections.emptyMap(), false, false, false, false, false, false, Collections.emptyList(), false, Collections.emptyMap(), false, false);
                Metadata.Builder mb = Metadata.builder(this.remoteGlobalMetadataManager.getGlobalMetadata(manifest.getClusterUUID(), manifest));
                mb.indices(state.metadata().indices());
                clusterState = ClusterState.builder(state).metadata(mb).build();
            }
            long durationMillis = TimeValue.nsecToMSec(this.relativeTimeNanosSupplier.getAsLong() - startTimeNanos);
            this.remoteStateStats.stateFullDownloadSucceeded();
            this.remoteStateStats.stateFullDownloadTook(durationMillis);
            if (includeEphemeral) {
                this.remoteClusterStateCache.putState(clusterState);
            }
            return clusterState;
        }
        catch (Exception e) {
            logger.error("Failure in downloading full cluster state. ", (Throwable)e);
            this.remoteStateStats.stateFullDownloadFailed();
            throw e;
        }
    }

    public ClusterState getClusterStateUsingDiff(ClusterMetadataManifest manifest, ClusterState previousState, String localNodeId) {
        try {
            assert (manifest.getDiffManifest() != null) : "Diff manifest null which is required for downloading cluster state";
            long startTimeNanos = this.relativeTimeNanosSupplier.getAsLong();
            ClusterStateDiffManifest diff = manifest.getDiffManifest();
            boolean includeEphemeral = true;
            List<ClusterMetadataManifest.UploadedIndexMetadata> updatedIndices = diff.getIndicesUpdated().stream().map(idx -> {
                Optional<ClusterMetadataManifest.UploadedIndexMetadata> uploadedIndexMetadataOptional = manifest.getIndices().stream().filter(idx2 -> idx2.getIndexName().equals(idx)).findFirst();
                assert (uploadedIndexMetadataOptional.isPresent());
                return uploadedIndexMetadataOptional.get();
            }).collect(Collectors.toList());
            HashMap<String, ClusterMetadataManifest.UploadedMetadataAttribute> updatedCustomMetadata = new HashMap<String, ClusterMetadataManifest.UploadedMetadataAttribute>();
            if (diff.getCustomMetadataUpdated() != null) {
                for (String string : diff.getCustomMetadataUpdated()) {
                    updatedCustomMetadata.put(string, manifest.getCustomMetadataMap().get(string));
                }
            }
            HashMap<String, ClusterMetadataManifest.UploadedMetadataAttribute> updatedClusterStateCustom = new HashMap<String, ClusterMetadataManifest.UploadedMetadataAttribute>();
            if (diff.getClusterStateCustomUpdated() != null) {
                for (String customType : diff.getClusterStateCustomUpdated()) {
                    updatedClusterStateCustom.put(customType, manifest.getClusterStateCustomMap().get(customType));
                }
            }
            ArrayList<ClusterMetadataManifest.UploadedIndexMetadata> arrayList = new ArrayList<ClusterMetadataManifest.UploadedIndexMetadata>();
            if (manifest.getCodecVersion() == 2 || manifest.getCodecVersion() == 3) {
                arrayList.addAll(this.remoteRoutingTableService.getUpdatedIndexRoutingTableMetadata(diff.getIndicesRoutingUpdated(), manifest.getIndicesRouting()));
            }
            ClusterState updatedClusterState = this.readClusterStateInParallel(previousState, manifest, manifest.getClusterUUID(), localNodeId, updatedIndices, updatedCustomMetadata, diff.isCoordinationMetadataUpdated(), diff.isSettingsMetadataUpdated(), diff.isTransientSettingsMetadataUpdated(), diff.isTemplatesMetadataUpdated(), diff.isDiscoveryNodesUpdated(), diff.isClusterBlocksUpdated(), arrayList, diff.isHashesOfConsistentSettingsUpdated(), updatedClusterStateCustom, manifest.getDiffManifest() != null && manifest.getDiffManifest().getIndicesRoutingDiffPath() != null && !manifest.getDiffManifest().getIndicesRoutingDiffPath().isEmpty(), includeEphemeral);
            ClusterState.Builder clusterStateBuilder = ClusterState.builder(updatedClusterState);
            Metadata.Builder metadataBuilder = Metadata.builder(updatedClusterState.metadata());
            for (String string : diff.getIndicesDeleted()) {
                metadataBuilder.remove(string);
            }
            if (diff.getCustomMetadataDeleted() != null) {
                for (String string : diff.getCustomMetadataDeleted()) {
                    metadataBuilder.removeCustom(string);
                }
            }
            if (diff.getClusterStateCustomDeleted() != null) {
                for (String string : diff.getClusterStateCustomDeleted()) {
                    clusterStateBuilder.removeCustom(string);
                }
            }
            HashMap<String, IndexRoutingTable> indexRoutingTables = new HashMap<String, IndexRoutingTable>(updatedClusterState.getRoutingTable().getIndicesRouting());
            if (manifest.getCodecVersion() == 2 || manifest.getCodecVersion() == 3) {
                for (String indexName : diff.getIndicesRoutingDeleted()) {
                    indexRoutingTables.remove(indexName);
                }
            }
            ClusterState clusterState = clusterStateBuilder.stateUUID(manifest.getStateUUID()).version(manifest.getStateVersion()).metadata(metadataBuilder).routingTable(new RoutingTable(manifest.getRoutingTableVersion(), indexRoutingTables)).build();
            if (!this.remoteClusterStateValidationMode.equals((Object)RemoteClusterStateValidationMode.NONE) && manifest.getClusterStateChecksum() != null) {
                this.validateClusterStateFromChecksum(manifest, clusterState, previousState.getClusterName().value(), localNodeId, false);
            }
            long durationMillis = TimeValue.nsecToMSec(this.relativeTimeNanosSupplier.getAsLong() - startTimeNanos);
            this.remoteStateStats.stateDiffDownloadSucceeded();
            this.remoteStateStats.stateDiffDownloadTook(durationMillis);
            assert (includeEphemeral);
            this.remoteClusterStateCache.putState(clusterState);
            return clusterState;
        }
        catch (Exception e) {
            logger.error("Failure in downloading diff cluster state. ", (Throwable)e);
            this.remoteStateStats.stateDiffDownloadFailed();
            throw e;
        }
    }

    void validateClusterStateFromChecksum(ClusterMetadataManifest manifest, ClusterState clusterState, String clusterName, String localNodeId, boolean isFullStateDownload) {
        ClusterStateChecksum newClusterStateChecksum = new ClusterStateChecksum(clusterState, this.threadpool);
        List<String> failedValidation = newClusterStateChecksum.getMismatchEntities(manifest.getClusterStateChecksum());
        if (failedValidation.isEmpty()) {
            return;
        }
        logger.error(() -> new ParameterizedMessage("Cluster state checksums do not match. Checksum from manifest {}, checksum from created cluster state {}. Entities failing validation {}", new Object[]{manifest.getClusterStateChecksum(), newClusterStateChecksum, failedValidation}));
        if (isFullStateDownload) {
            this.remoteStateStats.stateFullDownloadValidationFailed();
        } else {
            this.remoteStateStats.stateDiffDownloadValidationFailed();
        }
        if (isFullStateDownload && this.remoteClusterStateValidationMode.equals((Object)RemoteClusterStateValidationMode.FAILURE)) {
            throw new IllegalStateException("Cluster state checksums do not match during full state read. Validation failed for " + String.valueOf(failedValidation));
        }
        if (this.remoteClusterStateValidationMode.equals((Object)RemoteClusterStateValidationMode.FAILURE) || this.remoteClusterStateValidationMode.equals((Object)RemoteClusterStateValidationMode.TRACE)) {
            ClusterState fullClusterState = this.readClusterStateInParallel(ClusterState.builder(new ClusterName(clusterName)).build(), manifest, manifest.getClusterUUID(), localNodeId, manifest.getIndices(), manifest.getCustomMetadataMap(), manifest.getCoordinationMetadata() != null, manifest.getSettingsMetadata() != null, manifest.getTransientSettingsMetadata() != null, manifest.getTemplatesMetadata() != null, manifest.getDiscoveryNodesMetadata() != null, manifest.getClusterBlocksMetadata() != null, manifest.getIndicesRouting(), manifest.getHashesOfConsistentSettings() != null, manifest.getClusterStateCustomMap(), false, true);
            Iterator<String> iterator = failedValidation.iterator();
            block26: while (iterator.hasNext()) {
                String failedEntity;
                switch (failedEntity = iterator.next()) {
                    case "routing_table": {
                        Diff<RoutingTable> routingTableDiff = fullClusterState.routingTable().diff(clusterState.routingTable());
                        logger.error(() -> new ParameterizedMessage("Failing Diff in routing table {}", (Object)routingTableDiff));
                        continue block26;
                    }
                    case "discovery_nodes": {
                        logger.error(() -> new ParameterizedMessage("Failing Diff in discovery nodes {}", fullClusterState.nodes().diff(clusterState.nodes())));
                        continue block26;
                    }
                    case "blocks": {
                        logger.error(() -> new ParameterizedMessage("Failing Diff in cluster blocks {}", fullClusterState.blocks().diff(clusterState.blocks())));
                        continue block26;
                    }
                    case "customs": {
                        logger.error(() -> new ParameterizedMessage("Failing Diff in cluster state customs {}", DiffableUtils.diff(clusterState.customs(), fullClusterState.customs(), DiffableUtils.getStringKeySerializer(), ClusterState.CUSTOM_VALUE_SERIALIZER)));
                        continue block26;
                    }
                    case "coordination_md": {
                        logger.error(() -> new ParameterizedMessage("Failing Diff in coordination md. current md {}, full state md {}", (Object)clusterState.metadata().coordinationMetadata(), (Object)fullClusterState.metadata().coordinationMetadata()));
                        continue block26;
                    }
                    case "transient_settings_md": {
                        logger.error(() -> new ParameterizedMessage("Failing Diff in transient settings md. current md {}, full state md {}", (Object)clusterState.metadata().transientSettings(), (Object)fullClusterState.metadata().transientSettings()));
                        continue block26;
                    }
                    case "settings_md": {
                        logger.error(() -> new ParameterizedMessage("Failing Diff in settings md. current md {}, full state md {}", (Object)clusterState.metadata().settings(), (Object)fullClusterState.metadata().settings()));
                        continue block26;
                    }
                    case "hashes_md": {
                        logger.error(() -> new ParameterizedMessage("Failing Diff in hashes md {}", ((DiffableStringMap)fullClusterState.metadata().hashesOfConsistentSettings()).diff((DiffableStringMap)clusterState.metadata().hashesOfConsistentSettings())));
                        continue block26;
                    }
                    case "templates_md": {
                        logger.error(() -> new ParameterizedMessage("Failing Diff in templates md{}", fullClusterState.metadata().templatesMetadata().diff(clusterState.metadata().templatesMetadata())));
                        continue block26;
                    }
                    case "customs_md": {
                        logger.error(() -> new ParameterizedMessage("Failing Diff in customs md {}", DiffableUtils.diff(clusterState.metadata().customs(), fullClusterState.metadata().customs(), DiffableUtils.getStringKeySerializer(), Metadata.CUSTOM_VALUE_SERIALIZER)));
                        continue block26;
                    }
                    case "indices_md": {
                        logger.error(() -> new ParameterizedMessage("Failing Diff in index md {}", DiffableUtils.diff(clusterState.metadata().indices(), fullClusterState.metadata().indices(), DiffableUtils.getStringKeySerializer())));
                        continue block26;
                    }
                }
                logger.error(() -> new ParameterizedMessage("Unknown failed entity {}", (Object)failedEntity));
            }
        }
        if (this.remoteClusterStateValidationMode.equals((Object)RemoteClusterStateValidationMode.FAILURE)) {
            throw new IllegalStateException("Cluster state checksums do not match during diff read. Validation failed for " + String.valueOf(failedValidation));
        }
    }

    public String getLastKnownUUIDFromRemote(String clusterName) {
        try {
            Set<String> clusterUUIDs = this.getAllClusterUUIDs(clusterName);
            Map<String, ClusterMetadataManifest> latestManifests = this.remoteManifestManager.getLatestManifestForAllClusterUUIDs(clusterName, clusterUUIDs);
            List<String> validChain = this.createClusterChain(latestManifests, clusterName);
            if (validChain.isEmpty()) {
                return "_na_";
            }
            return validChain.get(0);
        }
        catch (IOException e) {
            throw new IllegalStateException(String.format(Locale.ROOT, "Error while fetching previous UUIDs from remote store for cluster name: %s", clusterName), e);
        }
    }

    public boolean isRemotePublicationEnabled() {
        return this.isPublicationEnabled.get();
    }

    public void setRemoteStateReadTimeout(TimeValue remoteStateReadTimeout) {
        this.remoteStateReadTimeout = remoteStateReadTimeout;
    }

    private BlobStoreTransferService getBlobStoreTransferService() {
        if (this.blobStoreTransferService == null) {
            this.blobStoreTransferService = new BlobStoreTransferService(this.getBlobStore(), this.threadpool);
        }
        return this.blobStoreTransferService;
    }

    Set<String> getAllClusterUUIDs(String clusterName) throws IOException {
        Map<String, BlobContainer> clusterUUIDMetadata = RemoteClusterStateUtils.clusterUUIDContainer(this.blobStoreRepository, clusterName).children();
        if (clusterUUIDMetadata == null) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(clusterUUIDMetadata.keySet());
    }

    private Map<String, ClusterMetadataManifest> getLatestManifestForAllClusterUUIDs(String clusterName, Set<String> clusterUUIDs) {
        HashMap<String, ClusterMetadataManifest> manifestsByClusterUUID = new HashMap<String, ClusterMetadataManifest>();
        for (String clusterUUID : clusterUUIDs) {
            try {
                Optional<ClusterMetadataManifest> manifest = this.getLatestClusterMetadataManifest(clusterName, clusterUUID);
                manifest.ifPresent(clusterMetadataManifest -> manifestsByClusterUUID.put(clusterUUID, (ClusterMetadataManifest)clusterMetadataManifest));
            }
            catch (Exception e) {
                throw new IllegalStateException(String.format(Locale.ROOT, "Exception in fetching manifest for clusterUUID: %s", clusterUUID), e);
            }
        }
        return manifestsByClusterUUID;
    }

    private List<String> createClusterChain(Map<String, ClusterMetadataManifest> manifestsByClusterUUID, String clusterName) {
        List validClusterManifests = manifestsByClusterUUID.values().stream().filter(this::isValidClusterUUID).collect(Collectors.toList());
        Map<String, String> clusterUUIDGraph = validClusterManifests.stream().collect(Collectors.toMap(ClusterMetadataManifest::getClusterUUID, ClusterMetadataManifest::getPreviousClusterUUID));
        List<String> topLevelClusterUUIDs = validClusterManifests.stream().map(ClusterMetadataManifest::getClusterUUID).filter(clusterUUID -> !clusterUUIDGraph.containsValue(clusterUUID)).collect(Collectors.toList());
        if (topLevelClusterUUIDs.isEmpty()) {
            assert (validClusterManifests.isEmpty()) : "There are no top level cluster UUIDs even when there are valid cluster UUIDs";
            logger.info("There is no valid previous cluster UUID. All cluster UUIDs evaluated are: {}", manifestsByClusterUUID.keySet());
            return Collections.emptyList();
        }
        if (topLevelClusterUUIDs.size() > 1) {
            logger.info("Top level cluster UUIDs: {}", topLevelClusterUUIDs);
            Map<String, ClusterMetadataManifest> manifestsByClusterUUIDTrimmed = this.trimClusterUUIDs(manifestsByClusterUUID, topLevelClusterUUIDs, clusterName);
            if (manifestsByClusterUUID.size() == manifestsByClusterUUIDTrimmed.size()) {
                throw new IllegalStateException(String.format(Locale.ROOT, "The system has ended into multiple valid cluster states in the remote store. Please check their latest manifest to decide which one you want to keep. Valid Cluster UUIDs: - %s", topLevelClusterUUIDs));
            }
            return this.createClusterChain(manifestsByClusterUUIDTrimmed, clusterName);
        }
        ArrayList<String> validChain = new ArrayList<String>();
        String currentUUID = (String)topLevelClusterUUIDs.get(0);
        while (currentUUID != null && !"_na_".equals(currentUUID)) {
            validChain.add(currentUUID);
            currentUUID = clusterUUIDGraph.get(currentUUID);
        }
        logger.info("Known UUIDs found in remote store : [{}]", validChain);
        return validChain;
    }

    private Map<String, ClusterMetadataManifest> trimClusterUUIDs(Map<String, ClusterMetadataManifest> latestManifestsByClusterUUID, List<String> validClusterUUIDs, String clusterName) {
        HashMap<String, ClusterMetadataManifest> trimmedUUIDs = new HashMap<String, ClusterMetadataManifest>(latestManifestsByClusterUUID);
        for (String clusterUUID : validClusterUUIDs) {
            ClusterMetadataManifest previousManifest;
            ClusterMetadataManifest currentManifest = (ClusterMetadataManifest)trimmedUUIDs.get(clusterUUID);
            if ("_na_".equals(currentManifest.getPreviousClusterUUID()) || !this.isMetadataEqual(currentManifest, previousManifest = (ClusterMetadataManifest)trimmedUUIDs.get(currentManifest.getPreviousClusterUUID()), clusterName) || !this.remoteGlobalMetadataManager.isGlobalMetadataEqual(currentManifest, previousManifest, clusterName)) continue;
            trimmedUUIDs.remove(clusterUUID);
        }
        return trimmedUUIDs;
    }

    private boolean isMetadataEqual(ClusterMetadataManifest first, ClusterMetadataManifest second, String clusterName) {
        if (first.getIndices().size() != second.getIndices().size()) {
            return false;
        }
        Map secondIndices = second.getIndices().stream().collect(Collectors.toMap(ClusterMetadataManifest.UploadedIndexMetadata::getIndexName, Function.identity()));
        for (ClusterMetadataManifest.UploadedIndexMetadata uploadedIndexMetadata : first.getIndices()) {
            IndexMetadata firstIndexMetadata = this.remoteIndexMetadataManager.getIndexMetadata(uploadedIndexMetadata, first.getClusterUUID());
            ClusterMetadataManifest.UploadedIndexMetadata secondUploadedIndexMetadata = (ClusterMetadataManifest.UploadedIndexMetadata)secondIndices.get(uploadedIndexMetadata.getIndexName());
            if (secondUploadedIndexMetadata == null) {
                return false;
            }
            IndexMetadata secondIndexMetadata = this.remoteIndexMetadataManager.getIndexMetadata(secondUploadedIndexMetadata, second.getClusterUUID());
            if (firstIndexMetadata.equals(secondIndexMetadata)) continue;
            return false;
        }
        return true;
    }

    private boolean isValidClusterUUID(ClusterMetadataManifest manifest) {
        return manifest.isClusterUUIDCommitted();
    }

    void setRemoteIndexMetadataManager(RemoteIndexMetadataManager remoteIndexMetadataManager) {
        this.remoteIndexMetadataManager = remoteIndexMetadataManager;
    }

    void setRemoteGlobalMetadataManager(RemoteGlobalMetadataManager remoteGlobalMetadataManager) {
        this.remoteGlobalMetadataManager = remoteGlobalMetadataManager;
    }

    void setRemoteClusterStateAttributesManager(RemoteClusterStateAttributesManager remoteClusterStateAttributeManager) {
        this.remoteClusterStateAttributesManager = remoteClusterStateAttributeManager;
    }

    public void writeMetadataFailed() {
        this.remoteStateStats.stateUploadFailed();
    }

    public RemotePersistenceStats getRemoteStateStats() {
        return this.remoteStateStats;
    }

    public PersistedStateStats getUploadStats() {
        return this.remoteStateStats.getUploadStats();
    }

    public PersistedStateStats getFullDownloadStats() {
        return this.remoteStateStats.getRemoteFullDownloadStats();
    }

    public PersistedStateStats getDiffDownloadStats() {
        return this.remoteStateStats.getRemoteDiffDownloadStats();
    }

    public void fullIncomingPublicationFailed() {
        this.remoteStateStats.stateFullIncomingPublicationFailed();
    }

    public void diffIncomingPublicationFailed() {
        this.remoteStateStats.stateDiffIncomingPublicationFailed();
    }

    RemoteClusterStateCache getRemoteClusterStateCache() {
        return this.remoteClusterStateCache;
    }

    static {
        HashMap<String, String> params = new HashMap<String, String>(1);
        params.put("context_mode", Metadata.CONTEXT_MODE_GATEWAY);
        FORMAT_PARAMS = new ToXContent.MapParams(params);
    }

    public static enum RemoteClusterStateValidationMode {
        DEBUG("debug"),
        TRACE("trace"),
        FAILURE("failure"),
        NONE("none");

        public final String mode;

        private RemoteClusterStateValidationMode(String mode) {
            this.mode = mode;
        }

        public static RemoteClusterStateValidationMode parseString(String mode) {
            try {
                return RemoteClusterStateValidationMode.valueOf(mode.toUpperCase(Locale.ROOT));
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("[" + mode + "] mode is not supported. supported modes are [" + Arrays.toString((Object[])RemoteClusterStateValidationMode.values()) + "]");
            }
        }
    }
}

