/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.gateway.remote;

import java.io.IOException;
import java.util.Locale;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.metadata.IndexMetadata;
import org.graylog.shaded.opensearch2.org.opensearch.common.remote.AbstractClusterMetadataWriteableBlobEntity;
import org.graylog.shaded.opensearch2.org.opensearch.common.remote.AbstractRemoteWritableEntityManager;
import org.graylog.shaded.opensearch2.org.opensearch.common.remote.RemoteWriteableEntityBlobStore;
import org.graylog.shaded.opensearch2.org.opensearch.common.settings.ClusterSettings;
import org.graylog.shaded.opensearch2.org.opensearch.common.settings.Setting;
import org.graylog.shaded.opensearch2.org.opensearch.common.unit.TimeValue;
import org.graylog.shaded.opensearch2.org.opensearch.core.action.ActionListener;
import org.graylog.shaded.opensearch2.org.opensearch.core.compress.Compressor;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.NamedXContentRegistry;
import org.graylog.shaded.opensearch2.org.opensearch.gateway.remote.ClusterMetadataManifest;
import org.graylog.shaded.opensearch2.org.opensearch.gateway.remote.RemoteClusterStateUtils;
import org.graylog.shaded.opensearch2.org.opensearch.gateway.remote.RemoteStateTransferException;
import org.graylog.shaded.opensearch2.org.opensearch.gateway.remote.model.RemoteIndexMetadata;
import org.graylog.shaded.opensearch2.org.opensearch.gateway.remote.model.RemoteReadResult;
import org.graylog.shaded.opensearch2.org.opensearch.index.remote.RemoteStoreEnums;
import org.graylog.shaded.opensearch2.org.opensearch.index.translog.transfer.BlobStoreTransferService;
import org.graylog.shaded.opensearch2.org.opensearch.repositories.blobstore.BlobStoreRepository;
import org.graylog.shaded.opensearch2.org.opensearch.threadpool.ThreadPool;

public class RemoteIndexMetadataManager
extends AbstractRemoteWritableEntityManager {
    public static final TimeValue INDEX_METADATA_UPLOAD_TIMEOUT_DEFAULT = TimeValue.timeValueMillis(20000L);
    public static final Setting<TimeValue> INDEX_METADATA_UPLOAD_TIMEOUT_SETTING = Setting.timeSetting("cluster.remote_store.state.index_metadata.upload_timeout", INDEX_METADATA_UPLOAD_TIMEOUT_DEFAULT, Setting.Property.Dynamic, Setting.Property.NodeScope, Setting.Property.Deprecated);
    public static final Setting<RemoteStoreEnums.PathType> REMOTE_INDEX_METADATA_PATH_TYPE_SETTING = new Setting<RemoteStoreEnums.PathType>("cluster.remote_store.index_metadata.path_type", RemoteStoreEnums.PathType.HASHED_PREFIX.toString(), RemoteStoreEnums.PathType::parseString, Setting.Property.NodeScope, Setting.Property.Dynamic);
    public static final Setting<RemoteStoreEnums.PathHashAlgorithm> REMOTE_INDEX_METADATA_PATH_HASH_ALGO_SETTING = new Setting<RemoteStoreEnums.PathHashAlgorithm>("cluster.remote_store.index_metadata.path_hash_algo", RemoteStoreEnums.PathHashAlgorithm.FNV_1A_BASE64.toString(), RemoteStoreEnums.PathHashAlgorithm::parseString, Setting.Property.NodeScope, Setting.Property.Dynamic);
    private final Compressor compressor;
    private final NamedXContentRegistry namedXContentRegistry;
    private volatile TimeValue indexMetadataUploadTimeout;
    private RemoteStoreEnums.PathType pathType;
    private RemoteStoreEnums.PathHashAlgorithm pathHashAlgo;

    public RemoteIndexMetadataManager(ClusterSettings clusterSettings, String clusterName, BlobStoreRepository blobStoreRepository, BlobStoreTransferService blobStoreTransferService, ThreadPool threadpool) {
        this.remoteWritableEntityStores.put("index", new RemoteWriteableEntityBlobStore(blobStoreTransferService, blobStoreRepository, clusterName, threadpool, "remote_state_read", "cluster-state"));
        this.namedXContentRegistry = blobStoreRepository.getNamedXContentRegistry();
        this.compressor = blobStoreRepository.getCompressor();
        this.indexMetadataUploadTimeout = clusterSettings.get(INDEX_METADATA_UPLOAD_TIMEOUT_SETTING);
        this.pathType = clusterSettings.get(REMOTE_INDEX_METADATA_PATH_TYPE_SETTING);
        this.pathHashAlgo = clusterSettings.get(REMOTE_INDEX_METADATA_PATH_HASH_ALGO_SETTING);
        clusterSettings.addSettingsUpdateConsumer(INDEX_METADATA_UPLOAD_TIMEOUT_SETTING, this::setIndexMetadataUploadTimeout);
        clusterSettings.addSettingsUpdateConsumer(REMOTE_INDEX_METADATA_PATH_TYPE_SETTING, this::setPathTypeSetting);
        clusterSettings.addSettingsUpdateConsumer(REMOTE_INDEX_METADATA_PATH_HASH_ALGO_SETTING, this::setPathHashAlgoSetting);
    }

    IndexMetadata getIndexMetadata(ClusterMetadataManifest.UploadedIndexMetadata uploadedIndexMetadata, String clusterUUID) {
        RemoteIndexMetadata remoteIndexMetadata = new RemoteIndexMetadata(RemoteClusterStateUtils.getFormattedIndexFileName(uploadedIndexMetadata.getUploadedFilename()), clusterUUID, this.compressor, this.namedXContentRegistry);
        try {
            return (IndexMetadata)this.getStore(remoteIndexMetadata).read(remoteIndexMetadata);
        }
        catch (IOException e) {
            throw new IllegalStateException(String.format(Locale.ROOT, "Error while downloading IndexMetadata - %s", uploadedIndexMetadata.getUploadedFilename()), e);
        }
    }

    public TimeValue getIndexMetadataUploadTimeout() {
        return this.indexMetadataUploadTimeout;
    }

    private void setIndexMetadataUploadTimeout(TimeValue newIndexMetadataUploadTimeout) {
        this.indexMetadataUploadTimeout = newIndexMetadataUploadTimeout;
    }

    @Override
    protected ActionListener<Void> getWrappedWriteListener(String component, AbstractClusterMetadataWriteableBlobEntity remoteEntity, ActionListener<ClusterMetadataManifest.UploadedMetadata> listener) {
        return ActionListener.wrap(resp -> listener.onResponse(remoteEntity.getUploadedMetadata()), ex -> listener.onFailure(new RemoteStateTransferException("Upload failed for " + component, remoteEntity, (Throwable)ex)));
    }

    @Override
    protected ActionListener<Object> getWrappedReadListener(String component, AbstractClusterMetadataWriteableBlobEntity remoteEntity, ActionListener<RemoteReadResult> listener) {
        return ActionListener.wrap(response -> listener.onResponse(new RemoteReadResult(response, "index", component)), ex -> listener.onFailure(new RemoteStateTransferException("Download failed for " + component, remoteEntity, (Throwable)ex)));
    }

    private void setPathTypeSetting(RemoteStoreEnums.PathType pathType) {
        this.pathType = pathType;
    }

    private void setPathHashAlgoSetting(RemoteStoreEnums.PathHashAlgorithm pathHashAlgo) {
        this.pathHashAlgo = pathHashAlgo;
    }

    protected RemoteStoreEnums.PathType getPathTypeSetting() {
        return this.pathType;
    }

    protected RemoteStoreEnums.PathHashAlgorithm getPathHashAlgoSetting() {
        return this.pathHashAlgo;
    }
}

