/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.gateway.remote.model;

import org.graylog.shaded.opensearch2.org.opensearch.common.blobstore.BlobPath;
import org.graylog.shaded.opensearch2.org.opensearch.common.remote.AbstractClusterMetadataWriteableBlobEntity;
import org.graylog.shaded.opensearch2.org.opensearch.common.remote.RemoteWriteableBlobEntity;
import org.graylog.shaded.opensearch2.org.opensearch.common.remote.RemoteWriteableEntityBlobStore;
import org.graylog.shaded.opensearch2.org.opensearch.common.settings.ClusterSettings;
import org.graylog.shaded.opensearch2.org.opensearch.common.settings.Setting;
import org.graylog.shaded.opensearch2.org.opensearch.index.remote.RemoteStoreEnums;
import org.graylog.shaded.opensearch2.org.opensearch.index.remote.RemoteStorePathStrategy;
import org.graylog.shaded.opensearch2.org.opensearch.index.translog.transfer.BlobStoreTransferService;
import org.graylog.shaded.opensearch2.org.opensearch.repositories.blobstore.BlobStoreRepository;
import org.graylog.shaded.opensearch2.org.opensearch.threadpool.ThreadPool;

public class RemoteRoutingTableBlobStore<IndexRoutingTable, U extends AbstractClusterMetadataWriteableBlobEntity<IndexRoutingTable>>
extends RemoteWriteableEntityBlobStore<IndexRoutingTable, U> {
    public static final Setting<RemoteStoreEnums.PathType> REMOTE_ROUTING_TABLE_PATH_TYPE_SETTING = new Setting<RemoteStoreEnums.PathType>("cluster.remote_store.routing_table.path_type", RemoteStoreEnums.PathType.HASHED_PREFIX.toString(), RemoteStoreEnums.PathType::parseString, Setting.Property.NodeScope, Setting.Property.Dynamic);
    public static final Setting<RemoteStoreEnums.PathHashAlgorithm> REMOTE_ROUTING_TABLE_PATH_HASH_ALGO_SETTING = new Setting<RemoteStoreEnums.PathHashAlgorithm>("cluster.remote_store.routing_table.path_hash_algo", RemoteStoreEnums.PathHashAlgorithm.FNV_1A_BASE64.toString(), RemoteStoreEnums.PathHashAlgorithm::parseString, Setting.Property.NodeScope, Setting.Property.Dynamic);
    public static final Setting<String> CLUSTER_REMOTE_STORE_ROUTING_TABLE_PATH_PREFIX = Setting.simpleString("cluster.remote_store.routing_table.path.prefix", "", Setting.Property.NodeScope, Setting.Property.Final);
    private RemoteStoreEnums.PathType pathType;
    private RemoteStoreEnums.PathHashAlgorithm pathHashAlgo;
    private String pathPrefix;

    public RemoteRoutingTableBlobStore(BlobStoreTransferService blobStoreTransferService, BlobStoreRepository blobStoreRepository, String clusterName, ThreadPool threadPool, String executor, ClusterSettings clusterSettings) {
        super(blobStoreTransferService, blobStoreRepository, clusterName, threadPool, executor, "cluster-state");
        this.pathType = clusterSettings.get(REMOTE_ROUTING_TABLE_PATH_TYPE_SETTING);
        this.pathHashAlgo = clusterSettings.get(REMOTE_ROUTING_TABLE_PATH_HASH_ALGO_SETTING);
        this.pathPrefix = clusterSettings.get(CLUSTER_REMOTE_STORE_ROUTING_TABLE_PATH_PREFIX);
        clusterSettings.addSettingsUpdateConsumer(REMOTE_ROUTING_TABLE_PATH_TYPE_SETTING, this::setPathTypeSetting);
        clusterSettings.addSettingsUpdateConsumer(REMOTE_ROUTING_TABLE_PATH_HASH_ALGO_SETTING, this::setPathHashAlgoSetting);
    }

    @Override
    public BlobPath getBlobPathForUpload(RemoteWriteableBlobEntity<IndexRoutingTable> obj) {
        assert (obj.getBlobPathParameters().getPathTokens().size() == 1) : "Unexpected tokens in RemoteRoutingTableObject";
        BlobPath indexRoutingPath = this.getBlobPathPrefix(obj.clusterUUID()).add("index-routing");
        BlobPath path = this.pathType.path(((RemoteStorePathStrategy.BasePathInput.Builder)((RemoteStorePathStrategy.BasePathInput.Builder)((RemoteStorePathStrategy.BasePathInput.Builder)RemoteStorePathStrategy.BasePathInput.builder().fixedPrefix(this.pathPrefix)).basePath(indexRoutingPath)).indexUUID(String.join((CharSequence)"", obj.getBlobPathParameters().getPathTokens()))).build(), this.pathHashAlgo);
        return path;
    }

    private void setPathTypeSetting(RemoteStoreEnums.PathType pathType) {
        this.pathType = pathType;
    }

    private void setPathHashAlgoSetting(RemoteStoreEnums.PathHashAlgorithm pathHashAlgo) {
        this.pathHashAlgo = pathHashAlgo;
    }

    protected RemoteStoreEnums.PathType getPathTypeSetting() {
        return this.pathType;
    }

    protected RemoteStoreEnums.PathHashAlgorithm getPathHashAlgoSetting() {
        return this.pathHashAlgo;
    }
}

