/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.geometry;

import org.graylog.shaded.opensearch2.org.opensearch.geometry.Geometry;
import org.graylog.shaded.opensearch2.org.opensearch.geometry.GeometryVisitor;
import org.graylog.shaded.opensearch2.org.opensearch.geometry.ShapeType;
import org.graylog.shaded.opensearch2.org.opensearch.geometry.utils.WellKnownText;

public class Circle
implements Geometry {
    public static final Circle EMPTY = new Circle();
    private final double y;
    private final double x;
    private final double z;
    private final double radiusMeters;

    private Circle() {
        this.y = 0.0;
        this.x = 0.0;
        this.z = Double.NaN;
        this.radiusMeters = -1.0;
    }

    public Circle(double x, double y, double radiusMeters) {
        this(x, y, Double.NaN, radiusMeters);
    }

    public Circle(double x, double y, double z, double radiusMeters) {
        this.y = y;
        this.x = x;
        this.radiusMeters = radiusMeters;
        this.z = z;
        if (radiusMeters < 0.0) {
            throw new IllegalArgumentException("Circle radius [" + radiusMeters + "] cannot be negative");
        }
    }

    @Override
    public ShapeType type() {
        return ShapeType.CIRCLE;
    }

    public double getY() {
        return this.y;
    }

    public double getX() {
        return this.x;
    }

    public double getRadiusMeters() {
        return this.radiusMeters;
    }

    public double getZ() {
        return this.z;
    }

    public double getLat() {
        return this.y;
    }

    public double getLon() {
        return this.x;
    }

    public double getAlt() {
        return this.z;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Circle circle = (Circle)o;
        if (Double.compare(circle.y, this.y) != 0) {
            return false;
        }
        if (Double.compare(circle.x, this.x) != 0) {
            return false;
        }
        if (Double.compare(circle.radiusMeters, this.radiusMeters) != 0) {
            return false;
        }
        return Double.compare(circle.z, this.z) == 0;
    }

    public int hashCode() {
        long temp = Double.doubleToLongBits(this.y);
        int result = (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.x);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.radiusMeters);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.z);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    @Override
    public <T, E extends Exception> T visit(GeometryVisitor<T, E> visitor) throws E {
        return visitor.visit(this);
    }

    @Override
    public boolean isEmpty() {
        return this.radiusMeters < 0.0;
    }

    public String toString() {
        return WellKnownText.INSTANCE.toWKT(this);
    }

    @Override
    public boolean hasZ() {
        return !Double.isNaN(this.z);
    }
}

