/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.index.analysis;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.graylog.shaded.opensearch2.org.opensearch.common.settings.Settings;
import org.graylog.shaded.opensearch2.org.opensearch.index.IndexSettings;
import org.graylog.shaded.opensearch2.org.opensearch.index.analysis.AbstractIndexAnalyzerProvider;
import org.graylog.shaded.opensearch2.org.opensearch.index.analysis.CharFilterFactory;
import org.graylog.shaded.opensearch2.org.opensearch.index.analysis.CustomAnalyzer;
import org.graylog.shaded.opensearch2.org.opensearch.index.analysis.NormalizingCharFilterFactory;
import org.graylog.shaded.opensearch2.org.opensearch.index.analysis.NormalizingTokenFilterFactory;
import org.graylog.shaded.opensearch2.org.opensearch.index.analysis.TokenFilterFactory;
import org.graylog.shaded.opensearch2.org.opensearch.index.analysis.TokenizerFactory;

public final class CustomNormalizerProvider
extends AbstractIndexAnalyzerProvider<CustomAnalyzer> {
    private final Settings analyzerSettings;
    private CustomAnalyzer customAnalyzer;

    public CustomNormalizerProvider(IndexSettings indexSettings, String name, Settings settings) {
        super(indexSettings, name, settings);
        this.analyzerSettings = settings;
    }

    public void build(TokenizerFactory tokenizerFactory, Map<String, CharFilterFactory> charFilters, Map<String, TokenFilterFactory> tokenFilters) {
        if (this.analyzerSettings.get("tokenizer") != null) {
            throw new IllegalArgumentException("Custom normalizer [" + this.name() + "] cannot configure a tokenizer");
        }
        List<String> charFilterNames = this.analyzerSettings.getAsList("char_filter");
        ArrayList<CharFilterFactory> charFiltersList = new ArrayList<CharFilterFactory>(charFilterNames.size());
        for (String charFilterName : charFilterNames) {
            CharFilterFactory charFilter = charFilters.get(charFilterName);
            if (charFilter == null) {
                throw new IllegalArgumentException("Custom normalizer [" + this.name() + "] failed to find char_filter under name [" + charFilterName + "]");
            }
            if (!(charFilter instanceof NormalizingCharFilterFactory)) {
                throw new IllegalArgumentException("Custom normalizer [" + this.name() + "] may not use char filter [" + charFilterName + "]");
            }
            charFiltersList.add(charFilter);
        }
        List<String> tokenFilterNames = this.analyzerSettings.getAsList("filter");
        ArrayList<TokenFilterFactory> tokenFilterList = new ArrayList<TokenFilterFactory>(tokenFilterNames.size());
        for (String tokenFilterName : tokenFilterNames) {
            TokenFilterFactory tokenFilter = tokenFilters.get(tokenFilterName);
            if (tokenFilter == null) {
                throw new IllegalArgumentException("Custom Analyzer [" + this.name() + "] failed to find filter under name [" + tokenFilterName + "]");
            }
            if (!(tokenFilter instanceof NormalizingTokenFilterFactory)) {
                throw new IllegalArgumentException("Custom normalizer [" + this.name() + "] may not use filter [" + tokenFilterName + "]");
            }
            tokenFilterList.add(tokenFilter);
        }
        this.customAnalyzer = new CustomAnalyzer(tokenizerFactory, charFiltersList.toArray(new CharFilterFactory[0]), tokenFilterList.toArray(new TokenFilterFactory[0]));
    }

    @Override
    public CustomAnalyzer get() {
        return this.customAnalyzer;
    }
}

