/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.index.analysis;

import java.util.function.Function;
import java.util.function.Supplier;
import org.graylog.shaded.opensearch2.org.apache.lucene.analysis.Tokenizer;
import org.graylog.shaded.opensearch2.org.opensearch.Version;
import org.graylog.shaded.opensearch2.org.opensearch.index.analysis.PreConfiguredAnalysisComponent;
import org.graylog.shaded.opensearch2.org.opensearch.index.analysis.TokenizerFactory;
import org.graylog.shaded.opensearch2.org.opensearch.indices.analysis.PreBuiltCacheFactory;

public final class PreConfiguredTokenizer
extends PreConfiguredAnalysisComponent<TokenizerFactory> {
    private final Function<Version, Tokenizer> create;

    public static PreConfiguredTokenizer singleton(String name, Supplier<Tokenizer> create) {
        return new PreConfiguredTokenizer(name, PreBuiltCacheFactory.CachingStrategy.ONE, version -> (Tokenizer)create.get());
    }

    public static PreConfiguredTokenizer luceneVersion(String name, Function<org.graylog.shaded.opensearch2.org.apache.lucene.util.Version, Tokenizer> create) {
        return new PreConfiguredTokenizer(name, PreBuiltCacheFactory.CachingStrategy.LUCENE, version -> (Tokenizer)create.apply(version.luceneVersion));
    }

    public static PreConfiguredTokenizer openSearchVersion(String name, Function<Version, Tokenizer> create) {
        return new PreConfiguredTokenizer(name, PreBuiltCacheFactory.CachingStrategy.OPENSEARCH, create);
    }

    private PreConfiguredTokenizer(String name, PreBuiltCacheFactory.CachingStrategy cache, Function<Version, Tokenizer> create) {
        super(name, cache);
        this.create = create;
    }

    @Override
    protected TokenizerFactory create(Version version) {
        return TokenizerFactory.newFactory(this.name, () -> this.create.apply(version));
    }
}

