/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.index.compositeindex.datacube;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.DocValuesType;
import org.graylog.shaded.opensearch2.org.opensearch.common.Rounding;
import org.graylog.shaded.opensearch2.org.opensearch.common.annotation.ExperimentalApi;
import org.graylog.shaded.opensearch2.org.opensearch.common.time.DateUtils;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.ToXContent;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.XContentBuilder;
import org.graylog.shaded.opensearch2.org.opensearch.index.compositeindex.datacube.DataCubeDateTimeUnit;
import org.graylog.shaded.opensearch2.org.opensearch.index.compositeindex.datacube.Dimension;
import org.graylog.shaded.opensearch2.org.opensearch.index.compositeindex.datacube.startree.utils.date.DateTimeUnitRounding;
import org.graylog.shaded.opensearch2.org.opensearch.index.mapper.DateFieldMapper;

@ExperimentalApi
public class DateDimension
implements Dimension {
    private final List<DateTimeUnitRounding> calendarIntervals;
    public static final String CALENDAR_INTERVALS = "calendar_intervals";
    public static final String DATE = "date";
    private final String field;
    private final List<DateTimeUnitRounding> sortedCalendarIntervals;
    private final DateFieldMapper.Resolution resolution;

    public DateDimension(String field, List<DateTimeUnitRounding> calendarIntervals, DateFieldMapper.Resolution resolution) {
        this.field = field;
        this.calendarIntervals = calendarIntervals;
        this.sortedCalendarIntervals = DateDimension.getSortedDateTimeUnits(calendarIntervals);
        this.resolution = resolution == null ? DateFieldMapper.Resolution.MILLISECONDS : resolution;
    }

    public List<DateTimeUnitRounding> getIntervals() {
        return this.calendarIntervals;
    }

    public List<DateTimeUnitRounding> getSortedCalendarIntervals() {
        return this.sortedCalendarIntervals;
    }

    @Override
    public void setDimensionValues(Long val, Consumer<Long> dimSetter) {
        for (DateTimeUnitRounding dateTimeUnit : this.sortedCalendarIntervals) {
            if (val == null) {
                dimSetter.accept(null);
                continue;
            }
            Long roundedValue = dateTimeUnit.roundFloor(this.storedDurationSinceEpoch(val));
            dimSetter.accept(roundedValue);
        }
    }

    private long storedDurationSinceEpoch(long nanoSecondsSinceEpoch) {
        if (this.resolution.equals((Object)DateFieldMapper.Resolution.NANOSECONDS)) {
            return DateUtils.toMilliSeconds(nanoSecondsSinceEpoch);
        }
        return nanoSecondsSinceEpoch;
    }

    @Override
    public List<String> getSubDimensionNames() {
        ArrayList<String> fields = new ArrayList<String>(this.calendarIntervals.size());
        for (DateTimeUnitRounding interval : this.sortedCalendarIntervals) {
            fields.add(this.field + "_" + interval.shortName());
        }
        return fields;
    }

    @Override
    public DocValuesType getDocValuesType() {
        return DocValuesType.SORTED_NUMERIC;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject("date_dimension");
        builder.field("name", this.getField());
        builder.field("type", DATE);
        builder.startArray(CALENDAR_INTERVALS);
        for (DateTimeUnitRounding interval : this.calendarIntervals) {
            builder.value(interval.shortName());
        }
        builder.endArray();
        builder.endObject();
        return builder;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DateDimension that = (DateDimension)o;
        return Objects.equals(this.field, that.getField()) && Objects.equals(this.calendarIntervals, that.calendarIntervals);
    }

    public int hashCode() {
        return Objects.hash(this.field, this.calendarIntervals);
    }

    @Override
    public String getField() {
        return this.field;
    }

    @Override
    public int getNumSubDimensions() {
        return this.calendarIntervals.size();
    }

    public DateTimeUnitRounding findClosestValidInterval(DateTimeUnitRounding searchInterval) {
        DateTimeUnitComparator comparator = new DateTimeUnitComparator();
        DateTimeUnitRounding closestValidInterval = null;
        for (DateTimeUnitRounding interval : this.sortedCalendarIntervals) {
            if (comparator.compare(interval, searchInterval) > 0) break;
            closestValidInterval = interval;
        }
        return closestValidInterval;
    }

    public static List<DateTimeUnitRounding> getSortedDateTimeUnits(List<DateTimeUnitRounding> dateTimeUnits) {
        return dateTimeUnits.stream().sorted(new DateTimeUnitComparator()).collect(Collectors.toList());
    }

    public static class DateTimeUnitComparator
    implements Comparator<DateTimeUnitRounding> {
        public static final Map<String, Integer> ORDERED_DATE_TIME_UNIT = new HashMap<String, Integer>();

        @Override
        public int compare(DateTimeUnitRounding unit1, DateTimeUnitRounding unit2) {
            return Integer.compare(ORDERED_DATE_TIME_UNIT.getOrDefault(unit1.shortName(), Integer.MAX_VALUE), ORDERED_DATE_TIME_UNIT.getOrDefault(unit2.shortName(), Integer.MAX_VALUE));
        }

        static {
            ORDERED_DATE_TIME_UNIT.put(Rounding.DateTimeUnit.SECOND_OF_MINUTE.shortName(), 1);
            ORDERED_DATE_TIME_UNIT.put(Rounding.DateTimeUnit.MINUTES_OF_HOUR.shortName(), 2);
            ORDERED_DATE_TIME_UNIT.put(DataCubeDateTimeUnit.QUARTER_HOUR_OF_DAY.shortName(), 3);
            ORDERED_DATE_TIME_UNIT.put(DataCubeDateTimeUnit.HALF_HOUR_OF_DAY.shortName(), 4);
            ORDERED_DATE_TIME_UNIT.put(Rounding.DateTimeUnit.HOUR_OF_DAY.shortName(), 5);
            ORDERED_DATE_TIME_UNIT.put(Rounding.DateTimeUnit.DAY_OF_MONTH.shortName(), 6);
            ORDERED_DATE_TIME_UNIT.put(Rounding.DateTimeUnit.WEEK_OF_WEEKYEAR.shortName(), 7);
            ORDERED_DATE_TIME_UNIT.put(Rounding.DateTimeUnit.MONTH_OF_YEAR.shortName(), 8);
            ORDERED_DATE_TIME_UNIT.put(Rounding.DateTimeUnit.QUARTER_OF_YEAR.shortName(), 9);
            ORDERED_DATE_TIME_UNIT.put(Rounding.DateTimeUnit.YEAR_OF_CENTURY.shortName(), 10);
        }
    }
}

