/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.index.compositeindex.datacube;

import java.util.Arrays;
import java.util.List;
import org.graylog.shaded.opensearch2.org.opensearch.common.annotation.ExperimentalApi;

@ExperimentalApi
public enum MetricStat {
    VALUE_COUNT("value_count", 0),
    SUM("sum", 1),
    MIN("min", 2),
    MAX("max", 3),
    AVG("avg", 4, VALUE_COUNT, SUM),
    DOC_COUNT("doc_count", true, 5, new MetricStat[0]);

    private final String typeName;
    private final MetricStat[] baseMetrics;
    private final int metricOrdinal;
    private final boolean isSystemFieldStat;

    private MetricStat(String typeName, int metricOrdinal) {
        this(typeName, false, metricOrdinal, new MetricStat[0]);
    }

    private MetricStat(String typeName, int metricOrdinal, MetricStat ... baseMetrics) {
        this(typeName, false, metricOrdinal, baseMetrics);
    }

    private MetricStat(String typeName, boolean isSystemFieldStat, int metricOrdinal, MetricStat ... baseMetrics) {
        this.typeName = typeName;
        this.isSystemFieldStat = isSystemFieldStat;
        this.baseMetrics = baseMetrics;
        this.metricOrdinal = metricOrdinal;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public int getMetricOrdinal() {
        return this.metricOrdinal;
    }

    public List<MetricStat> getBaseMetrics() {
        return Arrays.asList(this.baseMetrics);
    }

    public boolean isDerivedMetric() {
        return this.baseMetrics != null && this.baseMetrics.length > 0;
    }

    public static MetricStat fromTypeName(String typeName) {
        for (MetricStat metric : MetricStat.values()) {
            if (!metric.getTypeName().equalsIgnoreCase(typeName) || metric.isSystemFieldStat) continue;
            return metric;
        }
        throw new IllegalArgumentException("Invalid metric stat: " + typeName);
    }

    public static MetricStat fromMetricOrdinal(int metricOrdinal) {
        for (MetricStat metric : MetricStat.values()) {
            if (metric.getMetricOrdinal() != metricOrdinal) continue;
            return metric;
        }
        throw new IllegalArgumentException("Invalid metric stat: " + metricOrdinal);
    }
}

