/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.index.compositeindex.datacube.startree;

import java.util.Locale;
import java.util.Set;
import org.graylog.shaded.opensearch2.org.opensearch.common.annotation.ExperimentalApi;
import org.graylog.shaded.opensearch2.org.opensearch.index.IndexSettings;
import org.graylog.shaded.opensearch2.org.opensearch.index.compositeindex.CompositeIndexSettings;
import org.graylog.shaded.opensearch2.org.opensearch.index.compositeindex.datacube.Dimension;
import org.graylog.shaded.opensearch2.org.opensearch.index.compositeindex.datacube.Metric;
import org.graylog.shaded.opensearch2.org.opensearch.index.compositeindex.datacube.startree.StarTreeIndexSettings;
import org.graylog.shaded.opensearch2.org.opensearch.index.mapper.CompositeMappedFieldType;
import org.graylog.shaded.opensearch2.org.opensearch.index.mapper.DocCountFieldMapper;
import org.graylog.shaded.opensearch2.org.opensearch.index.mapper.MappedFieldType;
import org.graylog.shaded.opensearch2.org.opensearch.index.mapper.MapperService;
import org.graylog.shaded.opensearch2.org.opensearch.index.mapper.StarTreeMapper;

@ExperimentalApi
public class StarTreeValidator {
    public static void validate(MapperService mapperService, CompositeIndexSettings compositeIndexSettings, IndexSettings indexSettings) {
        Set<CompositeMappedFieldType> compositeFieldTypes = mapperService.getCompositeFieldTypes();
        if (compositeFieldTypes.size() > StarTreeIndexSettings.STAR_TREE_MAX_FIELDS_SETTING.get(indexSettings.getSettings())) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "Index cannot have more than [%s] star tree fields", StarTreeIndexSettings.STAR_TREE_MAX_FIELDS_SETTING.get(indexSettings.getSettings())));
        }
        for (CompositeMappedFieldType compositeFieldType : compositeFieldTypes) {
            MappedFieldType ft;
            if (!(compositeFieldType instanceof StarTreeMapper.StarTreeFieldType)) continue;
            if (!compositeIndexSettings.isStarTreeIndexCreationEnabled()) {
                throw new IllegalArgumentException(String.format(Locale.ROOT, "star tree index cannot be created, enable it using [%s] setting", CompositeIndexSettings.STAR_TREE_INDEX_ENABLED_SETTING.getKey()));
            }
            StarTreeMapper.StarTreeFieldType dataCubeFieldType = (StarTreeMapper.StarTreeFieldType)compositeFieldType;
            for (Dimension dim : dataCubeFieldType.getDimensions()) {
                ft = mapperService.fieldType(dim.getField());
                if (ft == null) {
                    throw new IllegalArgumentException(String.format(Locale.ROOT, "unknown dimension field [%s] as part of star tree field", dim.getField()));
                }
                if (ft.isAggregatable()) continue;
                throw new IllegalArgumentException(String.format(Locale.ROOT, "Aggregations not supported for the dimension field [%s] with field type [%s] as part of star tree field", dim.getField(), ft.typeName()));
            }
            for (Metric metric : dataCubeFieldType.getMetrics()) {
                ft = mapperService.fieldType(metric.getField());
                if (ft == null) {
                    throw new IllegalArgumentException(String.format(Locale.ROOT, "unknown metric field [%s] as part of star tree field", metric.getField()));
                }
                if (ft.isAggregatable() || ft instanceof DocCountFieldMapper.DocCountFieldType) continue;
                throw new IllegalArgumentException(String.format(Locale.ROOT, "Aggregations not supported for the metrics field [%s] with field type [%s] as part of star tree field", metric.getField(), ft.typeName()));
            }
        }
    }
}

