/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.index.compositeindex.datacube.startree.aggregators;

import java.util.Comparator;
import java.util.Objects;
import org.graylog.shaded.opensearch2.org.opensearch.index.compositeindex.datacube.MetricStat;
import org.graylog.shaded.opensearch2.org.opensearch.index.compositeindex.datacube.startree.aggregators.ValueAggregator;
import org.graylog.shaded.opensearch2.org.opensearch.index.compositeindex.datacube.startree.aggregators.ValueAggregatorFactory;
import org.graylog.shaded.opensearch2.org.opensearch.index.mapper.FieldValueConverter;

public class MetricAggregatorInfo
implements Comparable<MetricAggregatorInfo> {
    public static final String DELIMITER = "_";
    private final String metric;
    private final String starFieldName;
    private final MetricStat metricStat;
    private final String field;
    private final ValueAggregator valueAggregators;
    private final FieldValueConverter fieldValueConverter;

    public MetricAggregatorInfo(MetricStat metricStat, String field, String starFieldName, FieldValueConverter fieldValueConverter) {
        this.metricStat = metricStat;
        this.fieldValueConverter = fieldValueConverter;
        this.valueAggregators = ValueAggregatorFactory.getValueAggregator(metricStat, this.fieldValueConverter);
        this.field = field;
        this.starFieldName = starFieldName;
        this.metric = this.toFieldName();
    }

    public MetricStat getMetricStat() {
        return this.metricStat;
    }

    public String getField() {
        return this.field;
    }

    public String getMetric() {
        return this.metric;
    }

    public ValueAggregator getValueAggregators() {
        return this.valueAggregators;
    }

    public FieldValueConverter getNumericFieldConverter() {
        return this.fieldValueConverter;
    }

    public String toFieldName() {
        return MetricAggregatorInfo.toFieldName(this.starFieldName, this.field, this.metricStat.getTypeName());
    }

    public static String toFieldName(String starFieldName, String field, String metricName) {
        return starFieldName + DELIMITER + field + DELIMITER + metricName;
    }

    public int hashCode() {
        return Objects.hashCode(this.toFieldName());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof MetricAggregatorInfo) {
            MetricAggregatorInfo anotherPair = (MetricAggregatorInfo)obj;
            return this.metricStat.equals((Object)anotherPair.metricStat) && this.field.equals(anotherPair.field);
        }
        return false;
    }

    public String toString() {
        return this.toFieldName();
    }

    @Override
    public int compareTo(MetricAggregatorInfo other) {
        return Comparator.comparing(o -> o.field).thenComparing(o -> o.metricStat).compare(this, other);
    }
}

