/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.index.compositeindex.datacube.startree.aggregators;

import org.graylog.shaded.opensearch2.org.opensearch.index.compositeindex.datacube.startree.aggregators.ValueAggregator;
import org.graylog.shaded.opensearch2.org.opensearch.index.mapper.FieldValueConverter;
import org.graylog.shaded.opensearch2.org.opensearch.index.mapper.NumberFieldMapper;

abstract class StatelessDoubleValueAggregator
implements ValueAggregator<Double> {
    protected final FieldValueConverter fieldValueConverter;
    protected final Double identityValue;
    private static final FieldValueConverter VALUE_AGGREGATOR_TYPE = NumberFieldMapper.NumberType.DOUBLE;

    public StatelessDoubleValueAggregator(FieldValueConverter fieldValueConverter, Double identityValue) {
        this.fieldValueConverter = fieldValueConverter;
        this.identityValue = identityValue;
    }

    @Override
    public FieldValueConverter getAggregatedValueType() {
        return VALUE_AGGREGATOR_TYPE;
    }

    @Override
    public Double getInitialAggregatedValueForSegmentDocValue(Long segmentDocValue) {
        if (segmentDocValue == null) {
            return this.getIdentityMetricValue();
        }
        return this.fieldValueConverter.toDoubleValue(segmentDocValue);
    }

    @Override
    public Double mergeAggregatedValues(Double value, Double aggregatedValue) {
        if (value == null && aggregatedValue != null) {
            return aggregatedValue;
        }
        if (value != null && aggregatedValue == null) {
            return value;
        }
        if (value == null) {
            return this.getIdentityMetricValue();
        }
        return this.performValueAggregation(value, aggregatedValue);
    }

    @Override
    public Double toAggregatedValueType(Long value) {
        try {
            if (value == null) {
                return this.getIdentityMetricValue();
            }
            return VALUE_AGGREGATOR_TYPE.toDoubleValue(value);
        }
        catch (Exception e) {
            throw new IllegalStateException("Cannot convert " + value + " to sortable aggregation type", e);
        }
    }

    @Override
    public Double getIdentityMetricValue() {
        return this.identityValue;
    }

    protected abstract Double performValueAggregation(Double var1, Double var2);
}

