/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.index.compositeindex.datacube.startree.aggregators;

import org.graylog.shaded.opensearch2.org.opensearch.index.compositeindex.datacube.startree.aggregators.ValueAggregator;
import org.graylog.shaded.opensearch2.org.opensearch.index.mapper.FieldValueConverter;
import org.graylog.shaded.opensearch2.org.opensearch.index.mapper.NumberFieldMapper;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.metrics.CompensatedSum;

class SumValueAggregator
implements ValueAggregator<Double> {
    private final FieldValueConverter fieldValueConverter;
    private static final FieldValueConverter VALUE_AGGREGATOR_TYPE = NumberFieldMapper.NumberType.DOUBLE;
    private CompensatedSum kahanSummation = new CompensatedSum(0.0, 0.0);

    public SumValueAggregator(FieldValueConverter fieldValueConverter) {
        this.fieldValueConverter = fieldValueConverter;
    }

    @Override
    public FieldValueConverter getAggregatedValueType() {
        return VALUE_AGGREGATOR_TYPE;
    }

    @Override
    public Double getInitialAggregatedValueForSegmentDocValue(Long segmentDocValue) {
        this.kahanSummation.reset(0.0, 0.0);
        if (segmentDocValue != null) {
            this.kahanSummation.add(this.fieldValueConverter.toDoubleValue(segmentDocValue));
        } else {
            this.kahanSummation.add(this.getIdentityMetricValue());
        }
        return this.kahanSummation.value();
    }

    @Override
    public Double mergeAggregatedValueAndSegmentValue(Double value, Long segmentDocValue) {
        assert (value == null || this.kahanSummation.value() == value.doubleValue());
        if (segmentDocValue != null) {
            this.kahanSummation.add(this.fieldValueConverter.toDoubleValue(segmentDocValue));
        } else {
            this.kahanSummation.add(this.getIdentityMetricValue());
        }
        return this.kahanSummation.value();
    }

    @Override
    public Double mergeAggregatedValues(Double value, Double aggregatedValue) {
        assert (aggregatedValue == null || this.kahanSummation.value() == aggregatedValue.doubleValue());
        if (value != null) {
            this.kahanSummation.add(value);
        } else {
            this.kahanSummation.add(this.getIdentityMetricValue());
        }
        return this.kahanSummation.value();
    }

    @Override
    public Double getInitialAggregatedValue(Double value) {
        this.kahanSummation.reset(0.0, 0.0);
        if (value != null) {
            this.kahanSummation.add(value);
        } else {
            this.kahanSummation.add(this.getIdentityMetricValue());
        }
        return this.kahanSummation.value();
    }

    @Override
    public Double toAggregatedValueType(Long value) {
        try {
            if (value == null) {
                return this.getIdentityMetricValue();
            }
            return VALUE_AGGREGATOR_TYPE.toDoubleValue(value);
        }
        catch (Exception e) {
            throw new IllegalStateException("Cannot convert " + value + " to sortable aggregation type", e);
        }
    }

    @Override
    public Double getIdentityMetricValue() {
        return 0.0;
    }
}

