/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.index.compositeindex.datacube.startree.builder;

import java.io.Closeable;
import java.io.IOException;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.SegmentWriteState;
import org.graylog.shaded.opensearch2.org.apache.lucene.store.IndexInput;
import org.graylog.shaded.opensearch2.org.apache.lucene.store.IndexOutput;
import org.graylog.shaded.opensearch2.org.apache.lucene.store.RandomAccessInput;
import org.graylog.shaded.opensearch2.org.opensearch.common.annotation.ExperimentalApi;
import org.graylog.shaded.opensearch2.org.opensearch.common.util.io.IOUtils;
import org.graylog.shaded.opensearch2.org.opensearch.index.compositeindex.datacube.startree.StarTreeDocument;
import org.graylog.shaded.opensearch2.org.opensearch.index.compositeindex.datacube.startree.StarTreeField;
import org.graylog.shaded.opensearch2.org.opensearch.index.compositeindex.datacube.startree.aggregators.MetricAggregatorInfo;
import org.graylog.shaded.opensearch2.org.opensearch.index.compositeindex.datacube.startree.builder.AbstractDocumentsFileManager;

@ExperimentalApi
public class SegmentDocsFileManager
extends AbstractDocumentsFileManager
implements Closeable {
    private static final Logger logger = LogManager.getLogger(SegmentDocsFileManager.class);
    private static final String SEGMENT_DOC_FILE_NAME = "segment.documents";
    private IndexInput segmentDocsFileInput;
    private RandomAccessInput segmentRandomInput;
    final IndexOutput segmentDocsFileOutput;

    public SegmentDocsFileManager(SegmentWriteState state, StarTreeField starTreeField, List<MetricAggregatorInfo> metricAggregatorInfos, int numDimensions) throws IOException {
        super(state, starTreeField, metricAggregatorInfos, numDimensions);
        try {
            this.segmentDocsFileOutput = this.tmpDirectory.createTempOutput(SEGMENT_DOC_FILE_NAME, state.segmentSuffix, state.context);
        }
        catch (IOException e) {
            IOUtils.closeWhileHandlingException((Closeable)this);
            throw e;
        }
    }

    @Override
    public void writeStarTreeDocument(StarTreeDocument starTreeDocument, boolean isAggregatedDoc) throws IOException {
        this.writeStarTreeDocument(starTreeDocument, this.segmentDocsFileOutput, isAggregatedDoc);
    }

    private void maybeInitializeSegmentInput() throws IOException {
        try {
            if (this.segmentDocsFileInput == null) {
                IOUtils.closeWhileHandlingException((Closeable)this.segmentDocsFileOutput);
                this.segmentDocsFileInput = this.tmpDirectory.openInput(this.segmentDocsFileOutput.getName(), this.state.context);
                this.segmentRandomInput = this.segmentDocsFileInput.randomAccessSlice(0L, this.segmentDocsFileInput.length());
            }
        }
        catch (IOException e) {
            IOUtils.closeWhileHandlingException((Closeable)this);
            throw e;
        }
    }

    @Override
    public StarTreeDocument readStarTreeDocument(int docId, boolean isAggregatedDoc) throws IOException {
        this.maybeInitializeSegmentInput();
        return this.readStarTreeDocument(this.segmentRandomInput, (long)docId * (long)this.docSizeInBytes, isAggregatedDoc);
    }

    @Override
    public Long[] readDimensions(int docId) throws IOException {
        this.maybeInitializeSegmentInput();
        Long[] dims = new Long[this.numDimensions];
        this.readDimensions(dims, this.segmentRandomInput, (long)docId * (long)this.docSizeInBytes);
        return dims;
    }

    @Override
    public Long getDimensionValue(int docId, int dimensionId) throws IOException {
        Long[] dims = this.readDimensions(docId);
        return dims[dimensionId];
    }

    @Override
    public void close() throws IOException {
        try {
            if (this.segmentDocsFileOutput != null) {
                IOUtils.closeWhileHandlingException((Closeable)this.segmentDocsFileOutput);
                this.tmpDirectory.deleteFile(this.segmentDocsFileOutput.getName());
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeWhileHandlingException(this.segmentDocsFileInput, this.segmentDocsFileOutput);
            throw throwable;
        }
        IOUtils.closeWhileHandlingException(this.segmentDocsFileInput, this.segmentDocsFileOutput);
    }
}

