/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.index.compositeindex.datacube.startree.builder;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.graylog.shaded.opensearch2.org.apache.lucene.codecs.DocValuesConsumer;
import org.graylog.shaded.opensearch2.org.apache.lucene.codecs.DocValuesProducer;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.SegmentWriteState;
import org.graylog.shaded.opensearch2.org.apache.lucene.store.IndexOutput;
import org.graylog.shaded.opensearch2.org.opensearch.common.annotation.ExperimentalApi;
import org.graylog.shaded.opensearch2.org.opensearch.index.compositeindex.datacube.startree.StarTreeField;
import org.graylog.shaded.opensearch2.org.opensearch.index.compositeindex.datacube.startree.builder.OffHeapStarTreeBuilder;
import org.graylog.shaded.opensearch2.org.opensearch.index.compositeindex.datacube.startree.builder.OnHeapStarTreeBuilder;
import org.graylog.shaded.opensearch2.org.opensearch.index.compositeindex.datacube.startree.builder.StarTreeBuilder;
import org.graylog.shaded.opensearch2.org.opensearch.index.compositeindex.datacube.startree.index.StarTreeValues;
import org.graylog.shaded.opensearch2.org.opensearch.index.mapper.CompositeMappedFieldType;
import org.graylog.shaded.opensearch2.org.opensearch.index.mapper.MapperService;
import org.graylog.shaded.opensearch2.org.opensearch.index.mapper.StarTreeMapper;

@ExperimentalApi
public class StarTreesBuilder
implements Closeable {
    private static final Logger logger = LogManager.getLogger(StarTreesBuilder.class);
    private final List<StarTreeField> starTreeFields;
    private final SegmentWriteState state;
    private final MapperService mapperService;
    private AtomicInteger fieldNumberAcrossStarTrees;

    public StarTreesBuilder(SegmentWriteState segmentWriteState, MapperService mapperService, AtomicInteger fieldNumberAcrossStarTrees) {
        ArrayList<StarTreeField> starTreeFields = new ArrayList<StarTreeField>();
        for (CompositeMappedFieldType compositeMappedFieldType : mapperService.getCompositeFieldTypes()) {
            if (!(compositeMappedFieldType instanceof StarTreeMapper.StarTreeFieldType)) continue;
            StarTreeMapper.StarTreeFieldType starTreeFieldType = (StarTreeMapper.StarTreeFieldType)compositeMappedFieldType;
            starTreeFields.add(new StarTreeField(starTreeFieldType.name(), starTreeFieldType.getDimensions(), starTreeFieldType.getMetrics(), starTreeFieldType.getStarTreeConfig()));
        }
        this.starTreeFields = starTreeFields;
        this.state = segmentWriteState;
        this.mapperService = mapperService;
        this.fieldNumberAcrossStarTrees = fieldNumberAcrossStarTrees;
    }

    public void build(IndexOutput metaOut, IndexOutput dataOut, Map<String, DocValuesProducer> fieldProducerMap, DocValuesConsumer starTreeDocValuesConsumer) throws IOException {
        if (this.starTreeFields.isEmpty()) {
            logger.debug("no star-tree fields found, returning from star-tree builder");
            return;
        }
        long startTime = System.currentTimeMillis();
        int numStarTrees = this.starTreeFields.size();
        logger.debug("Starting building {} star-trees with star-tree fields", (Object)numStarTrees);
        for (StarTreeField starTreeField : this.starTreeFields) {
            StarTreeBuilder starTreeBuilder = this.getStarTreeBuilder(metaOut, dataOut, starTreeField, this.state, this.mapperService);
            try {
                starTreeBuilder.build(fieldProducerMap, this.fieldNumberAcrossStarTrees, starTreeDocValuesConsumer);
            }
            finally {
                if (starTreeBuilder == null) continue;
                starTreeBuilder.close();
            }
        }
        logger.debug("Took {} ms to build {} star-trees with star-tree fields", (Object)(System.currentTimeMillis() - startTime), (Object)numStarTrees);
    }

    @Override
    public void close() throws IOException {
    }

    public void buildDuringMerge(IndexOutput metaOut, IndexOutput dataOut, Map<String, List<StarTreeValues>> starTreeValuesSubsPerField, DocValuesConsumer starTreeDocValuesConsumer) throws IOException {
        logger.debug("Starting merge of {} star-trees with star-tree fields", (Object)starTreeValuesSubsPerField.size());
        long startTime = System.currentTimeMillis();
        for (Map.Entry<String, List<StarTreeValues>> entry : starTreeValuesSubsPerField.entrySet()) {
            List<StarTreeValues> starTreeValuesList = entry.getValue();
            if (starTreeValuesList.isEmpty()) {
                logger.debug("StarTreeValues is empty for all segments for field : {}", (Object)entry.getKey());
                continue;
            }
            StarTreeField starTreeField = starTreeValuesList.get(0).getStarTreeField();
            StarTreeBuilder builder = this.getStarTreeBuilder(metaOut, dataOut, starTreeField, this.state, this.mapperService);
            try {
                builder.build(starTreeValuesList, this.fieldNumberAcrossStarTrees, starTreeDocValuesConsumer);
            }
            finally {
                if (builder == null) continue;
                builder.close();
            }
        }
        logger.debug("Took {} ms to merge {} star-trees with star-tree fields", (Object)(System.currentTimeMillis() - startTime), (Object)starTreeValuesSubsPerField.size());
    }

    StarTreeBuilder getStarTreeBuilder(IndexOutput metaOut, IndexOutput dataOut, StarTreeField starTreeField, SegmentWriteState state, MapperService mapperService) throws IOException {
        switch (starTreeField.getStarTreeConfig().getBuildMode()) {
            case ON_HEAP: {
                return new OnHeapStarTreeBuilder(metaOut, dataOut, starTreeField, state, mapperService);
            }
            case OFF_HEAP: {
                return new OffHeapStarTreeBuilder(metaOut, dataOut, starTreeField, state, mapperService);
            }
        }
        throw new IllegalArgumentException(String.format(Locale.ROOT, "No star tree implementation is available for [%s] build mode", new Object[]{starTreeField.getStarTreeConfig().getBuildMode()}));
    }
}

