/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.index.compositeindex.datacube.startree.fileformats.meta;

import java.io.IOException;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.DocValuesType;
import org.graylog.shaded.opensearch2.org.apache.lucene.store.IndexOutput;
import org.graylog.shaded.opensearch2.org.opensearch.index.compositeindex.datacube.Dimension;
import org.graylog.shaded.opensearch2.org.opensearch.index.compositeindex.datacube.DimensionDataType;
import org.graylog.shaded.opensearch2.org.opensearch.index.compositeindex.datacube.startree.StarTreeField;
import org.graylog.shaded.opensearch2.org.opensearch.index.compositeindex.datacube.startree.aggregators.MetricAggregatorInfo;
import org.graylog.shaded.opensearch2.org.opensearch.index.mapper.CompositeMappedFieldType;

public class StarTreeMetadataWriter {
    private static final Logger logger = LogManager.getLogger(StarTreeMetadataWriter.class);

    public static void writeStarTreeMetadata(IndexOutput metaOut, StarTreeField starTreeField, List<MetricAggregatorInfo> metricAggregatorInfos, Integer numNodes, Integer segmentAggregatedCount, Integer numStarTreeDocs, long dataFilePointer, long dataFileLength) throws IOException {
        long initialMetaFilePointer = metaOut.getFilePointer();
        StarTreeMetadataWriter.writeMetaHeader(metaOut);
        StarTreeMetadataWriter.writeMeta(metaOut, metricAggregatorInfos, starTreeField, numNodes, segmentAggregatedCount, numStarTreeDocs, dataFilePointer, dataFileLength);
        logger.debug("Star tree meta size in bytes : {} for star-tree field {}", (Object)(metaOut.getFilePointer() - initialMetaFilePointer), (Object)starTreeField.getName());
    }

    private static void writeMetaHeader(IndexOutput metaOut) throws IOException {
        metaOut.writeLong(3387940285652509L);
        metaOut.writeVInt(1);
    }

    private static void writeMeta(IndexOutput metaOut, List<MetricAggregatorInfo> metricAggregatorInfos, StarTreeField starTreeField, int numNodes, Integer segmentAggregatedDocCount, Integer numStarTreeDocs, long dataFilePointer, long dataFileLength) throws IOException {
        metaOut.writeString(starTreeField.getName());
        metaOut.writeString(CompositeMappedFieldType.CompositeFieldType.STAR_TREE.getName());
        metaOut.writeVInt(numNodes);
        metaOut.writeVInt(starTreeField.getDimensionNames().size());
        List<Dimension> dimensionsOrder = starTreeField.getDimensionsOrder();
        int docDimensionIndex = 0;
        for (Dimension currentDimension : dimensionsOrder) {
            int numSubDimensions = currentDimension.getNumSubDimensions();
            while (numSubDimensions > 0) {
                metaOut.writeString(starTreeField.getDimensionNames().get(docDimensionIndex));
                metaOut.writeByte(StarTreeMetadataWriter.docValuesByte(starTreeField.getDimensionDocValueTypes().get(docDimensionIndex)));
                metaOut.writeByte(StarTreeMetadataWriter.dimensionDataTypeByte(currentDimension.getDimensionDataType()));
                --numSubDimensions;
                ++docDimensionIndex;
            }
        }
        metaOut.writeVInt(metricAggregatorInfos.size());
        for (MetricAggregatorInfo metricAggregatorInfo : metricAggregatorInfos) {
            metaOut.writeString(metricAggregatorInfo.getField());
            int metricStatOrdinal = metricAggregatorInfo.getMetricStat().getMetricOrdinal();
            metaOut.writeVInt(metricStatOrdinal);
        }
        metaOut.writeVInt(segmentAggregatedDocCount);
        metaOut.writeVInt(numStarTreeDocs);
        metaOut.writeVInt(starTreeField.getStarTreeConfig().maxLeafDocs());
        metaOut.writeVInt(starTreeField.getStarTreeConfig().getSkipStarNodeCreationInDims().size());
        for (String dimension : starTreeField.getStarTreeConfig().getSkipStarNodeCreationInDims()) {
            metaOut.writeString(dimension);
        }
        metaOut.writeByte(starTreeField.getStarTreeConfig().getBuildMode().getBuildModeOrdinal());
        metaOut.writeVLong(dataFilePointer);
        metaOut.writeVLong(dataFileLength);
    }

    private static byte dimensionDataTypeByte(DimensionDataType dimensionDataType) {
        switch (dimensionDataType) {
            case LONG: {
                return 0;
            }
            case UNSIGNED_LONG: {
                return 1;
            }
        }
        throw new AssertionError((Object)("unhandled dimensionDataType: " + String.valueOf((Object)dimensionDataType)));
    }

    private static byte docValuesByte(DocValuesType type) {
        switch (type) {
            case NONE: {
                return 0;
            }
            case NUMERIC: {
                return 1;
            }
            case BINARY: {
                return 2;
            }
            case SORTED: {
                return 3;
            }
            case SORTED_SET: {
                return 4;
            }
            case SORTED_NUMERIC: {
                return 5;
            }
        }
        throw new AssertionError((Object)("unhandled DocValuesType: " + String.valueOf((Object)type)));
    }
}

