/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.index.compositeindex.datacube.startree.node;

import java.util.LinkedHashMap;
import java.util.Map;
import org.graylog.shaded.opensearch2.org.opensearch.common.SetOnce;
import org.graylog.shaded.opensearch2.org.opensearch.common.annotation.ExperimentalApi;
import org.graylog.shaded.opensearch2.org.opensearch.index.compositeindex.datacube.startree.node.StarTreeNodeType;

@ExperimentalApi
public class InMemoryTreeNode {
    private final int dimensionId;
    private final int startDocId;
    private final int endDocId;
    private int aggregatedDocId = -1;
    private int childDimensionId = -1;
    private final long dimensionValue;
    private byte nodeType;
    private final Map<Long, InMemoryTreeNode> children;
    private final SetOnce<InMemoryTreeNode> childStarNode;

    public InMemoryTreeNode() {
        this.dimensionId = -1;
        this.startDocId = -1;
        this.endDocId = -1;
        this.nodeType = 0;
        this.dimensionValue = -1L;
        this.childStarNode = new SetOnce();
        this.children = new LinkedHashMap<Long, InMemoryTreeNode>();
    }

    public InMemoryTreeNode(int dimensionId, int startDocId, int endDocId, byte nodeType, long dimensionValue) {
        this.dimensionId = dimensionId;
        this.startDocId = startDocId;
        this.endDocId = endDocId;
        this.nodeType = nodeType;
        this.dimensionValue = dimensionValue;
        this.childStarNode = new SetOnce();
        this.children = new LinkedHashMap<Long, InMemoryTreeNode>();
    }

    public long getDimensionValue() {
        return this.dimensionValue;
    }

    public byte getNodeType() {
        return this.nodeType;
    }

    public boolean hasChild() {
        return !this.children.isEmpty() || this.childStarNode.get() != null;
    }

    public int getDimensionId() {
        return this.dimensionId;
    }

    public int getStartDocId() {
        return this.startDocId;
    }

    public int getEndDocId() {
        return this.endDocId;
    }

    public void setNodeType(byte nodeType) {
        this.nodeType = nodeType;
    }

    public void addChildNode(InMemoryTreeNode childNode, Long dimensionValue) {
        if (childNode.getNodeType() == StarTreeNodeType.STAR.getValue()) {
            this.childStarNode.set(childNode);
        } else {
            this.children.put(dimensionValue, childNode);
            assert (this.assertStarTreeChildOrder(childNode));
        }
    }

    public Map<Long, InMemoryTreeNode> getChildren() {
        return this.children;
    }

    public InMemoryTreeNode getChildStarNode() {
        return this.childStarNode.get();
    }

    public int getChildDimensionId() {
        return this.childDimensionId;
    }

    public void setChildDimensionId(int childDimensionId) {
        this.childDimensionId = childDimensionId;
    }

    public int getAggregatedDocId() {
        return this.aggregatedDocId;
    }

    public void setAggregatedDocId(int aggregatedDocId) {
        this.aggregatedDocId = aggregatedDocId;
    }

    private boolean assertStarTreeChildOrder(InMemoryTreeNode childNode) {
        if (childNode.nodeType != StarTreeNodeType.NULL.getValue() && !this.children.isEmpty()) {
            InMemoryTreeNode lastNode = null;
            for (Map.Entry<Long, InMemoryTreeNode> entry : this.children.entrySet()) {
                lastNode = entry.getValue();
            }
            assert (lastNode.dimensionValue <= childNode.dimensionValue);
        } else if (childNode.nodeType == StarTreeNodeType.NULL.getValue() && !this.children.isEmpty()) {
            InMemoryTreeNode lastNode = null;
            for (Map.Entry<Long, InMemoryTreeNode> entry : this.children.entrySet()) {
                lastNode = entry.getValue();
            }
            assert (lastNode.nodeType == StarTreeNodeType.NULL.getValue());
        }
        return true;
    }
}

