/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.index.compositeindex.datacube.startree.utils;

import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.function.IntFunction;
import org.graylog.shaded.opensearch2.org.apache.lucene.util.IntroSorter;

public class StarTreeDocumentsSorter {
    public static void sort(final int[] sortedDocIds, final int dimensionId, int numDocs, final IntFunction<Long[]> dimensionsReader, final List<Comparator<Long>> dimensionComparators) {
        new IntroSorter(){
            private Long[] dimensions;

            @Override
            protected void swap(int i, int j) {
                int temp = sortedDocIds[i];
                sortedDocIds[i] = sortedDocIds[j];
                sortedDocIds[j] = temp;
            }

            @Override
            protected void setPivot(int i) {
                this.dimensions = (Long[])dimensionsReader.apply(i);
            }

            @Override
            protected int comparePivot(int j) {
                Long[] currentDimensions = (Long[])dimensionsReader.apply(j);
                for (int i = dimensionId + 1; i < this.dimensions.length; ++i) {
                    if (Objects.equals(this.dimensions[i], currentDimensions[i])) continue;
                    return ((Comparator)dimensionComparators.get(i)).compare(this.dimensions[i], currentDimensions[i]);
                }
                return 0;
            }
        }.sort(0, numDocs);
    }
}

