/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.index.compositeindex.datacube.startree.utils;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.DocValuesType;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.FieldInfo;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.IndexOptions;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.VectorEncoding;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.VectorSimilarityFunction;
import org.graylog.shaded.opensearch2.org.opensearch.index.compositeindex.datacube.startree.aggregators.MetricAggregatorInfo;

public class StarTreeUtils {
    public static final int ALL = -1;
    public static final String DIMENSION_SUFFIX = "dim";
    public static final String METRIC_SUFFIX = "metric";

    private StarTreeUtils() {
    }

    public static String fullyQualifiedFieldNameForStarTreeDimensionsDocValues(String starTreeFieldName, String dimensionName) {
        return starTreeFieldName + "_" + dimensionName + "_dim";
    }

    public static String fullyQualifiedFieldNameForStarTreeMetricsDocValues(String starTreeFieldName, String fieldName, String metricName) {
        return MetricAggregatorInfo.toFieldName(starTreeFieldName, fieldName, metricName) + "_metric";
    }

    public static FieldInfo[] getFieldInfoList(List<String> fields, Map<String, DocValuesType> dimDocValuesTypeMap) {
        FieldInfo[] fieldInfoList = new FieldInfo[fields.size()];
        int fieldNumber = 0;
        for (String fieldName : fields) {
            fieldInfoList[fieldNumber] = StarTreeUtils.getFieldInfo(fieldName, dimDocValuesTypeMap.getOrDefault(fieldName, DocValuesType.SORTED_NUMERIC), fieldNumber);
            ++fieldNumber;
        }
        return fieldInfoList;
    }

    public static FieldInfo getFieldInfo(String fieldName, DocValuesType docValuesType, int fieldNumber) {
        return new FieldInfo(fieldName, fieldNumber, false, false, true, IndexOptions.DOCS_AND_FREQS_AND_POSITIONS_AND_OFFSETS, docValuesType, -1L, Collections.emptyMap(), 0, 0, 0, 0, VectorEncoding.FLOAT32, VectorSimilarityFunction.EUCLIDEAN, false, false);
    }

    public static FieldInfo getFieldInfo(String fieldName, DocValuesType docValuesType) {
        return new FieldInfo(fieldName, 0, false, false, true, IndexOptions.DOCS_AND_FREQS_AND_POSITIONS_AND_OFFSETS, docValuesType, -1L, Collections.emptyMap(), 0, 0, 0, 0, VectorEncoding.FLOAT32, VectorSimilarityFunction.EUCLIDEAN, false, false);
    }
}

