/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.index.engine;

import java.io.IOException;
import java.util.Arrays;
import java.util.Objects;
import java.util.function.Supplier;
import org.graylog.shaded.opensearch2.org.apache.lucene.codecs.DocValuesProducer;
import org.graylog.shaded.opensearch2.org.apache.lucene.codecs.StoredFieldsReader;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.BinaryDocValues;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.CodecReader;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.FieldInfo;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.FilterCodecReader;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.FilterNumericDocValues;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.IndexReader;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.MergePolicy;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.NumericDocValues;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.OneMergeWrappingMergePolicy;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.SortedDocValues;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.SortedNumericDocValues;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.SortedSetDocValues;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.StoredFieldVisitor;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.ConjunctionUtils;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.DocIdSetIterator;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.IndexSearcher;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.Query;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.ScoreMode;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.Scorer;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.Weight;
import org.graylog.shaded.opensearch2.org.apache.lucene.util.BitSet;
import org.graylog.shaded.opensearch2.org.apache.lucene.util.BitSetIterator;

final class RecoverySourcePruneMergePolicy
extends OneMergeWrappingMergePolicy {
    RecoverySourcePruneMergePolicy(String recoverySourceField, Supplier<Query> retainSourceQuerySupplier, MergePolicy in) {
        super(in, toWrap -> new MergePolicy.OneMerge(toWrap.segments, (MergePolicy.OneMerge)toWrap, recoverySourceField, retainSourceQuerySupplier){
            final /* synthetic */ MergePolicy.OneMerge val$toWrap;
            final /* synthetic */ String val$recoverySourceField;
            final /* synthetic */ Supplier val$retainSourceQuerySupplier;
            {
                this.val$toWrap = oneMerge;
                this.val$recoverySourceField = string;
                this.val$retainSourceQuerySupplier = supplier;
                super(segments);
            }

            @Override
            public CodecReader wrapForMerge(CodecReader reader) throws IOException {
                CodecReader wrapped = this.val$toWrap.wrapForMerge(reader);
                return RecoverySourcePruneMergePolicy.wrapReader(this.val$recoverySourceField, wrapped, this.val$retainSourceQuerySupplier);
            }
        });
    }

    private static CodecReader wrapReader(String recoverySourceField, CodecReader reader, Supplier<Query> retainSourceQuerySupplier) throws IOException {
        NumericDocValues recoverySource = reader.getNumericDocValues(recoverySourceField);
        if (recoverySource == null || recoverySource.nextDoc() == Integer.MAX_VALUE) {
            return reader;
        }
        IndexSearcher s = new IndexSearcher(reader);
        s.setQueryCache(null);
        Weight weight = s.createWeight(s.rewrite(retainSourceQuerySupplier.get()), ScoreMode.COMPLETE_NO_SCORES, 1.0f);
        Scorer scorer = weight.scorer(reader.getContext());
        if (scorer != null) {
            BitSet recoverySourceToKeep = BitSet.of(scorer.iterator(), reader.maxDoc());
            if (recoverySourceToKeep.cardinality() == reader.maxDoc()) {
                return reader;
            }
            return new SourcePruningFilterCodecReader(recoverySourceField, reader, recoverySourceToKeep);
        }
        return new SourcePruningFilterCodecReader(recoverySourceField, reader, null);
    }

    private static class SourcePruningFilterCodecReader
    extends FilterCodecReader {
        private final BitSet recoverySourceToKeep;
        private final String recoverySourceField;

        SourcePruningFilterCodecReader(String recoverySourceField, CodecReader reader, BitSet recoverySourceToKeep) {
            super(reader);
            this.recoverySourceField = recoverySourceField;
            this.recoverySourceToKeep = recoverySourceToKeep;
        }

        @Override
        public DocValuesProducer getDocValuesReader() {
            DocValuesProducer docValuesReader = super.getDocValuesReader();
            return new FilterDocValuesProducer(docValuesReader){

                @Override
                public NumericDocValues getNumeric(FieldInfo field) throws IOException {
                    NumericDocValues numeric = super.getNumeric(field);
                    if (recoverySourceField.equals(field.name)) {
                        assert (numeric != null) : recoverySourceField + " must have numeric DV but was null";
                        final DocIdSetIterator intersection = recoverySourceToKeep == null ? DocIdSetIterator.empty() : ConjunctionUtils.intersectIterators(Arrays.asList(numeric, new BitSetIterator(recoverySourceToKeep, recoverySourceToKeep.length())));
                        return new FilterNumericDocValues(numeric){

                            @Override
                            public int nextDoc() throws IOException {
                                return intersection.nextDoc();
                            }

                            @Override
                            public int advance(int target) {
                                throw new UnsupportedOperationException();
                            }

                            @Override
                            public boolean advanceExact(int target) {
                                throw new UnsupportedOperationException();
                            }
                        };
                    }
                    return numeric;
                }
            };
        }

        @Override
        public StoredFieldsReader getFieldsReader() {
            return new RecoverySourcePruningStoredFieldsReader(super.getFieldsReader(), this.recoverySourceToKeep, this.recoverySourceField);
        }

        @Override
        public IndexReader.CacheHelper getCoreCacheHelper() {
            return null;
        }

        @Override
        public IndexReader.CacheHelper getReaderCacheHelper() {
            return null;
        }

        private static class RecoverySourcePruningStoredFieldsReader
        extends FilterStoredFieldsReader {
            private final BitSet recoverySourceToKeep;
            private final String recoverySourceField;

            RecoverySourcePruningStoredFieldsReader(StoredFieldsReader in, BitSet recoverySourceToKeep, String recoverySourceField) {
                super(in);
                this.recoverySourceToKeep = recoverySourceToKeep;
                this.recoverySourceField = Objects.requireNonNull(recoverySourceField);
            }

            @Override
            public void document(int docID, StoredFieldVisitor visitor) throws IOException {
                if (this.recoverySourceToKeep != null && this.recoverySourceToKeep.get(docID)) {
                    super.document(docID, visitor);
                } else {
                    super.document(docID, new FilterStoredFieldVisitor(visitor){

                        @Override
                        public StoredFieldVisitor.Status needsField(FieldInfo fieldInfo) throws IOException {
                            if (recoverySourceField.equals(fieldInfo.name)) {
                                return StoredFieldVisitor.Status.NO;
                            }
                            return super.needsField(fieldInfo);
                        }
                    });
                }
            }

            @Override
            public StoredFieldsReader getMergeInstance() {
                return new RecoverySourcePruningStoredFieldsReader(this.in.getMergeInstance(), this.recoverySourceToKeep, this.recoverySourceField);
            }

            @Override
            public StoredFieldsReader clone() {
                return new RecoverySourcePruningStoredFieldsReader(this.in.clone(), this.recoverySourceToKeep, this.recoverySourceField);
            }
        }

        private static class FilterStoredFieldVisitor
        extends StoredFieldVisitor {
            private final StoredFieldVisitor visitor;

            FilterStoredFieldVisitor(StoredFieldVisitor visitor) {
                this.visitor = visitor;
            }

            @Override
            public void binaryField(FieldInfo fieldInfo, byte[] value) throws IOException {
                this.visitor.binaryField(fieldInfo, value);
            }

            @Override
            public void stringField(FieldInfo fieldInfo, String value) throws IOException {
                this.visitor.stringField(fieldInfo, value);
            }

            @Override
            public void intField(FieldInfo fieldInfo, int value) throws IOException {
                this.visitor.intField(fieldInfo, value);
            }

            @Override
            public void longField(FieldInfo fieldInfo, long value) throws IOException {
                this.visitor.longField(fieldInfo, value);
            }

            @Override
            public void floatField(FieldInfo fieldInfo, float value) throws IOException {
                this.visitor.floatField(fieldInfo, value);
            }

            @Override
            public void doubleField(FieldInfo fieldInfo, double value) throws IOException {
                this.visitor.doubleField(fieldInfo, value);
            }

            @Override
            public StoredFieldVisitor.Status needsField(FieldInfo fieldInfo) throws IOException {
                return this.visitor.needsField(fieldInfo);
            }
        }

        private static abstract class FilterStoredFieldsReader
        extends StoredFieldsReader {
            protected final StoredFieldsReader in;

            FilterStoredFieldsReader(StoredFieldsReader fieldsReader) {
                this.in = fieldsReader;
            }

            @Override
            public void close() throws IOException {
                this.in.close();
            }

            @Override
            public void document(int docID, StoredFieldVisitor visitor) throws IOException {
                this.in.document(docID, visitor);
            }

            @Override
            public abstract StoredFieldsReader clone();

            @Override
            public void checkIntegrity() throws IOException {
                this.in.checkIntegrity();
            }
        }

        private static class FilterDocValuesProducer
        extends DocValuesProducer {
            private final DocValuesProducer in;

            FilterDocValuesProducer(DocValuesProducer in) {
                this.in = in;
            }

            @Override
            public NumericDocValues getNumeric(FieldInfo field) throws IOException {
                return this.in.getNumeric(field);
            }

            @Override
            public BinaryDocValues getBinary(FieldInfo field) throws IOException {
                return this.in.getBinary(field);
            }

            @Override
            public SortedDocValues getSorted(FieldInfo field) throws IOException {
                return this.in.getSorted(field);
            }

            @Override
            public SortedNumericDocValues getSortedNumeric(FieldInfo field) throws IOException {
                return this.in.getSortedNumeric(field);
            }

            @Override
            public SortedSetDocValues getSortedSet(FieldInfo field) throws IOException {
                return this.in.getSortedSet(field);
            }

            @Override
            public void checkIntegrity() throws IOException {
                this.in.checkIntegrity();
            }

            @Override
            public void close() throws IOException {
                this.in.close();
            }
        }
    }
}

