/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.index.fielddata;

import java.util.Arrays;
import org.graylog.shaded.opensearch2.org.apache.lucene.util.ArrayUtil;
import org.graylog.shaded.opensearch2.org.apache.lucene.util.BytesRef;
import org.graylog.shaded.opensearch2.org.apache.lucene.util.BytesRefBuilder;
import org.graylog.shaded.opensearch2.org.apache.lucene.util.InPlaceMergeSorter;
import org.graylog.shaded.opensearch2.org.apache.lucene.util.RamUsageEstimator;
import org.graylog.shaded.opensearch2.org.apache.lucene.util.Sorter;
import org.graylog.shaded.opensearch2.org.opensearch.index.fielddata.SortedBinaryDocValues;

public abstract class SortingBinaryDocValues
extends SortedBinaryDocValues {
    private int index;
    protected int count;
    protected BytesRefBuilder[] values = new BytesRefBuilder[]{new BytesRefBuilder()};
    private final Sorter sorter = new InPlaceMergeSorter(){

        @Override
        protected void swap(int i, int j) {
            ArrayUtil.swap(SortingBinaryDocValues.this.values, i, j);
        }

        @Override
        protected int compare(int i, int j) {
            return SortingBinaryDocValues.this.values[i].get().compareTo(SortingBinaryDocValues.this.values[j].get());
        }
    };

    protected SortingBinaryDocValues() {
    }

    protected final void grow() {
        if (this.values.length < this.count) {
            int oldLen = this.values.length;
            int newLen = ArrayUtil.oversize(this.count, RamUsageEstimator.NUM_BYTES_OBJECT_REF);
            this.values = Arrays.copyOf(this.values, newLen);
            for (int i = oldLen; i < newLen; ++i) {
                this.values[i] = new BytesRefBuilder();
            }
        }
    }

    protected final void sort() {
        this.sorter.sort(0, this.count);
        this.index = 0;
    }

    @Override
    public int docValueCount() {
        return this.count;
    }

    @Override
    public final BytesRef nextValue() {
        assert (this.index < this.count);
        return this.values[this.index++].get();
    }
}

