/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.index.fielddata.fieldcomparator;

import java.io.IOException;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.LeafReaderContext;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.NumericDocValues;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.DocIdSetIterator;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.FieldComparator;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.LeafFieldComparator;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.Pruning;
import org.graylog.shaded.opensearch2.org.apache.lucene.util.BitSet;
import org.graylog.shaded.opensearch2.org.opensearch.index.fielddata.FieldData;
import org.graylog.shaded.opensearch2.org.opensearch.index.fielddata.IndexFieldData;
import org.graylog.shaded.opensearch2.org.opensearch.index.fielddata.IndexNumericFieldData;
import org.graylog.shaded.opensearch2.org.opensearch.index.fielddata.LeafNumericFieldData;
import org.graylog.shaded.opensearch2.org.opensearch.index.fielddata.NumericDoubleValues;
import org.graylog.shaded.opensearch2.org.opensearch.index.fielddata.SortedNumericDoubleValues;
import org.graylog.shaded.opensearch2.org.opensearch.index.fielddata.fieldcomparator.FloatValuesComparatorSource;
import org.graylog.shaded.opensearch2.org.opensearch.index.search.comparators.HalfFloatComparator;
import org.graylog.shaded.opensearch2.org.opensearch.search.MultiValueMode;

public class HalfFloatValuesComparatorSource
extends FloatValuesComparatorSource {
    private final IndexNumericFieldData indexFieldData;

    public HalfFloatValuesComparatorSource(IndexNumericFieldData indexFieldData, Object missingValue, MultiValueMode sortMode, IndexFieldData.XFieldComparatorSource.Nested nested) {
        super(indexFieldData, missingValue, sortMode, nested);
        this.indexFieldData = indexFieldData;
    }

    @Override
    public FieldComparator<?> newComparator(String fieldname, int numHits, Pruning pruning, boolean reversed) {
        assert (this.indexFieldData == null || fieldname.equals(this.indexFieldData.getFieldName()));
        final float fMissingValue = ((Float)this.missingObject(this.missingValue, reversed)).floatValue();
        return new HalfFloatComparator(numHits, fieldname, Float.valueOf(fMissingValue), reversed, this.filterPruning(pruning)){

            @Override
            public LeafFieldComparator getLeafComparator(LeafReaderContext context) throws IOException {
                return new HalfFloatComparator.HalfFloatLeafComparator(context){

                    @Override
                    protected NumericDocValues getNumericDocValues(LeafReaderContext context, String field) throws IOException {
                        return HalfFloatValuesComparatorSource.this.getNumericDocValues(context, fMissingValue).getRawFloatValues();
                    }
                };
            }
        };
    }

    private NumericDoubleValues getNumericDocValues(LeafReaderContext context, float missingValue) throws IOException {
        SortedNumericDoubleValues values = ((LeafNumericFieldData)this.indexFieldData.load(context)).getDoubleValues();
        if (this.nested == null) {
            return FieldData.replaceMissing(this.sortMode.select(values), missingValue);
        }
        BitSet rootDocs = this.nested.rootDocs(context);
        DocIdSetIterator innerDocs = this.nested.innerDocs(context);
        int maxChildren = this.nested.getNestedSort() != null ? this.nested.getNestedSort().getMaxChildren() : Integer.MAX_VALUE;
        return this.sortMode.select(values, missingValue, rootDocs, innerDocs, context.reader().maxDoc(), maxChildren);
    }
}

