/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.index.fielddata.fieldcomparator;

import java.io.IOException;
import java.util.function.Function;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.LeafReaderContext;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.NumericDocValues;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.SortedNumericDocValues;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.DocIdSetIterator;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.FieldComparator;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.LeafFieldComparator;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.Pruning;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.SortField;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.comparators.LongComparator;
import org.graylog.shaded.opensearch2.org.apache.lucene.util.BitSet;
import org.graylog.shaded.opensearch2.org.opensearch.common.Nullable;
import org.graylog.shaded.opensearch2.org.opensearch.common.util.BigArrays;
import org.graylog.shaded.opensearch2.org.opensearch.index.fielddata.FieldData;
import org.graylog.shaded.opensearch2.org.opensearch.index.fielddata.IndexFieldData;
import org.graylog.shaded.opensearch2.org.opensearch.index.fielddata.IndexNumericFieldData;
import org.graylog.shaded.opensearch2.org.opensearch.index.fielddata.LeafNumericFieldData;
import org.graylog.shaded.opensearch2.org.opensearch.index.fielddata.plain.SortedNumericIndexFieldData;
import org.graylog.shaded.opensearch2.org.opensearch.search.DocValueFormat;
import org.graylog.shaded.opensearch2.org.opensearch.search.MultiValueMode;
import org.graylog.shaded.opensearch2.org.opensearch.search.sort.BucketedSort;
import org.graylog.shaded.opensearch2.org.opensearch.search.sort.SortOrder;

public class LongValuesComparatorSource
extends IndexFieldData.XFieldComparatorSource {
    private final IndexNumericFieldData indexFieldData;
    private final Function<SortedNumericDocValues, SortedNumericDocValues> converter;

    public LongValuesComparatorSource(IndexNumericFieldData indexFieldData, @Nullable Object missingValue, MultiValueMode sortMode, IndexFieldData.XFieldComparatorSource.Nested nested) {
        this(indexFieldData, missingValue, sortMode, nested, null);
    }

    public LongValuesComparatorSource(IndexNumericFieldData indexFieldData, @Nullable Object missingValue, MultiValueMode sortMode, IndexFieldData.XFieldComparatorSource.Nested nested, Function<SortedNumericDocValues, SortedNumericDocValues> converter) {
        super(missingValue, sortMode, nested);
        this.indexFieldData = indexFieldData;
        this.converter = converter;
    }

    @Override
    public SortField.Type reducedType() {
        return SortField.Type.LONG;
    }

    private SortedNumericDocValues loadDocValues(LeafReaderContext context) {
        LeafNumericFieldData data = (LeafNumericFieldData)this.indexFieldData.load(context);
        SortedNumericDocValues values = data instanceof SortedNumericIndexFieldData.NanoSecondFieldData ? ((SortedNumericIndexFieldData.NanoSecondFieldData)data).getLongValuesAsNanos() : data.getLongValues();
        return this.converter != null ? this.converter.apply(values) : values;
    }

    private NumericDocValues getNumericDocValues(LeafReaderContext context, long missingValue) throws IOException {
        SortedNumericDocValues values = this.loadDocValues(context);
        if (this.nested == null) {
            return FieldData.replaceMissing(this.sortMode.select(values), missingValue);
        }
        BitSet rootDocs = this.nested.rootDocs(context);
        DocIdSetIterator innerDocs = this.nested.innerDocs(context);
        int maxChildren = this.nested.getNestedSort() != null ? this.nested.getNestedSort().getMaxChildren() : Integer.MAX_VALUE;
        return this.sortMode.select(values, missingValue, rootDocs, innerDocs, context.reader().maxDoc(), maxChildren);
    }

    @Override
    public FieldComparator<?> newComparator(String fieldname, int numHits, Pruning pruning, boolean reversed) {
        assert (this.indexFieldData == null || fieldname.equals(this.indexFieldData.getFieldName()));
        final long lMissingValue = (Long)this.missingObject(this.missingValue, reversed);
        return new LongComparator(numHits, fieldname, lMissingValue, reversed, this.filterPruning(pruning)){

            @Override
            public LeafFieldComparator getLeafComparator(LeafReaderContext context) throws IOException {
                return new LongComparator.LongLeafComparator(context){

                    @Override
                    protected NumericDocValues getNumericDocValues(LeafReaderContext context, String field) throws IOException {
                        return LongValuesComparatorSource.this.getNumericDocValues(context, lMissingValue);
                    }
                };
            }
        };
    }

    @Override
    public BucketedSort newBucketedSort(BigArrays bigArrays, final SortOrder sortOrder, DocValueFormat format, int bucketSize, BucketedSort.ExtraData extra) {
        return new BucketedSort.ForLongs(bigArrays, sortOrder, format, bucketSize, extra){
            private final long lMissingValue;
            {
                super(bigArrays, sortOrder3, format, bucketSize, extra);
                this.lMissingValue = (Long)LongValuesComparatorSource.this.missingObject(LongValuesComparatorSource.this.missingValue, sortOrder == SortOrder.DESC);
            }

            @Override
            public BucketedSort.ForLongs.Leaf forLeaf(final LeafReaderContext ctx) throws IOException {
                return new BucketedSort.ForLongs.Leaf(ctx){
                    private final NumericDocValues docValues;
                    private long docValue;
                    {
                        super(this, ctx2);
                        this.docValues = LongValuesComparatorSource.this.getNumericDocValues(ctx, lMissingValue);
                    }

                    @Override
                    protected boolean advanceExact(int doc) throws IOException {
                        if (this.docValues.advanceExact(doc)) {
                            this.docValue = this.docValues.longValue();
                            return true;
                        }
                        return false;
                    }

                    @Override
                    protected long docValue() {
                        return this.docValue;
                    }
                };
            }
        };
    }
}

