/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.index.fieldvisitor;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.FieldInfo;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.StoredFieldVisitor;
import org.graylog.shaded.opensearch2.org.apache.lucene.util.BytesRef;
import org.graylog.shaded.opensearch2.org.opensearch.common.util.set.Sets;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.Strings;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.bytes.BytesArray;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.bytes.BytesReference;
import org.graylog.shaded.opensearch2.org.opensearch.index.mapper.MappedFieldType;
import org.graylog.shaded.opensearch2.org.opensearch.index.mapper.Uid;

public class FieldsVisitor
extends StoredFieldVisitor {
    private static final Set<String> BASE_REQUIRED_FIELDS = Collections.unmodifiableSet(Sets.newHashSet("_id", "_routing"));
    private final boolean loadSource;
    private final String sourceFieldName;
    private final Set<String> requiredFields;
    private final String[] sourceIncludes;
    private final String[] sourceExcludes;
    protected BytesReference source;
    protected String id;
    protected Map<String, List<Object>> fieldsValues;

    public FieldsVisitor(boolean loadSource) {
        this(loadSource, "_source", null, null);
    }

    public FieldsVisitor(boolean loadSource, String[] includes, String[] excludes) {
        this(loadSource, "_source", includes, excludes);
    }

    public FieldsVisitor(boolean loadSource, String sourceFieldName) {
        this(loadSource, sourceFieldName, null, null);
    }

    public FieldsVisitor(boolean loadSource, String sourceFieldName, String[] includes, String[] excludes) {
        this.loadSource = loadSource;
        this.sourceFieldName = sourceFieldName;
        this.sourceIncludes = includes != null ? includes : Strings.EMPTY_ARRAY;
        this.sourceExcludes = excludes != null ? excludes : Strings.EMPTY_ARRAY;
        this.requiredFields = new HashSet<String>();
        this.reset();
    }

    @Override
    public StoredFieldVisitor.Status needsField(FieldInfo fieldInfo) {
        if (this.requiredFields.remove(fieldInfo.name)) {
            return StoredFieldVisitor.Status.YES;
        }
        if ("_ignored".equals(fieldInfo.name)) {
            return StoredFieldVisitor.Status.YES;
        }
        return this.requiredFields.isEmpty() ? StoredFieldVisitor.Status.STOP : StoredFieldVisitor.Status.NO;
    }

    public final void postProcess(Function<String, MappedFieldType> fieldTypeLookup) {
        for (Map.Entry<String, List<Object>> entry : this.fields().entrySet()) {
            MappedFieldType fieldType = fieldTypeLookup.apply(entry.getKey());
            if (fieldType == null) {
                throw new IllegalStateException("Field [" + entry.getKey() + "] exists in the index but not in mappings");
            }
            List<Object> fieldValues = entry.getValue();
            for (int i = 0; i < fieldValues.size(); ++i) {
                fieldValues.set(i, fieldType.valueForDisplay(fieldValues.get(i)));
            }
        }
    }

    @Override
    public void binaryField(FieldInfo fieldInfo, byte[] value) {
        this.binaryField(fieldInfo, new BytesRef(value));
    }

    public void binaryField(FieldInfo fieldInfo, BytesRef value) {
        if (this.sourceFieldName.equals(fieldInfo.name)) {
            this.source = new BytesArray(value);
        } else if ("_id".equals(fieldInfo.name)) {
            this.id = Uid.decodeId(value.bytes, value.offset, value.length);
        } else {
            this.addValue(fieldInfo.name, value);
        }
    }

    @Override
    public void stringField(FieldInfo fieldInfo, String value) {
        assert (!"_id".equals(fieldInfo.name)) : "_id field must go through binaryField";
        assert (!this.sourceFieldName.equals(fieldInfo.name)) : "source field must go through binaryField";
        this.addValue(fieldInfo.name, value);
    }

    @Override
    public void intField(FieldInfo fieldInfo, int value) {
        this.addValue(fieldInfo.name, value);
    }

    @Override
    public void longField(FieldInfo fieldInfo, long value) {
        this.addValue(fieldInfo.name, value);
    }

    @Override
    public void floatField(FieldInfo fieldInfo, float value) {
        this.addValue(fieldInfo.name, Float.valueOf(value));
    }

    @Override
    public void doubleField(FieldInfo fieldInfo, double value) {
        this.addValue(fieldInfo.name, value);
    }

    public void objectField(FieldInfo fieldInfo, Object object) {
        assert (!"_id".equals(fieldInfo.name)) : "_id field must go through binaryField";
        assert (!this.sourceFieldName.equals(fieldInfo.name)) : "source field must go through binaryField";
        this.addValue(fieldInfo.name, object);
    }

    public BytesReference source() {
        return this.source;
    }

    public String[] includes() {
        return this.sourceIncludes;
    }

    public String[] excludes() {
        return this.sourceExcludes;
    }

    public String id() {
        return this.id;
    }

    public String routing() {
        if (this.fieldsValues == null) {
            return null;
        }
        List<Object> values = this.fieldsValues.get("_routing");
        if (values == null || values.isEmpty()) {
            return null;
        }
        assert (values.size() == 1);
        return values.get(0).toString();
    }

    public Map<String, List<Object>> fields() {
        return this.fieldsValues != null ? this.fieldsValues : Collections.emptyMap();
    }

    public void reset() {
        if (this.fieldsValues != null) {
            this.fieldsValues.clear();
        }
        this.source = null;
        this.id = null;
        this.requiredFields.addAll(BASE_REQUIRED_FIELDS);
        if (this.loadSource) {
            this.requiredFields.add(this.sourceFieldName);
        }
    }

    void addValue(String name, Object value) {
        List<Object> values;
        if (this.fieldsValues == null) {
            this.fieldsValues = new HashMap<String, List<Object>>();
        }
        if ((values = this.fieldsValues.get(name)) == null) {
            values = new ArrayList<Object>(2);
            this.fieldsValues.put(name, values);
        }
        values.add(value);
    }
}

