/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.index.mapper;

import java.io.IOException;
import java.time.ZoneId;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.graylog.shaded.opensearch2.org.apache.lucene.document.Field;
import org.graylog.shaded.opensearch2.org.apache.lucene.document.FieldType;
import org.graylog.shaded.opensearch2.org.apache.lucene.document.SortedNumericDocValuesField;
import org.graylog.shaded.opensearch2.org.apache.lucene.document.StoredField;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.IndexOptions;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.IndexableFieldType;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.Term;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.BoostQuery;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.MatchNoDocsQuery;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.Query;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.TermQuery;
import org.graylog.shaded.opensearch2.org.apache.lucene.util.BytesRef;
import org.graylog.shaded.opensearch2.org.opensearch.common.Booleans;
import org.graylog.shaded.opensearch2.org.opensearch.common.Nullable;
import org.graylog.shaded.opensearch2.org.opensearch.common.xcontent.support.XContentMapValues;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.XContentParser;
import org.graylog.shaded.opensearch2.org.opensearch.index.fielddata.IndexFieldData;
import org.graylog.shaded.opensearch2.org.opensearch.index.fielddata.IndexNumericFieldData;
import org.graylog.shaded.opensearch2.org.opensearch.index.fielddata.plain.SortedNumericIndexFieldData;
import org.graylog.shaded.opensearch2.org.opensearch.index.mapper.FieldMapper;
import org.graylog.shaded.opensearch2.org.opensearch.index.mapper.MappedFieldType;
import org.graylog.shaded.opensearch2.org.opensearch.index.mapper.Mapper;
import org.graylog.shaded.opensearch2.org.opensearch.index.mapper.ParametrizedFieldMapper;
import org.graylog.shaded.opensearch2.org.opensearch.index.mapper.ParseContext;
import org.graylog.shaded.opensearch2.org.opensearch.index.mapper.SourceValueFetcher;
import org.graylog.shaded.opensearch2.org.opensearch.index.mapper.TermBasedFieldType;
import org.graylog.shaded.opensearch2.org.opensearch.index.mapper.TextSearchInfo;
import org.graylog.shaded.opensearch2.org.opensearch.index.mapper.ValueFetcher;
import org.graylog.shaded.opensearch2.org.opensearch.index.query.QueryShardContext;
import org.graylog.shaded.opensearch2.org.opensearch.search.DocValueFormat;
import org.graylog.shaded.opensearch2.org.opensearch.search.lookup.SearchLookup;

public class BooleanFieldMapper
extends ParametrizedFieldMapper {
    public static final String CONTENT_TYPE = "boolean";
    public static final ParametrizedFieldMapper.TypeParser PARSER = new ParametrizedFieldMapper.TypeParser((n, c) -> new Builder((String)n));
    private final Boolean nullValue;
    private final boolean indexed;
    private final boolean hasDocValues;
    private final boolean stored;

    private static BooleanFieldMapper toType(FieldMapper in) {
        return (BooleanFieldMapper)in;
    }

    protected BooleanFieldMapper(String simpleName, MappedFieldType mappedFieldType, FieldMapper.MultiFields multiFields, FieldMapper.CopyTo copyTo, Builder builder) {
        super(simpleName, mappedFieldType, multiFields, copyTo);
        this.nullValue = builder.nullValue.getValue();
        this.stored = builder.stored.getValue();
        this.indexed = builder.indexed.getValue();
        this.hasDocValues = builder.docValues.getValue();
    }

    @Override
    public BooleanFieldType fieldType() {
        return (BooleanFieldType)super.fieldType();
    }

    @Override
    protected void parseCreateField(ParseContext context) throws IOException {
        if (!(this.indexed || this.stored || this.hasDocValues)) {
            return;
        }
        Boolean value = context.parseExternalValue(Boolean.class);
        if (value == null) {
            XContentParser.Token token = context.parser().currentToken();
            if (token == XContentParser.Token.VALUE_NULL) {
                if (this.nullValue != null) {
                    value = this.nullValue;
                }
            } else {
                value = context.parser().booleanValue();
            }
        }
        if (value == null) {
            return;
        }
        if (this.indexed) {
            context.doc().add(new Field(this.fieldType().name(), value != false ? "T" : "F", (IndexableFieldType)Defaults.FIELD_TYPE));
        }
        if (this.stored) {
            context.doc().add(new StoredField(this.fieldType().name(), value != false ? "T" : "F"));
        }
        if (this.hasDocValues) {
            context.doc().add(new SortedNumericDocValuesField(this.fieldType().name(), value != false ? 1L : 0L));
        } else {
            this.createFieldNamesField(context);
        }
    }

    @Override
    public ParametrizedFieldMapper.Builder getMergeBuilder() {
        return new Builder(this.simpleName()).init(this);
    }

    @Override
    protected String contentType() {
        return CONTENT_TYPE;
    }

    public static class Builder
    extends ParametrizedFieldMapper.Builder {
        private final ParametrizedFieldMapper.Parameter<Boolean> docValues = ParametrizedFieldMapper.Parameter.docValuesParam(m -> BooleanFieldMapper.toType((FieldMapper)m).hasDocValues, true);
        private final ParametrizedFieldMapper.Parameter<Boolean> indexed = ParametrizedFieldMapper.Parameter.indexParam(m -> BooleanFieldMapper.toType((FieldMapper)m).indexed, true);
        private final ParametrizedFieldMapper.Parameter<Boolean> stored = ParametrizedFieldMapper.Parameter.storeParam(m -> BooleanFieldMapper.toType((FieldMapper)m).stored, false);
        private final ParametrizedFieldMapper.Parameter<Boolean> nullValue = new ParametrizedFieldMapper.Parameter<Boolean>("null_value", false, () -> null, (n, c, o) -> o == null ? null : Boolean.valueOf(XContentMapValues.nodeBooleanValue(o)), m -> BooleanFieldMapper.toType((FieldMapper)m).nullValue).acceptsNull();
        private final ParametrizedFieldMapper.Parameter<Float> boost = ParametrizedFieldMapper.Parameter.boostParam();
        private final ParametrizedFieldMapper.Parameter<Map<String, String>> meta = ParametrizedFieldMapper.Parameter.metaParam();

        public Builder(String name) {
            super(name);
        }

        @Override
        protected List<ParametrizedFieldMapper.Parameter<?>> getParameters() {
            return Arrays.asList(this.meta, this.boost, this.docValues, this.indexed, this.nullValue, this.stored);
        }

        @Override
        public BooleanFieldMapper build(Mapper.BuilderContext context) {
            BooleanFieldType ft = new BooleanFieldType(this.buildFullName(context), (boolean)this.indexed.getValue(), (boolean)this.stored.getValue(), (boolean)this.docValues.getValue(), this.nullValue.getValue(), this.meta.getValue());
            ft.setBoost(this.boost.getValue().floatValue());
            return new BooleanFieldMapper(this.name, ft, this.multiFieldsBuilder.build(this, context), this.copyTo.build(), this);
        }
    }

    public static final class BooleanFieldType
    extends TermBasedFieldType {
        private final Boolean nullValue;

        public BooleanFieldType(String name, boolean isSearchable, boolean isStored, boolean hasDocValues, Boolean nullValue, Map<String, String> meta) {
            super(name, isSearchable, isStored, hasDocValues, TextSearchInfo.SIMPLE_MATCH_ONLY, meta);
            this.nullValue = nullValue;
        }

        public BooleanFieldType(String name) {
            this(name, true, false, true, false, Collections.emptyMap());
        }

        public BooleanFieldType(String name, boolean searchable) {
            this(name, searchable, false, true, false, Collections.emptyMap());
        }

        public BooleanFieldType(String name, boolean searchable, boolean hasDocValues) {
            this(name, searchable, false, hasDocValues, false, Collections.emptyMap());
        }

        @Override
        public String typeName() {
            return BooleanFieldMapper.CONTENT_TYPE;
        }

        @Override
        public ValueFetcher valueFetcher(QueryShardContext context, SearchLookup searchLookup, String format) {
            if (format != null) {
                throw new IllegalArgumentException("Field [" + this.name() + "] of type [" + this.typeName() + "] doesn't support formats.");
            }
            return new SourceValueFetcher(this.name(), context, this.nullValue){

                @Override
                protected Boolean parseSourceValue(Object value) {
                    if (value instanceof Boolean) {
                        return (Boolean)value;
                    }
                    String textValue = value.toString();
                    return Booleans.parseBooleanStrict(textValue, false);
                }
            };
        }

        @Override
        public BytesRef indexedValueForSearch(Object value) {
            if (value == null) {
                return Values.FALSE;
            }
            if (value instanceof Boolean) {
                return (Boolean)value != false ? Values.TRUE : Values.FALSE;
            }
            String sValue = value instanceof BytesRef ? ((BytesRef)value).utf8ToString() : value.toString();
            switch (sValue) {
                case "true": {
                    return Values.TRUE;
                }
                case "false": {
                    return Values.FALSE;
                }
            }
            throw new IllegalArgumentException("Can't parse boolean value [" + sValue + "], expected [true] or [false]");
        }

        @Override
        public Boolean valueForDisplay(Object value) {
            if (value == null) {
                return null;
            }
            switch (value.toString()) {
                case "F": {
                    return false;
                }
                case "T": {
                    return true;
                }
            }
            throw new IllegalArgumentException("Expected [T] or [F] but got [" + String.valueOf(value) + "]");
        }

        @Override
        public IndexFieldData.Builder fielddataBuilder(String fullyQualifiedIndexName, Supplier<SearchLookup> searchLookup) {
            this.failIfNoDocValues();
            return new SortedNumericIndexFieldData.Builder(this.name(), IndexNumericFieldData.NumericType.BOOLEAN);
        }

        @Override
        public DocValueFormat docValueFormat(@Nullable String format, ZoneId timeZone) {
            if (format != null) {
                throw new IllegalArgumentException("Field [" + this.name() + "] of type [" + this.typeName() + "] does not support custom formats");
            }
            if (timeZone != null) {
                throw new IllegalArgumentException("Field [" + this.name() + "] of type [" + this.typeName() + "] does not support custom time zones");
            }
            return DocValueFormat.BOOLEAN;
        }

        @Override
        public Query termQuery(Object value, QueryShardContext context) {
            this.failIfNotIndexedAndNoDocValues();
            if (!this.isSearchable()) {
                return SortedNumericDocValuesField.newSlowExactQuery(this.name(), Values.TRUE.bytesEquals(this.indexedValueForSearch(value)) ? 1L : 0L);
            }
            Query query = new TermQuery(new Term(this.name(), this.indexedValueForSearch(value)));
            if (this.boost() != 1.0f) {
                query = new BoostQuery(query, this.boost());
            }
            return query;
        }

        @Override
        public Query termsQuery(List<?> values, QueryShardContext context) {
            this.failIfNotIndexedAndNoDocValues();
            int distinct = 0;
            HashSet distinctValues = new HashSet(values);
            for (Object value : distinctValues) {
                if (Values.TRUE.equals(this.indexedValueForSearch(value))) {
                    distinct |= 2;
                } else if (Values.FALSE.equals(this.indexedValueForSearch(value))) {
                    distinct |= 1;
                }
                if (distinct != 3) continue;
                return this.existsQuery(context);
            }
            switch (distinct) {
                case 1: {
                    return this.termQuery("false", context);
                }
                case 2: {
                    return this.termQuery("true", context);
                }
            }
            return new MatchNoDocsQuery("Values did not contain True or False");
        }

        @Override
        public Query rangeQuery(Object lowerTerm, Object upperTerm, boolean includeLower, boolean includeUpper, QueryShardContext context) {
            this.failIfNotIndexedAndNoDocValues();
            if (lowerTerm == null) {
                lowerTerm = false;
                includeLower = true;
            }
            if (upperTerm == null) {
                upperTerm = true;
                includeUpper = true;
            }
            if ((lowerTerm = this.indexedValueForSearch(lowerTerm)) == (upperTerm = this.indexedValueForSearch(upperTerm))) {
                if (!includeLower || !includeUpper) {
                    return new MatchNoDocsQuery();
                }
                return this.termQuery(lowerTerm.equals(Values.TRUE), context);
            }
            if (lowerTerm.equals(Values.TRUE)) {
                return new MatchNoDocsQuery();
            }
            if (!includeLower && !includeUpper) {
                return new MatchNoDocsQuery();
            }
            if (!includeLower) {
                return this.termQuery(true, context);
            }
            if (!includeUpper) {
                return this.termQuery(false, context);
            }
            return this.existsQuery(context);
        }
    }

    public static class Defaults {
        public static final FieldType FIELD_TYPE = new FieldType();

        static {
            FIELD_TYPE.setOmitNorms(true);
            FIELD_TYPE.setIndexOptions(IndexOptions.DOCS);
            FIELD_TYPE.setTokenized(false);
            FIELD_TYPE.freeze();
        }
    }

    public static class Values {
        public static final BytesRef TRUE = new BytesRef("T");
        public static final BytesRef FALSE = new BytesRef("F");
    }
}

