/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.index.mapper;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.graylog.shaded.opensearch2.org.opensearch.common.annotation.ExperimentalApi;
import org.graylog.shaded.opensearch2.org.opensearch.index.mapper.MappedFieldType;
import org.graylog.shaded.opensearch2.org.opensearch.index.mapper.TextSearchInfo;

@ExperimentalApi
public abstract class CompositeMappedFieldType
extends MappedFieldType {
    private final List<String> fields;
    private final CompositeFieldType type;

    public CompositeMappedFieldType(String name, boolean isIndexed, boolean isStored, boolean hasDocValues, TextSearchInfo textSearchInfo, Map<String, String> meta, List<String> fields, CompositeFieldType type) {
        super(name, isIndexed, isStored, hasDocValues, textSearchInfo, meta);
        this.fields = fields;
        this.type = type;
    }

    public CompositeMappedFieldType(String name, List<String> fields, CompositeFieldType type) {
        this(name, false, false, false, TextSearchInfo.NONE, Collections.emptyMap(), fields, type);
    }

    public CompositeFieldType getCompositeIndexType() {
        return this.type;
    }

    public List<String> fields() {
        return this.fields;
    }

    @ExperimentalApi
    public static enum CompositeFieldType {
        STAR_TREE("star_tree");

        private final String name;

        private CompositeFieldType(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public static CompositeFieldType fromName(String name) {
            for (CompositeFieldType metric : CompositeFieldType.values()) {
                if (!metric.getName().equalsIgnoreCase(name)) continue;
                return metric;
            }
            throw new IllegalArgumentException("Invalid metric stat: " + name);
        }
    }
}

