/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.index.mapper;

import java.io.IOException;
import java.time.ZoneId;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.MatchAllDocsQuery;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.MatchNoDocsQuery;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.MultiTermQuery;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.Query;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.RegexpQuery;
import org.graylog.shaded.opensearch2.org.apache.lucene.util.BytesRef;
import org.graylog.shaded.opensearch2.org.apache.lucene.util.automaton.Automaton;
import org.graylog.shaded.opensearch2.org.apache.lucene.util.automaton.ByteRunAutomaton;
import org.graylog.shaded.opensearch2.org.apache.lucene.util.automaton.RegExp;
import org.graylog.shaded.opensearch2.org.opensearch.OpenSearchParseException;
import org.graylog.shaded.opensearch2.org.opensearch.common.Nullable;
import org.graylog.shaded.opensearch2.org.opensearch.common.annotation.PublicApi;
import org.graylog.shaded.opensearch2.org.opensearch.common.geo.ShapeRelation;
import org.graylog.shaded.opensearch2.org.opensearch.common.lucene.BytesRefs;
import org.graylog.shaded.opensearch2.org.opensearch.common.regex.Regex;
import org.graylog.shaded.opensearch2.org.opensearch.common.time.DateMathParser;
import org.graylog.shaded.opensearch2.org.opensearch.index.fielddata.IndexFieldData;
import org.graylog.shaded.opensearch2.org.opensearch.index.fielddata.plain.ConstantIndexFieldData;
import org.graylog.shaded.opensearch2.org.opensearch.index.mapper.ConstantFieldType;
import org.graylog.shaded.opensearch2.org.opensearch.index.mapper.FieldMapper;
import org.graylog.shaded.opensearch2.org.opensearch.index.mapper.MappedFieldType;
import org.graylog.shaded.opensearch2.org.opensearch.index.mapper.Mapper;
import org.graylog.shaded.opensearch2.org.opensearch.index.mapper.MapperParsingException;
import org.graylog.shaded.opensearch2.org.opensearch.index.mapper.ParametrizedFieldMapper;
import org.graylog.shaded.opensearch2.org.opensearch.index.mapper.ParseContext;
import org.graylog.shaded.opensearch2.org.opensearch.index.mapper.SourceValueFetcher;
import org.graylog.shaded.opensearch2.org.opensearch.index.mapper.ValueFetcher;
import org.graylog.shaded.opensearch2.org.opensearch.index.query.QueryShardContext;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.support.CoreValuesSourceType;
import org.graylog.shaded.opensearch2.org.opensearch.search.lookup.SearchLookup;

@PublicApi(since="2.14.0")
public class ConstantKeywordFieldMapper
extends ParametrizedFieldMapper {
    public static final String CONTENT_TYPE = "constant_keyword";
    private static final String valuePropertyName = "value";
    private final String value;

    private static ConstantKeywordFieldMapper toType(FieldMapper in) {
        return (ConstantKeywordFieldMapper)in;
    }

    protected ConstantKeywordFieldMapper(String simpleName, MappedFieldType mappedFieldType, FieldMapper.MultiFields multiFields, FieldMapper.CopyTo copyTo, Builder builder) {
        super(simpleName, mappedFieldType, multiFields, copyTo);
        this.value = builder.value.getValue();
    }

    @Override
    public ParametrizedFieldMapper.Builder getMergeBuilder() {
        return new Builder(this.simpleName(), this.value).init(this);
    }

    @Override
    protected void parseCreateField(ParseContext context) throws IOException {
        String value = context.externalValueSet() ? context.externalValue().toString() : context.parser().textOrNull();
        if (value == null) {
            throw new IllegalArgumentException("constant keyword field [" + this.name() + "] must have a value");
        }
        if (!value.equals(this.fieldType().value)) {
            throw new IllegalArgumentException("constant keyword field [" + this.name() + "] must have a value of [" + this.value + "]");
        }
    }

    @Override
    public ConstantKeywordFieldType fieldType() {
        return (ConstantKeywordFieldType)super.fieldType();
    }

    @Override
    protected String contentType() {
        return CONTENT_TYPE;
    }

    public static class Builder
    extends ParametrizedFieldMapper.Builder {
        private final ParametrizedFieldMapper.Parameter<String> value = ParametrizedFieldMapper.Parameter.stringParam("value", false, m -> ConstantKeywordFieldMapper.toType((FieldMapper)m).value, null);

        public Builder(String name, String value) {
            super(name);
            this.value.setValue(value);
        }

        @Override
        public List<ParametrizedFieldMapper.Parameter<?>> getParameters() {
            return Arrays.asList(this.value);
        }

        @Override
        public ConstantKeywordFieldMapper build(Mapper.BuilderContext context) {
            return new ConstantKeywordFieldMapper(this.name, new ConstantKeywordFieldType(this.buildFullName(context), this.value.getValue()), this.multiFieldsBuilder.build(this, context), this.copyTo.build(), this);
        }
    }

    @PublicApi(since="2.14.0")
    protected static final class ConstantKeywordFieldType
    extends ConstantFieldType {
        protected final String value;

        public ConstantKeywordFieldType(String name, String value) {
            super(name, Collections.emptyMap());
            this.value = value;
        }

        @Override
        public String typeName() {
            return ConstantKeywordFieldMapper.CONTENT_TYPE;
        }

        @Override
        protected boolean matches(String pattern, boolean caseInsensitive, QueryShardContext context) {
            return Regex.simpleMatch(pattern, this.value, caseInsensitive);
        }

        @Override
        public Query existsQuery(QueryShardContext context) {
            return new MatchAllDocsQuery();
        }

        @Override
        public Query rangeQuery(Object lowerTerm, Object upperTerm, boolean includeLower, boolean includeUpper, ShapeRelation relation, ZoneId timeZone, DateMathParser parser, QueryShardContext context) {
            if (lowerTerm != null) {
                lowerTerm = ConstantKeywordFieldType.valueToString(lowerTerm);
            }
            if (upperTerm != null) {
                upperTerm = ConstantKeywordFieldType.valueToString(upperTerm);
            }
            if (lowerTerm != null && upperTerm != null && ((String)lowerTerm).compareTo((String)upperTerm) > 0) {
                return new MatchNoDocsQuery();
            }
            if (lowerTerm != null && ((String)lowerTerm).compareTo(this.value) > (includeLower ? 0 : -1)) {
                return new MatchNoDocsQuery();
            }
            if (upperTerm != null && ((String)upperTerm).compareTo(this.value) < (includeUpper ? 0 : 1)) {
                return new MatchNoDocsQuery();
            }
            return new MatchAllDocsQuery();
        }

        @Override
        public Query regexpQuery(String value, int syntaxFlags, int matchFlags, int maxDeterminizedStates, @Nullable MultiTermQuery.RewriteMethod method, QueryShardContext context) {
            Automaton automaton = new RegExp(value, syntaxFlags, matchFlags).toAutomaton(RegexpQuery.DEFAULT_PROVIDER, maxDeterminizedStates);
            ByteRunAutomaton byteRunAutomaton = new ByteRunAutomaton(automaton);
            BytesRef valueBytes = BytesRefs.toBytesRef(this.value);
            if (byteRunAutomaton.run(valueBytes.bytes, valueBytes.offset, valueBytes.length)) {
                return new MatchAllDocsQuery();
            }
            return new MatchNoDocsQuery();
        }

        @Override
        public IndexFieldData.Builder fielddataBuilder(String fullyQualifiedIndexName, Supplier<SearchLookup> searchLookup) {
            return new ConstantIndexFieldData.Builder(fullyQualifiedIndexName, this.name(), CoreValuesSourceType.BYTES);
        }

        @Override
        public ValueFetcher valueFetcher(QueryShardContext context, SearchLookup searchLookup, String format) {
            if (format != null) {
                throw new IllegalArgumentException("Field [" + this.name() + "] of type [" + this.typeName() + "] doesn't support formats.");
            }
            return new SourceValueFetcher(this.name(), context){

                @Override
                protected Object parseSourceValue(Object value) {
                    String keywordValue = value.toString();
                    return Collections.singletonList(keywordValue);
                }
            };
        }
    }

    public static class TypeParser
    implements Mapper.TypeParser {
        public Mapper.Builder parse(String name, Map<String, Object> node, Mapper.TypeParser.ParserContext parserContext) throws MapperParsingException {
            if (!node.containsKey(ConstantKeywordFieldMapper.valuePropertyName)) {
                throw new OpenSearchParseException("Field [" + name + "] is missing required parameter [value]", new Object[0]);
            }
            Object value = node.remove(ConstantKeywordFieldMapper.valuePropertyName);
            if (!(value instanceof String)) {
                throw new OpenSearchParseException("Field [" + name + "] is expected to be a string value", new Object[0]);
            }
            return new Builder(name, (String)value);
        }
    }
}

