/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.index.mapper;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.IndexableField;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.LeafReaderContext;
import org.graylog.shaded.opensearch2.org.opensearch.common.annotation.DeprecatedApi;
import org.graylog.shaded.opensearch2.org.opensearch.common.annotation.PublicApi;
import org.graylog.shaded.opensearch2.org.opensearch.index.mapper.ValueFetcher;
import org.graylog.shaded.opensearch2.org.opensearch.script.DerivedFieldScript;
import org.graylog.shaded.opensearch2.org.opensearch.search.lookup.SourceLookup;

@PublicApi(since="2.14.0")
public class DerivedFieldValueFetcher
implements ValueFetcher {
    private DerivedFieldScript derivedFieldScript;
    private final DerivedFieldScript.LeafFactory derivedFieldScriptFactory;
    private final Function<Object, Object> valueForDisplay;

    public DerivedFieldValueFetcher(DerivedFieldScript.LeafFactory derivedFieldScriptFactory, Function<Object, Object> valueForDisplay) {
        this.derivedFieldScriptFactory = derivedFieldScriptFactory;
        this.valueForDisplay = valueForDisplay;
    }

    @DeprecatedApi(since="2.15.0")
    public DerivedFieldValueFetcher(DerivedFieldScript.LeafFactory derivedFieldScriptFactory, Function<Object, Object> valueForDisplay, Function<Object, IndexableField> indexableFieldFunction) {
        this.derivedFieldScriptFactory = derivedFieldScriptFactory;
        this.valueForDisplay = valueForDisplay;
    }

    @Override
    public List<Object> fetchValues(SourceLookup lookup) {
        List<Object> values = this.fetchValuesInternal(lookup);
        if (values.isEmpty()) {
            return values;
        }
        ArrayList<Object> result = new ArrayList<Object>();
        for (Object v : values) {
            result.add(this.valueForDisplay.apply(v));
        }
        return result;
    }

    public List<Object> fetchValuesInternal(SourceLookup lookup) {
        this.derivedFieldScript.setDocument(lookup.docId());
        this.derivedFieldScript.execute();
        return this.derivedFieldScript.getEmittedValues();
    }

    public List<IndexableField> getIndexableField(SourceLookup lookup, Function<Object, IndexableField> indexableFieldFunction) {
        List<Object> values = this.fetchValuesInternal(lookup);
        ArrayList<IndexableField> indexableFields = new ArrayList<IndexableField>();
        for (Object v : values) {
            if (v == null) continue;
            indexableFields.add(indexableFieldFunction.apply(v));
        }
        return indexableFields;
    }

    @DeprecatedApi(since="2.15.0")
    public List<IndexableField> getIndexableField(SourceLookup sourceLookup) {
        throw new UnsupportedOperationException("Use getIndexableField(SourceLookup, Function) instead.");
    }

    @Override
    public void setNextReader(LeafReaderContext context) {
        try {
            this.derivedFieldScript = this.derivedFieldScriptFactory.newInstance(context);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

