/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.index.mapper;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.graylog.shaded.opensearch2.org.apache.lucene.document.FeatureField;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.IndexOptions;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.Query;
import org.graylog.shaded.opensearch2.org.opensearch.common.lucene.Lucene;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.XContentParser;
import org.graylog.shaded.opensearch2.org.opensearch.index.fielddata.IndexFieldData;
import org.graylog.shaded.opensearch2.org.opensearch.index.mapper.FieldMapper;
import org.graylog.shaded.opensearch2.org.opensearch.index.mapper.MappedFieldType;
import org.graylog.shaded.opensearch2.org.opensearch.index.mapper.Mapper;
import org.graylog.shaded.opensearch2.org.opensearch.index.mapper.ParametrizedFieldMapper;
import org.graylog.shaded.opensearch2.org.opensearch.index.mapper.ParseContext;
import org.graylog.shaded.opensearch2.org.opensearch.index.mapper.SourceValueFetcher;
import org.graylog.shaded.opensearch2.org.opensearch.index.mapper.TextSearchInfo;
import org.graylog.shaded.opensearch2.org.opensearch.index.mapper.ValueFetcher;
import org.graylog.shaded.opensearch2.org.opensearch.index.query.QueryShardContext;
import org.graylog.shaded.opensearch2.org.opensearch.search.lookup.SearchLookup;

public class RankFeaturesFieldMapper
extends ParametrizedFieldMapper {
    public static final String CONTENT_TYPE = "rank_features";
    public static final ParametrizedFieldMapper.TypeParser PARSER = new ParametrizedFieldMapper.TypeParser((n, c) -> new Builder((String)n));
    private final boolean positiveScoreImpact;

    private static RankFeaturesFieldType ft(FieldMapper in) {
        return ((RankFeaturesFieldMapper)in).fieldType();
    }

    private RankFeaturesFieldMapper(String simpleName, MappedFieldType mappedFieldType, FieldMapper.MultiFields multiFields, FieldMapper.CopyTo copyTo, boolean positiveScoreImpact) {
        super(simpleName, mappedFieldType, multiFields, copyTo);
        assert (this.fieldType.indexOptions().compareTo(IndexOptions.DOCS_AND_FREQS) <= 0);
        this.positiveScoreImpact = positiveScoreImpact;
    }

    @Override
    public ParametrizedFieldMapper.Builder getMergeBuilder() {
        return new Builder(this.simpleName()).init(this);
    }

    @Override
    protected RankFeaturesFieldMapper clone() {
        return (RankFeaturesFieldMapper)super.clone();
    }

    @Override
    public RankFeaturesFieldType fieldType() {
        return (RankFeaturesFieldType)super.fieldType();
    }

    @Override
    public void parse(ParseContext context) throws IOException {
        if (context.externalValueSet()) {
            throw new IllegalArgumentException("[rank_features] fields can't be used in multi-fields");
        }
        if (context.parser().currentToken() != XContentParser.Token.START_OBJECT) {
            throw new IllegalArgumentException("[rank_features] fields must be json objects, expected a START_OBJECT but got: " + String.valueOf((Object)context.parser().currentToken()));
        }
        String feature = null;
        XContentParser.Token token = context.parser().nextToken();
        while (token != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                feature = context.parser().currentName();
            } else if (token != XContentParser.Token.VALUE_NULL) {
                if (token == XContentParser.Token.VALUE_NUMBER || token == XContentParser.Token.VALUE_STRING) {
                    String key = this.name() + "." + feature;
                    float value = context.parser().floatValue(true);
                    if (context.doc().getByKey(key) != null) {
                        throw new IllegalArgumentException("[rank_features] fields do not support indexing multiple values for the same rank feature [" + key + "] in the same document");
                    }
                    if (!this.positiveScoreImpact) {
                        value = 1.0f / value;
                    }
                    context.doc().addWithKey(key, new FeatureField(this.name(), feature, value));
                } else {
                    throw new IllegalArgumentException("[rank_features] fields take hashes that map a feature to a strictly positive float, but got unexpected token " + String.valueOf((Object)token));
                }
            }
            token = context.parser().nextToken();
        }
    }

    @Override
    protected void parseCreateField(ParseContext context) {
        throw new AssertionError((Object)"parse is implemented directly");
    }

    @Override
    protected String contentType() {
        return CONTENT_TYPE;
    }

    public static final class RankFeaturesFieldType
    extends MappedFieldType {
        private final boolean positiveScoreImpact;

        public RankFeaturesFieldType(String name, Map<String, String> meta, boolean positiveScoreImpact) {
            super(name, false, false, false, TextSearchInfo.NONE, meta);
            this.setIndexAnalyzer(Lucene.KEYWORD_ANALYZER);
            this.positiveScoreImpact = positiveScoreImpact;
        }

        @Override
        public String typeName() {
            return RankFeaturesFieldMapper.CONTENT_TYPE;
        }

        public boolean positiveScoreImpact() {
            return this.positiveScoreImpact;
        }

        @Override
        public Query existsQuery(QueryShardContext context) {
            throw new IllegalArgumentException("[rank_features] fields do not support [exists] queries");
        }

        @Override
        public IndexFieldData.Builder fielddataBuilder(String fullyQualifiedIndexName, Supplier<SearchLookup> searchLookup) {
            throw new IllegalArgumentException("[rank_features] fields do not support sorting, scripting or aggregating");
        }

        @Override
        public ValueFetcher valueFetcher(QueryShardContext context, SearchLookup searchLookup, String format) {
            return SourceValueFetcher.identity(this.name(), context, format);
        }

        @Override
        public Query termQuery(Object value, QueryShardContext context) {
            throw new IllegalArgumentException("Queries on [rank_features] fields are not supported");
        }
    }

    public static class Builder
    extends ParametrizedFieldMapper.Builder {
        private final ParametrizedFieldMapper.Parameter<Boolean> positiveScoreImpact = ParametrizedFieldMapper.Parameter.boolParam("positive_score_impact", false, m -> RankFeaturesFieldMapper.ft((FieldMapper)m).positiveScoreImpact, true);
        private final ParametrizedFieldMapper.Parameter<Map<String, String>> meta = ParametrizedFieldMapper.Parameter.metaParam();

        public Builder(String name) {
            super(name);
            this.builder = this;
        }

        @Override
        protected List<ParametrizedFieldMapper.Parameter<?>> getParameters() {
            return List.of(this.meta, this.positiveScoreImpact);
        }

        @Override
        public RankFeaturesFieldMapper build(Mapper.BuilderContext context) {
            return new RankFeaturesFieldMapper(this.name, new RankFeaturesFieldType(this.buildFullName(context), this.meta.getValue(), this.positiveScoreImpact.getValue()), this.multiFieldsBuilder.build(this, context), this.copyTo.build(), this.positiveScoreImpact.getValue());
        }
    }
}

