/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.index.remote;

import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.service.ClusterService;
import org.graylog.shaded.opensearch2.org.opensearch.common.annotation.PublicApi;
import org.graylog.shaded.opensearch2.org.opensearch.common.settings.ClusterSettings;
import org.graylog.shaded.opensearch2.org.opensearch.common.settings.Setting;
import org.graylog.shaded.opensearch2.org.opensearch.common.settings.Settings;
import org.graylog.shaded.opensearch2.org.opensearch.common.util.concurrent.ConcurrentCollections;
import org.graylog.shaded.opensearch2.org.opensearch.core.index.shard.ShardId;
import org.graylog.shaded.opensearch2.org.opensearch.index.remote.RemoteSegmentTransferTracker;
import org.graylog.shaded.opensearch2.org.opensearch.index.remote.RemoteTranslogTransferTracker;
import org.graylog.shaded.opensearch2.org.opensearch.index.shard.IndexEventListener;
import org.graylog.shaded.opensearch2.org.opensearch.index.shard.IndexShard;

@PublicApi(since="2.10.0")
public class RemoteStoreStatsTrackerFactory
implements IndexEventListener {
    public static final Setting<Integer> MOVING_AVERAGE_WINDOW_SIZE = Setting.intSetting("remote_store.moving_average_window_size", 20, 5, Setting.Property.Dynamic, Setting.Property.NodeScope);
    private static final Logger logger = LogManager.getLogger(RemoteStoreStatsTrackerFactory.class);
    private volatile int movingAverageWindowSize;
    private final Map<ShardId, RemoteSegmentTransferTracker> remoteSegmentTrackerMap = ConcurrentCollections.newConcurrentMap();
    private final Map<ShardId, RemoteTranslogTransferTracker> remoteTranslogTrackerMap = ConcurrentCollections.newConcurrentMap();

    public RemoteStoreStatsTrackerFactory(ClusterService clusterService, Settings settings) {
        ClusterSettings clusterSettings = clusterService.getClusterSettings();
        this.movingAverageWindowSize = MOVING_AVERAGE_WINDOW_SIZE.get(settings);
        clusterSettings.addSettingsUpdateConsumer(MOVING_AVERAGE_WINDOW_SIZE, this::updateMovingAverageWindowSize);
    }

    @Override
    public void afterIndexShardCreated(IndexShard indexShard) {
        if (!indexShard.indexSettings().isRemoteStoreEnabled() && !indexShard.indexSettings().isAssignedOnRemoteNode()) {
            return;
        }
        ShardId shardId = indexShard.shardId();
        this.remoteSegmentTrackerMap.put(shardId, new RemoteSegmentTransferTracker(shardId, indexShard.store().getDirectoryFileTransferTracker(), this.movingAverageWindowSize));
        logger.trace("Created RemoteSegmentTransferTracker for shardId={}", (Object)shardId);
        this.remoteTranslogTrackerMap.put(shardId, new RemoteTranslogTransferTracker(shardId, this.movingAverageWindowSize));
        logger.trace("Created RemoteTranslogTransferTracker for shardId={}", (Object)shardId);
    }

    @Override
    public void afterIndexShardClosed(ShardId shardId, IndexShard indexShard, Settings indexSettings) {
        RemoteTranslogTransferTracker remoteTranslogTransferTracker;
        RemoteSegmentTransferTracker remoteSegmentTransferTracker = this.remoteSegmentTrackerMap.remove(shardId);
        if (remoteSegmentTransferTracker != null) {
            logger.trace("Deleted RemoteSegmentTransferTracker for shardId={}", (Object)shardId);
        }
        if ((remoteTranslogTransferTracker = this.remoteTranslogTrackerMap.remove(shardId)) != null) {
            logger.trace("Deleted RemoteTranslogTransferTracker for shardId={}", (Object)shardId);
        }
    }

    private void updateMovingAverageWindowSize(int updatedSize) {
        this.remoteSegmentTrackerMap.values().forEach(tracker -> tracker.updateMovingAverageWindowSize(updatedSize));
        this.remoteTranslogTrackerMap.values().forEach(tracker -> tracker.updateMovingAverageWindowSize(updatedSize));
        this.movingAverageWindowSize = updatedSize;
    }

    public RemoteSegmentTransferTracker getRemoteSegmentTransferTracker(ShardId shardId) {
        return this.remoteSegmentTrackerMap.get(shardId);
    }

    public RemoteTranslogTransferTracker getRemoteTranslogTransferTracker(ShardId shardId) {
        return this.remoteTranslogTrackerMap.get(shardId);
    }

    int getMovingAverageWindowSize() {
        return this.movingAverageWindowSize;
    }

    static class Defaults {
        static final int MOVING_AVERAGE_WINDOW_SIZE = 20;
        static final int MOVING_AVERAGE_WINDOW_SIZE_MIN_VALUE = 5;

        Defaults() {
        }
    }
}

