/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.index.seqno;

import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.graylog.shaded.opensearch2.org.apache.lucene.store.AlreadyClosedException;
import org.graylog.shaded.opensearch2.org.opensearch.ExceptionsHelper;
import org.graylog.shaded.opensearch2.org.opensearch.action.support.ActionFilters;
import org.graylog.shaded.opensearch2.org.opensearch.action.support.ActiveShardCount;
import org.graylog.shaded.opensearch2.org.opensearch.action.support.replication.ReplicationRequest;
import org.graylog.shaded.opensearch2.org.opensearch.action.support.replication.ReplicationResponse;
import org.graylog.shaded.opensearch2.org.opensearch.action.support.replication.ReplicationTask;
import org.graylog.shaded.opensearch2.org.opensearch.action.support.replication.TransportReplicationAction;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.action.shard.ShardStateAction;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.service.ClusterService;
import org.graylog.shaded.opensearch2.org.opensearch.common.inject.Inject;
import org.graylog.shaded.opensearch2.org.opensearch.common.settings.Settings;
import org.graylog.shaded.opensearch2.org.opensearch.common.util.concurrent.ThreadContext;
import org.graylog.shaded.opensearch2.org.opensearch.common.util.concurrent.ThreadContextAccess;
import org.graylog.shaded.opensearch2.org.opensearch.core.action.ActionListener;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.io.stream.StreamInput;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.io.stream.StreamOutput;
import org.graylog.shaded.opensearch2.org.opensearch.core.index.shard.ShardId;
import org.graylog.shaded.opensearch2.org.opensearch.core.tasks.TaskId;
import org.graylog.shaded.opensearch2.org.opensearch.index.IndexNotFoundException;
import org.graylog.shaded.opensearch2.org.opensearch.index.seqno.RetentionLeaseSyncAction;
import org.graylog.shaded.opensearch2.org.opensearch.index.seqno.RetentionLeases;
import org.graylog.shaded.opensearch2.org.opensearch.index.shard.IndexShard;
import org.graylog.shaded.opensearch2.org.opensearch.index.shard.IndexShardClosedException;
import org.graylog.shaded.opensearch2.org.opensearch.indices.IndicesService;
import org.graylog.shaded.opensearch2.org.opensearch.node.NodeClosedException;
import org.graylog.shaded.opensearch2.org.opensearch.tasks.Task;
import org.graylog.shaded.opensearch2.org.opensearch.threadpool.ThreadPool;
import org.graylog.shaded.opensearch2.org.opensearch.transport.TransportException;
import org.graylog.shaded.opensearch2.org.opensearch.transport.TransportResponseHandler;
import org.graylog.shaded.opensearch2.org.opensearch.transport.TransportService;

public class RetentionLeaseBackgroundSyncAction
extends TransportReplicationAction<Request, Request, ReplicationResponse> {
    public static final String ACTION_NAME = "indices:admin/seq_no/retention_lease_background_sync";
    private static final Logger LOGGER = LogManager.getLogger(RetentionLeaseSyncAction.class);

    protected Logger getLogger() {
        return LOGGER;
    }

    @Inject
    public RetentionLeaseBackgroundSyncAction(Settings settings, TransportService transportService, ClusterService clusterService, IndicesService indicesService, ThreadPool threadPool, ShardStateAction shardStateAction, ActionFilters actionFilters) {
        super(settings, ACTION_NAME, transportService, clusterService, indicesService, threadPool, shardStateAction, actionFilters, Request::new, Request::new, "management");
    }

    @Override
    protected void doExecute(Task task, Request request, ActionListener<ReplicationResponse> listener) {
        assert (false) : "use RetentionLeaseBackgroundSyncAction#backgroundSync";
    }

    final void backgroundSync(final ShardId shardId, String primaryAllocationId, long primaryTerm, RetentionLeases retentionLeases) {
        ThreadContext threadContext = this.threadPool.getThreadContext();
        try (ThreadContext.StoredContext ignore = threadContext.stashContext();){
            ThreadContextAccess.doPrivilegedVoid(threadContext::markAsSystemContext);
            Request request = new Request(shardId, retentionLeases);
            final ReplicationTask task = (ReplicationTask)this.taskManager.register("transport", "retention_lease_background_sync", request);
            this.transportService.sendChildRequest(this.clusterService.localNode(), this.transportPrimaryAction, new TransportReplicationAction.ConcreteShardRequest<Request>(request, primaryAllocationId, primaryTerm), (Task)task, this.transportOptions, new TransportResponseHandler<ReplicationResponse>(){

                @Override
                public ReplicationResponse read(StreamInput in) throws IOException {
                    return RetentionLeaseBackgroundSyncAction.this.newResponseInstance(in);
                }

                @Override
                public String executor() {
                    return "same";
                }

                @Override
                public void handleResponse(ReplicationResponse response) {
                    task.setPhase("finished");
                    RetentionLeaseBackgroundSyncAction.this.taskManager.unregister(task);
                }

                @Override
                public void handleException(TransportException e) {
                    task.setPhase("finished");
                    RetentionLeaseBackgroundSyncAction.this.taskManager.unregister(task);
                    if (ExceptionsHelper.unwrap(e, NodeClosedException.class) != null) {
                        return;
                    }
                    if (ExceptionsHelper.unwrap(e, IndexNotFoundException.class, AlreadyClosedException.class, IndexShardClosedException.class) != null) {
                        return;
                    }
                    RetentionLeaseBackgroundSyncAction.this.getLogger().warn((Message)new ParameterizedMessage("{} retention lease background sync failed", (Object)shardId), (Throwable)e);
                }
            });
        }
    }

    @Override
    protected void shardOperationOnPrimary(Request request, IndexShard primary, ActionListener<TransportReplicationAction.PrimaryResult<Request, ReplicationResponse>> listener) {
        ActionListener.completeWith(listener, () -> {
            assert (request.waitForActiveShards().equals(ActiveShardCount.NONE)) : request.waitForActiveShards();
            Objects.requireNonNull(request);
            Objects.requireNonNull(primary);
            primary.persistRetentionLeases();
            return new TransportReplicationAction.PrimaryResult<Request, ReplicationResponse>(request, new ReplicationResponse());
        });
    }

    @Override
    protected void shardOperationOnReplica(Request request, IndexShard replica, ActionListener<TransportReplicationAction.ReplicaResult> listener) {
        ActionListener.completeWith(listener, () -> {
            Objects.requireNonNull(request);
            Objects.requireNonNull(replica);
            replica.updateRetentionLeasesOnReplica(request.getRetentionLeases());
            replica.persistRetentionLeases();
            return new TransportReplicationAction.ReplicaResult();
        });
    }

    @Override
    protected ReplicationResponse newResponseInstance(StreamInput in) throws IOException {
        return new ReplicationResponse(in);
    }

    public static final class Request
    extends ReplicationRequest<Request> {
        private RetentionLeases retentionLeases;

        public RetentionLeases getRetentionLeases() {
            return this.retentionLeases;
        }

        public Request(StreamInput in) throws IOException {
            super(in);
            this.retentionLeases = new RetentionLeases(in);
        }

        public Request(ShardId shardId, RetentionLeases retentionLeases) {
            super(Objects.requireNonNull(shardId));
            this.retentionLeases = Objects.requireNonNull(retentionLeases);
            this.waitForActiveShards(ActiveShardCount.NONE);
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(Objects.requireNonNull(out));
            this.retentionLeases.writeTo(out);
        }

        @Override
        public Task createTask(long id, String type, String action, TaskId parentTaskId, Map<String, String> headers) {
            return new ReplicationTask(id, type, action, "retention_lease_background_sync shardId=" + String.valueOf(this.shardId), parentTaskId, headers);
        }

        @Override
        public String toString() {
            return "RetentionLeaseBackgroundSyncAction.Request{retentionLeases=" + String.valueOf(this.retentionLeases) + ", shardId=" + String.valueOf(this.shardId) + ", timeout=" + String.valueOf(this.timeout) + ", index='" + this.index + "', waitForActiveShards=" + String.valueOf(this.waitForActiveShards) + "}";
        }
    }
}

