/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.index.seqno;

import java.util.Map;
import org.graylog.shaded.opensearch2.org.opensearch.common.annotation.PublicApi;

public class SequenceNumbers {
    public static final String LOCAL_CHECKPOINT_KEY = "local_checkpoint";
    public static final String MAX_SEQ_NO = "max_seq_no";
    public static final long UNASSIGNED_SEQ_NO = -2L;
    public static final long NO_OPS_PERFORMED = -1L;
    public static final long UNASSIGNED_PRIMARY_TERM = 0L;

    public static CommitInfo loadSeqNoInfoFromLuceneCommit(Iterable<Map.Entry<String, String>> commitData) {
        long maxSeqNo = -1L;
        long localCheckpoint = -1L;
        for (Map.Entry<String, String> entry : commitData) {
            String key = entry.getKey();
            if (key.equals(LOCAL_CHECKPOINT_KEY)) {
                assert (localCheckpoint == -1L) : localCheckpoint;
                localCheckpoint = Long.parseLong(entry.getValue());
                continue;
            }
            if (!key.equals(MAX_SEQ_NO)) continue;
            assert (maxSeqNo == -1L) : maxSeqNo;
            maxSeqNo = Long.parseLong(entry.getValue());
        }
        return new CommitInfo(maxSeqNo, localCheckpoint);
    }

    public static long min(long minSeqNo, long seqNo) {
        if (minSeqNo == -1L) {
            return seqNo;
        }
        if (minSeqNo == -2L) {
            return seqNo;
        }
        if (seqNo == -2L) {
            throw new IllegalArgumentException("sequence number must be assigned");
        }
        return Math.min(minSeqNo, seqNo);
    }

    public static long max(long maxSeqNo, long seqNo) {
        if (maxSeqNo == -1L) {
            return seqNo;
        }
        if (maxSeqNo == -2L) {
            return seqNo;
        }
        if (seqNo == -2L) {
            throw new IllegalArgumentException("sequence number must be assigned");
        }
        return Math.max(maxSeqNo, seqNo);
    }

    @PublicApi(since="1.0.0")
    public static final class CommitInfo {
        public final long maxSeqNo;
        public final long localCheckpoint;

        public CommitInfo(long maxSeqNo, long localCheckpoint) {
            this.maxSeqNo = maxSeqNo;
            this.localCheckpoint = localCheckpoint;
        }

        public String toString() {
            return "CommitInfo{maxSeqNo=" + this.maxSeqNo + ", localCheckpoint=" + this.localCheckpoint + "}";
        }
    }
}

