/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.index.snapshots.blobstore;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.function.Supplier;
import org.graylog.shaded.opensearch2.org.apache.lucene.store.RateLimiter;
import org.graylog.shaded.opensearch2.org.opensearch.common.StreamLimiter;

public class RateLimitingInputStream
extends FilterInputStream {
    private final StreamLimiter streamLimiter;

    public RateLimitingInputStream(InputStream delegate, Supplier<RateLimiter> rateLimiterSupplier, StreamLimiter.Listener listener) {
        super(delegate);
        this.streamLimiter = new StreamLimiter(rateLimiterSupplier, listener);
    }

    @Override
    public int read() throws IOException {
        int b = super.read();
        this.streamLimiter.maybePause(1);
        return b;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int n = super.read(b, off, len);
        if (n > 0) {
            this.streamLimiter.maybePause(n);
        }
        return n;
    }
}

