/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.index.store;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.graylog.shaded.opensearch2.org.apache.lucene.store.IndexOutput;
import org.graylog.shaded.opensearch2.org.opensearch.common.annotation.ExperimentalApi;
import org.graylog.shaded.opensearch2.org.opensearch.common.lucene.store.FilterIndexOutput;

@ExperimentalApi
public class CloseableFilterIndexOutput
extends FilterIndexOutput {
    private final OnCloseListener onCloseListener;
    private final String fileName;
    private final AtomicBoolean isClosed;

    public CloseableFilterIndexOutput(IndexOutput out, String fileName, OnCloseListener onCloseListener) {
        super("CloseableFilterIndexOutput for file " + fileName, out);
        this.fileName = fileName;
        this.onCloseListener = onCloseListener;
        this.isClosed = new AtomicBoolean(false);
    }

    @Override
    public void close() throws IOException {
        if (!this.isClosed.get()) {
            super.close();
            this.onCloseListener.onClose(this.fileName);
            this.isClosed.set(true);
        }
    }

    @FunctionalInterface
    public static interface OnCloseListener {
        public void onClose(String var1) throws IOException;
    }
}

