/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.index.store;

import java.io.IOException;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.graylog.shaded.opensearch2.org.apache.lucene.store.Directory;
import org.graylog.shaded.opensearch2.org.apache.lucene.store.FSDirectory;
import org.graylog.shaded.opensearch2.org.apache.lucene.store.FilterDirectory;
import org.graylog.shaded.opensearch2.org.apache.lucene.store.IOContext;
import org.graylog.shaded.opensearch2.org.apache.lucene.store.IndexInput;
import org.graylog.shaded.opensearch2.org.apache.lucene.store.IndexOutput;
import org.graylog.shaded.opensearch2.org.apache.lucene.util.Version;
import org.graylog.shaded.opensearch2.org.opensearch.common.annotation.ExperimentalApi;
import org.graylog.shaded.opensearch2.org.opensearch.common.lucene.store.InputStreamIndexInput;
import org.graylog.shaded.opensearch2.org.opensearch.index.snapshots.blobstore.BlobStoreIndexShardSnapshot;
import org.graylog.shaded.opensearch2.org.opensearch.index.store.CloseableFilterIndexOutput;
import org.graylog.shaded.opensearch2.org.opensearch.index.store.RemoteSegmentStoreDirectory;
import org.graylog.shaded.opensearch2.org.opensearch.index.store.StoreFileMetadata;
import org.graylog.shaded.opensearch2.org.opensearch.index.store.remote.file.OnDemandBlockSnapshotIndexInput;
import org.graylog.shaded.opensearch2.org.opensearch.index.store.remote.filecache.CachedFullFileIndexInput;
import org.graylog.shaded.opensearch2.org.opensearch.index.store.remote.filecache.CachedIndexInput;
import org.graylog.shaded.opensearch2.org.opensearch.index.store.remote.filecache.FileCache;
import org.graylog.shaded.opensearch2.org.opensearch.index.store.remote.utils.BlockIOContext;
import org.graylog.shaded.opensearch2.org.opensearch.index.store.remote.utils.FileTypeUtils;
import org.graylog.shaded.opensearch2.org.opensearch.index.store.remote.utils.TransferManager;

@ExperimentalApi
public class CompositeDirectory
extends FilterDirectory {
    private static final Logger logger = LogManager.getLogger(CompositeDirectory.class);
    private final FSDirectory localDirectory;
    private final RemoteSegmentStoreDirectory remoteDirectory;
    private final FileCache fileCache;
    private final TransferManager transferManager;

    public CompositeDirectory(Directory localDirectory, Directory remoteDirectory, FileCache fileCache) {
        super(localDirectory);
        this.validate(localDirectory, remoteDirectory, fileCache);
        this.localDirectory = (FSDirectory)localDirectory;
        this.remoteDirectory = (RemoteSegmentStoreDirectory)remoteDirectory;
        this.fileCache = fileCache;
        this.transferManager = new TransferManager((name, position, length) -> new InputStreamIndexInput(remoteDirectory.openInput(name, new BlockIOContext(IOContext.DEFAULT, position, length)), length), fileCache);
    }

    @Override
    public String[] listAll() throws IOException {
        this.ensureOpen();
        logger.trace("Composite Directory[{}]: listAll() called", new Supplier[]{this::toString});
        String[] localFiles = this.localDirectory.listAll();
        HashSet<String> allFiles = new HashSet<String>(Arrays.asList(localFiles));
        String[] remoteFiles = this.getRemoteFiles();
        allFiles.addAll(Arrays.asList(remoteFiles));
        logger.trace("Composite Directory[{}]: Local Directory files - {}", new Supplier[]{this::toString, () -> Arrays.toString(localFiles)});
        logger.trace("Composite Directory[{}]: Remote Directory files - {}", new Supplier[]{this::toString, () -> Arrays.toString(remoteFiles)});
        Set<Object> nonBlockLuceneFiles = allFiles.stream().filter(file -> !FileTypeUtils.isBlockFile(file)).collect(Collectors.toUnmodifiableSet());
        Object[] files = new String[nonBlockLuceneFiles.size()];
        nonBlockLuceneFiles.toArray(files);
        Arrays.sort(files);
        logger.trace("Composite Directory[{}]: listAll() returns : {}", new Supplier[]{this::toString, () -> CompositeDirectory.lambda$listAll$4((String[])files)});
        return files;
    }

    @Override
    public void deleteFile(String name) throws IOException {
        this.ensureOpen();
        logger.trace("Composite Directory[{}]: deleteFile() called {}", new Supplier[]{this::toString, () -> name});
        if (FileTypeUtils.isTempFile(name)) {
            this.localDirectory.deleteFile(name);
        } else {
            if (!Arrays.asList(this.listAll()).contains(name)) {
                throw new NoSuchFileException("File " + name + " not found in directory");
            }
            this.fileCache.remove(this.getFilePath(name));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long fileLength(String name) throws IOException {
        long fileLength;
        this.ensureOpen();
        logger.trace("Composite Directory[{}]: fileLength() called {}", new Supplier[]{this::toString, () -> name});
        Path key = this.getFilePath(name);
        if (FileTypeUtils.isTempFile(name) || this.fileCache.get(key) != null) {
            try {
                fileLength = this.localDirectory.fileLength(name);
                logger.trace("Composite Directory[{}]: fileLength of {} fetched from Local - {}", new Supplier[]{this::toString, () -> name, () -> fileLength});
            }
            finally {
                this.fileCache.decRef(key);
            }
        } else {
            fileLength = this.remoteDirectory.fileLength(name);
            logger.trace("Composite Directory[{}]: fileLength of {} fetched from Remote - {}", new Supplier[]{this::toString, () -> name, () -> fileLength});
        }
        return fileLength;
    }

    @Override
    public IndexOutput createOutput(String name, IOContext context) throws IOException {
        this.ensureOpen();
        logger.trace("Composite Directory[{}]: createOutput() called {}", new Supplier[]{this::toString, () -> name});
        return new CloseableFilterIndexOutput(this.localDirectory.createOutput(name, context), name, this::cacheFile);
    }

    @Override
    public void sync(Collection<String> names) throws IOException {
        this.ensureOpen();
        logger.trace("Composite Directory[{}]: sync() called {}", new Supplier[]{this::toString, () -> names});
        List<String> remoteFiles = Arrays.asList(this.getRemoteFiles());
        Collection filesToSync = names.stream().filter(name -> !remoteFiles.contains(name)).collect(Collectors.toList());
        logger.trace("Composite Directory[{}]: Synced files : {}", new Supplier[]{this::toString, () -> filesToSync});
        this.localDirectory.sync(filesToSync);
    }

    @Override
    public void rename(String source, String dest) throws IOException {
        this.ensureOpen();
        logger.trace("Composite Directory[{}]: rename() called : source-{}, dest-{}", new Supplier[]{this::toString, () -> source, () -> dest});
        this.localDirectory.rename(source, dest);
        this.fileCache.remove(this.getFilePath(source));
        this.cacheFile(dest);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IndexInput openInput(String name, IOContext context) throws IOException {
        this.ensureOpen();
        logger.trace("Composite Directory[{}]: openInput() called {}", new Supplier[]{this::toString, () -> name});
        if (FileTypeUtils.isTempFile(name)) {
            return this.localDirectory.openInput(name, context);
        }
        Path key = this.getFilePath(name);
        CachedIndexInput indexInput = this.fileCache.get(key);
        if (indexInput != null) {
            logger.trace("Composite Directory[{}]: Complete file {} found in FileCache", new Supplier[]{this::toString, () -> name});
            try {
                IndexInput indexInput2 = indexInput.getIndexInput().clone();
                return indexInput2;
            }
            finally {
                this.fileCache.decRef(key);
            }
        }
        logger.trace("Composite Directory[{}]: Complete file {} not in FileCache, to be fetched in Blocks from Remote", new Supplier[]{this::toString, () -> name});
        RemoteSegmentStoreDirectory.UploadedSegmentMetadata uploadedSegmentMetadata = this.remoteDirectory.getSegmentsUploadedToRemoteStore().get(name);
        if (uploadedSegmentMetadata == null) {
            throw new NoSuchFileException("File " + name + " not found in directory");
        }
        BlobStoreIndexShardSnapshot.FileInfo fileInfo = new BlobStoreIndexShardSnapshot.FileInfo(name, new StoreFileMetadata(name, uploadedSegmentMetadata.getLength(), uploadedSegmentMetadata.getChecksum(), Version.LATEST), null);
        return new OnDemandBlockSnapshotIndexInput(fileInfo, this.localDirectory, this.transferManager);
    }

    @Override
    public void close() throws IOException {
        this.ensureOpen();
        logger.trace("Composite Directory[{}]: close() called", new Supplier[]{this::toString});
        this.localDirectory.close();
    }

    @Override
    public String toString() {
        return "Composite Directory @ " + Integer.toHexString(this.hashCode());
    }

    public void afterSyncToRemote(String file) {
        this.ensureOpen();
        logger.trace("Composite Directory[{}]: File {} uploaded to Remote Store and now can be eligible for eviction in FileCache", new Supplier[]{this::toString, () -> file});
        this.fileCache.decRef(this.getFilePath(file));
    }

    public Path getFilePath(String name) {
        return this.localDirectory.getDirectory().resolve(name);
    }

    private void validate(Directory localDirectory, Directory remoteDirectory, FileCache fileCache) {
        if (localDirectory == null || remoteDirectory == null) {
            throw new IllegalStateException("Local and remote directory cannot be null for Composite Directory");
        }
        if (fileCache == null) {
            throw new IllegalStateException("File Cache not initialized on this Node, cannot create Composite Directory without FileCache");
        }
        if (!(localDirectory instanceof FSDirectory)) {
            throw new IllegalStateException("For Composite Directory, local directory must be of type FSDirectory");
        }
        if (!(remoteDirectory instanceof RemoteSegmentStoreDirectory)) {
            throw new IllegalStateException("For Composite Directory, remote directory must be of type RemoteSegmentStoreDirectory");
        }
    }

    private String[] getRemoteFiles() throws IOException {
        String[] remoteFiles;
        try {
            remoteFiles = this.remoteDirectory.listAll();
        }
        catch (NullPointerException e) {
            remoteFiles = new String[]{};
        }
        return remoteFiles;
    }

    private void cacheFile(String name) throws IOException {
        Path filePath = this.getFilePath(name);
        this.fileCache.put(filePath, new CachedFullFileIndexInput(this.fileCache, filePath, this.localDirectory.openInput(name, IOContext.DEFAULT)));
    }

    private static /* synthetic */ Object lambda$listAll$4(String[] files) {
        return Arrays.toString(files);
    }
}

