/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.index.store.lockmanager;

import java.util.function.Supplier;
import org.graylog.shaded.opensearch2.org.opensearch.common.annotation.PublicApi;
import org.graylog.shaded.opensearch2.org.opensearch.common.blobstore.BlobContainer;
import org.graylog.shaded.opensearch2.org.opensearch.common.blobstore.BlobPath;
import org.graylog.shaded.opensearch2.org.opensearch.index.remote.RemoteStoreEnums;
import org.graylog.shaded.opensearch2.org.opensearch.index.remote.RemoteStorePathStrategy;
import org.graylog.shaded.opensearch2.org.opensearch.index.store.RemoteBufferedOutputDirectory;
import org.graylog.shaded.opensearch2.org.opensearch.index.store.lockmanager.RemoteStoreLockManager;
import org.graylog.shaded.opensearch2.org.opensearch.index.store.lockmanager.RemoteStoreMetadataLockManager;
import org.graylog.shaded.opensearch2.org.opensearch.repositories.RepositoriesService;
import org.graylog.shaded.opensearch2.org.opensearch.repositories.Repository;
import org.graylog.shaded.opensearch2.org.opensearch.repositories.RepositoryMissingException;
import org.graylog.shaded.opensearch2.org.opensearch.repositories.blobstore.BlobStoreRepository;

@PublicApi(since="2.8.0")
public class RemoteStoreLockManagerFactory {
    private final Supplier<RepositoriesService> repositoriesService;
    private final String segmentsPathFixedPrefix;

    public RemoteStoreLockManagerFactory(Supplier<RepositoriesService> repositoriesService) {
        this.repositoriesService = repositoriesService;
        this.segmentsPathFixedPrefix = null;
    }

    public RemoteStoreLockManagerFactory(Supplier<RepositoriesService> repositoriesService, String segmentsPathFixedPrefix) {
        this.repositoriesService = repositoriesService;
        this.segmentsPathFixedPrefix = segmentsPathFixedPrefix;
    }

    public RemoteStoreLockManager newLockManager(String repositoryName, String indexUUID, String shardId, RemoteStorePathStrategy pathStrategy) {
        return RemoteStoreLockManagerFactory.newLockManager(this.repositoriesService.get(), repositoryName, indexUUID, shardId, pathStrategy, this.segmentsPathFixedPrefix);
    }

    public static RemoteStoreMetadataLockManager newLockManager(RepositoriesService repositoriesService, String repositoryName, String indexUUID, String shardId, RemoteStorePathStrategy pathStrategy) {
        return RemoteStoreLockManagerFactory.newLockManager(repositoriesService, repositoryName, indexUUID, shardId, pathStrategy, null);
    }

    public static RemoteStoreMetadataLockManager newLockManager(RepositoriesService repositoriesService, String repositoryName, String indexUUID, String shardId, RemoteStorePathStrategy pathStrategy, String segmentsPathFixedPrefix) {
        RemoteStoreMetadataLockManager remoteStoreMetadataLockManager;
        block9: {
            Repository repository = repositoriesService.repository(repositoryName);
            try {
                assert (repository instanceof BlobStoreRepository) : "repository should be instance of BlobStoreRepository";
                BlobPath repositoryBasePath = ((BlobStoreRepository)repository).basePath();
                RemoteStorePathStrategy.PathInput lockFilesPathInput = ((RemoteStorePathStrategy.PathInput.Builder)RemoteStorePathStrategy.PathInput.builder().basePath(repositoryBasePath).indexUUID(indexUUID).shardId(shardId).dataCategory(RemoteStoreEnums.DataCategory.SEGMENTS).dataType(RemoteStoreEnums.DataType.LOCK_FILES).fixedPrefix(segmentsPathFixedPrefix)).build();
                BlobPath lockDirectoryPath = pathStrategy.generatePath(lockFilesPathInput);
                BlobContainer lockDirectoryBlobContainer = ((BlobStoreRepository)repository).blobStore().blobContainer(lockDirectoryPath);
                remoteStoreMetadataLockManager = new RemoteStoreMetadataLockManager(new RemoteBufferedOutputDirectory(lockDirectoryBlobContainer));
                if (repository == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (repository != null) {
                        try {
                            repository.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (RepositoryMissingException e) {
                    throw new IllegalArgumentException("Repository should be present to acquire/release lock", e);
                }
            }
            repository.close();
        }
        return remoteStoreMetadataLockManager;
    }

    public Supplier<RepositoriesService> getRepositoriesService() {
        return this.repositoriesService;
    }
}

