/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.index.store.remote.filecache;

import java.nio.file.Path;
import java.util.concurrent.atomic.AtomicBoolean;
import org.graylog.shaded.opensearch2.org.apache.lucene.store.AlreadyClosedException;
import org.graylog.shaded.opensearch2.org.apache.lucene.store.IndexInput;
import org.graylog.shaded.opensearch2.org.opensearch.common.annotation.ExperimentalApi;
import org.graylog.shaded.opensearch2.org.opensearch.index.store.remote.filecache.CachedIndexInput;
import org.graylog.shaded.opensearch2.org.opensearch.index.store.remote.filecache.FileCache;
import org.graylog.shaded.opensearch2.org.opensearch.index.store.remote.filecache.FullFileCachedIndexInput;

@ExperimentalApi
public class CachedFullFileIndexInput
implements CachedIndexInput {
    private final FileCache fileCache;
    private final Path path;
    private final FullFileCachedIndexInput fullFileCachedIndexInput;
    private final AtomicBoolean isClosed;

    public CachedFullFileIndexInput(FileCache fileCache, Path path, IndexInput indexInput) {
        this.fileCache = fileCache;
        this.path = path;
        this.fullFileCachedIndexInput = new FullFileCachedIndexInput(fileCache, path, indexInput);
        this.isClosed = new AtomicBoolean(false);
    }

    @Override
    public IndexInput getIndexInput() {
        if (this.isClosed.get()) {
            throw new AlreadyClosedException("Index input is already closed");
        }
        return this.fullFileCachedIndexInput;
    }

    @Override
    public long length() {
        return this.fullFileCachedIndexInput.length();
    }

    @Override
    public boolean isClosed() {
        return this.isClosed.get();
    }

    @Override
    public void close() throws Exception {
        if (!this.isClosed.getAndSet(true)) {
            this.fullFileCachedIndexInput.close();
        }
    }
}

