/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.index.store.remote.utils;

import java.nio.file.Path;
import java.util.List;
import org.graylog.shaded.opensearch2.org.apache.lucene.store.Directory;
import org.graylog.shaded.opensearch2.org.apache.lucene.store.FSDirectory;

public class BlobFetchRequest {
    private final Path filePath;
    private final Directory directory;
    private final String fileName;
    private final List<BlobPart> blobParts;
    private final long blobLength;

    private BlobFetchRequest(Builder builder) {
        this.fileName = builder.fileName;
        this.filePath = builder.directory.getDirectory().resolve(this.fileName);
        this.directory = builder.directory;
        this.blobParts = builder.blobParts;
        this.blobLength = builder.blobParts.stream().mapToLong(o -> o.getLength()).sum();
    }

    public Path getFilePath() {
        return this.filePath;
    }

    public Directory getDirectory() {
        return this.directory;
    }

    public String getFileName() {
        return this.fileName;
    }

    public List<BlobPart> blobParts() {
        return this.blobParts;
    }

    public long getBlobLength() {
        return this.blobLength;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        return "BlobFetchRequest{blobParts=" + String.valueOf(this.blobParts) + "', filePath=" + String.valueOf(this.filePath) + ", directory=" + String.valueOf(this.directory) + ", fileName='" + this.fileName + "'}";
    }

    public static final class Builder {
        private List<BlobPart> blobParts;
        private FSDirectory directory;
        private String fileName;

        private Builder() {
        }

        public Builder directory(FSDirectory directory) {
            this.directory = directory;
            return this;
        }

        public Builder fileName(String fileName) {
            this.fileName = fileName;
            return this;
        }

        public Builder blobParts(List<BlobPart> blobParts) {
            this.blobParts = blobParts;
            return this;
        }

        public BlobFetchRequest build() {
            return new BlobFetchRequest(this);
        }
    }

    public static class BlobPart {
        private String blobName;
        private long position;
        private long length;

        public BlobPart(String blobName, long position, long length) {
            this.blobName = blobName;
            if (length <= 0L) {
                throw new IllegalArgumentException("Length for blob part fetch request needs to be non-negative");
            }
            this.length = length;
            this.position = position;
        }

        public String getBlobName() {
            return this.blobName;
        }

        public long getPosition() {
            return this.position;
        }

        public long getLength() {
            return this.length;
        }
    }
}

