/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.index.store.remote.utils.cache;

import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.graylog.shaded.opensearch2.org.opensearch.common.cache.RemovalListener;
import org.graylog.shaded.opensearch2.org.opensearch.common.cache.RemovalNotification;
import org.graylog.shaded.opensearch2.org.opensearch.common.cache.Weigher;
import org.graylog.shaded.opensearch2.org.opensearch.index.store.remote.utils.cache.CacheUsage;
import org.graylog.shaded.opensearch2.org.opensearch.index.store.remote.utils.cache.LRUCache;
import org.graylog.shaded.opensearch2.org.opensearch.index.store.remote.utils.cache.RefCountedCache;
import org.graylog.shaded.opensearch2.org.opensearch.index.store.remote.utils.cache.stats.CacheStats;

public class SegmentedCache<K, V>
implements RefCountedCache<K, V> {
    private static final Logger logger = LogManager.getLogger(SegmentedCache.class);
    private static final int HASH_BITS = Integer.MAX_VALUE;
    private final long capacity;
    private final long perSegmentCapacity;
    private final RefCountedCache<K, V>[] table;
    private final int segmentMask;
    private final Weigher<V> weigher;

    private static final int ceilingNextPowerOfTwo(int x) {
        return 1 << 32 - Integer.numberOfLeadingZeros(x - 1);
    }

    public SegmentedCache(Builder<K, V> builder) {
        int segments = SegmentedCache.ceilingNextPowerOfTwo(builder.concurrencyLevel);
        this.segmentMask = segments - 1;
        this.table = this.newSegmentArray(segments);
        this.perSegmentCapacity = (builder.capacity + (long)(segments - 1)) / (long)segments;
        this.weigher = builder.weigher;
        for (int i = 0; i < this.table.length; ++i) {
            this.table[i] = new LRUCache(this.perSegmentCapacity, builder.listener, builder.weigher);
        }
        this.capacity = this.perSegmentCapacity * (long)segments;
    }

    final RefCountedCache<K, V>[] newSegmentArray(int size) {
        return new RefCountedCache[size];
    }

    RefCountedCache<K, V> segmentFor(K key) {
        int h = key.hashCode();
        h = (h >>> 16 ^ h) * 73244475;
        h = (h >>> 16 ^ h) * 73244475;
        h = h >>> 16 ^ h;
        return this.table[h & Integer.MAX_VALUE & this.segmentMask];
    }

    public long capacity() {
        return this.capacity;
    }

    @Override
    public V get(K key) {
        if (key == null) {
            throw new NullPointerException();
        }
        return this.segmentFor(key).get(key);
    }

    @Override
    public V put(K key, V value) {
        if (key == null || value == null) {
            throw new NullPointerException();
        }
        return this.segmentFor(key).put(key, value);
    }

    @Override
    public V compute(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        if (key == null || remappingFunction == null) {
            throw new NullPointerException();
        }
        return this.segmentFor(key).compute((K)key, (BiFunction<? super K, ? extends V, ? extends V>)remappingFunction);
    }

    @Override
    public void remove(K key) {
        if (key == null) {
            throw new NullPointerException();
        }
        this.segmentFor(key).remove(key);
    }

    @Override
    public void clear() {
        for (RefCountedCache<K, V> cache : this.table) {
            cache.clear();
        }
    }

    @Override
    public long size() {
        long size = 0L;
        for (RefCountedCache<K, V> cache : this.table) {
            size += cache.size();
        }
        return size;
    }

    @Override
    public void incRef(K key) {
        if (key == null) {
            throw new NullPointerException();
        }
        this.segmentFor(key).incRef(key);
    }

    @Override
    public void decRef(K key) {
        if (key == null) {
            throw new NullPointerException();
        }
        this.segmentFor(key).decRef(key);
    }

    @Override
    public long prune() {
        long sum = 0L;
        for (RefCountedCache<K, V> cache : this.table) {
            sum += cache.prune();
        }
        return sum;
    }

    @Override
    public long prune(Predicate<K> keyPredicate) {
        long sum = 0L;
        for (RefCountedCache<K, V> cache : this.table) {
            sum += cache.prune(keyPredicate);
        }
        return sum;
    }

    @Override
    public CacheUsage usage() {
        long usage = 0L;
        long activeUsage = 0L;
        for (RefCountedCache<K, V> cache : this.table) {
            CacheUsage c = cache.usage();
            usage += c.usage();
            activeUsage += c.activeUsage();
        }
        return new CacheUsage(usage, activeUsage);
    }

    @Override
    public CacheStats stats() {
        long hitCount = 0L;
        long missCount = 0L;
        long removeCount = 0L;
        long removeWeight = 0L;
        long replaceCount = 0L;
        long evictionCount = 0L;
        long evictionWeight = 0L;
        for (RefCountedCache<K, V> cache : this.table) {
            CacheStats c = cache.stats();
            hitCount += c.hitCount();
            missCount += c.missCount();
            removeCount += c.removeCount();
            removeWeight += c.removeWeight();
            replaceCount += c.replaceCount();
            evictionCount += c.evictionCount();
            evictionWeight += c.evictionWeight();
        }
        return new CacheStats(hitCount, missCount, removeCount, removeWeight, replaceCount, evictionCount, evictionWeight);
    }

    public void logCurrentState() {
        int i = 0;
        for (RefCountedCache<K, V> cache : this.table) {
            logger.trace("SegmentedCache " + i);
            ((LRUCache)cache).logCurrentState();
            ++i;
        }
    }

    public long getPerSegmentCapacity() {
        return this.perSegmentCapacity;
    }

    public Weigher<V> getWeigher() {
        return this.weigher;
    }

    public static <K, V> Builder<K, V> builder() {
        return new Builder();
    }

    public static final class Builder<K, V> {
        static final int DEFAULT_CONCURRENCY_LEVEL = Runtime.getRuntime().availableProcessors();
        RemovalListener<K, V> listener;
        Weigher<V> weigher = SingletonWeigher.INSTANCE;
        int concurrencyLevel = DEFAULT_CONCURRENCY_LEVEL;
        long capacity = -1L;

        Builder() {
            this.listener = DiscardingListener.INSTANCE;
        }

        public Builder<K, V> capacity(long capacity) {
            Builder.checkArgument(capacity >= 0L, "capacity has to be greater or equal to 0");
            this.capacity = capacity;
            return this;
        }

        public Builder<K, V> concurrencyLevel(int concurrencyLevel) {
            Builder.checkArgument(concurrencyLevel > 0, "concurrencyLevel has to be greater than 0");
            this.concurrencyLevel = concurrencyLevel;
            return this;
        }

        public Builder<K, V> listener(RemovalListener<K, V> listener) {
            Objects.requireNonNull(listener);
            this.listener = listener;
            return this;
        }

        public Builder<K, V> weigher(Weigher<V> weigher) {
            Objects.requireNonNull(weigher);
            this.weigher = weigher;
            return this;
        }

        private static void checkArgument(boolean expression, String message) {
            if (!expression) {
                throw new IllegalArgumentException(message);
            }
        }

        public SegmentedCache<K, V> build() {
            return new SegmentedCache(this);
        }
    }

    static enum DiscardingListener implements RemovalListener<Object, Object>
    {
        INSTANCE;


        @Override
        public void onRemoval(RemovalNotification<Object, Object> notification) {
        }
    }

    static enum SingletonWeigher implements Weigher<Object>
    {
        INSTANCE;


        @Override
        public long weightOf(Object value) {
            return 1L;
        }
    }
}

