/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.index.store.remote.utils.cache.stats;

import java.util.Objects;
import org.graylog.shaded.opensearch2.org.opensearch.common.annotation.PublicApi;

@PublicApi(since="2.7.0")
public final class CacheStats {
    private final long hitCount;
    private final long missCount;
    private final long removeCount;
    private final long removeWeight;
    private final long replaceCount;
    private final long evictionCount;
    private final long evictionWeight;

    public CacheStats(long hitCount, long missCount, long removeCount, long removeWeight, long replaceCount, long evictionCount, long evictionWeight) {
        if (hitCount < 0L || missCount < 0L || removeCount < 0L || removeWeight < 0L || replaceCount < 0L || evictionCount < 0L || evictionWeight < 0L) {
            throw new IllegalArgumentException();
        }
        this.hitCount = hitCount;
        this.missCount = missCount;
        this.removeCount = removeCount;
        this.removeWeight = removeWeight;
        this.replaceCount = replaceCount;
        this.evictionCount = evictionCount;
        this.evictionWeight = evictionWeight;
    }

    public long requestCount() {
        return this.hitCount + this.missCount;
    }

    public long hitCount() {
        return this.hitCount;
    }

    public double hitRate() {
        long requestCount = this.requestCount();
        return requestCount == 0L ? 1.0 : (double)this.hitCount / (double)requestCount;
    }

    public long missCount() {
        return this.missCount;
    }

    public double missRate() {
        long requestCount = this.requestCount();
        return requestCount == 0L ? 0.0 : (double)this.missCount / (double)requestCount;
    }

    public long removeCount() {
        return this.removeCount;
    }

    public long removeWeight() {
        return this.removeWeight;
    }

    public long replaceCount() {
        return this.replaceCount;
    }

    public long evictionCount() {
        return this.evictionCount;
    }

    public long evictionWeight() {
        return this.evictionWeight;
    }

    public int hashCode() {
        return Objects.hash(this.hitCount, this.missCount, this.removeCount, this.removeWeight, this.replaceCount, this.evictionCount, this.evictionWeight);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CacheStats)) {
            return false;
        }
        CacheStats other = (CacheStats)o;
        return this.hitCount == other.hitCount && this.missCount == other.missCount && this.removeCount == other.removeCount && this.removeWeight == other.removeWeight && this.replaceCount == other.replaceCount && this.evictionCount == other.evictionCount && this.evictionWeight == other.evictionWeight;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{hitCount=" + this.hitCount + ", missCount=" + this.missCount + ", removeCount=" + this.removeCount + ", removeWeight=" + this.removeWeight + ", replaceCount=" + this.replaceCount + ", evictionCount=" + this.evictionCount + ", evictionWeight=" + this.evictionWeight + "}";
    }
}

