/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.index.translog;

import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BooleanSupplier;
import java.util.function.LongConsumer;
import java.util.function.LongSupplier;
import org.apache.logging.log4j.Logger;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.service.ClusterService;
import org.graylog.shaded.opensearch2.org.opensearch.common.SetOnce;
import org.graylog.shaded.opensearch2.org.opensearch.common.blobstore.BlobPath;
import org.graylog.shaded.opensearch2.org.opensearch.common.lease.Releasable;
import org.graylog.shaded.opensearch2.org.opensearch.common.lease.Releasables;
import org.graylog.shaded.opensearch2.org.opensearch.common.logging.Loggers;
import org.graylog.shaded.opensearch2.org.opensearch.common.util.concurrent.ReleasableLock;
import org.graylog.shaded.opensearch2.org.opensearch.common.util.io.IOUtils;
import org.graylog.shaded.opensearch2.org.opensearch.core.index.shard.ShardId;
import org.graylog.shaded.opensearch2.org.opensearch.core.util.FileSystemUtils;
import org.graylog.shaded.opensearch2.org.opensearch.index.remote.RemoteStoreEnums;
import org.graylog.shaded.opensearch2.org.opensearch.index.remote.RemoteStorePathStrategy;
import org.graylog.shaded.opensearch2.org.opensearch.index.remote.RemoteTranslogTransferTracker;
import org.graylog.shaded.opensearch2.org.opensearch.index.translog.BaseTranslogReader;
import org.graylog.shaded.opensearch2.org.opensearch.index.translog.Checkpoint;
import org.graylog.shaded.opensearch2.org.opensearch.index.translog.Translog;
import org.graylog.shaded.opensearch2.org.opensearch.index.translog.TranslogConfig;
import org.graylog.shaded.opensearch2.org.opensearch.index.translog.TranslogDeletionPolicy;
import org.graylog.shaded.opensearch2.org.opensearch.index.translog.TranslogReader;
import org.graylog.shaded.opensearch2.org.opensearch.index.translog.transfer.BlobStoreTransferService;
import org.graylog.shaded.opensearch2.org.opensearch.index.translog.transfer.FileTransferTracker;
import org.graylog.shaded.opensearch2.org.opensearch.index.translog.transfer.TransferSnapshot;
import org.graylog.shaded.opensearch2.org.opensearch.index.translog.transfer.TranslogCheckpointTransferSnapshot;
import org.graylog.shaded.opensearch2.org.opensearch.index.translog.transfer.TranslogTransferManager;
import org.graylog.shaded.opensearch2.org.opensearch.index.translog.transfer.TranslogTransferMetadata;
import org.graylog.shaded.opensearch2.org.opensearch.index.translog.transfer.listener.TranslogTransferListener;
import org.graylog.shaded.opensearch2.org.opensearch.indices.RemoteStoreSettings;
import org.graylog.shaded.opensearch2.org.opensearch.repositories.Repository;
import org.graylog.shaded.opensearch2.org.opensearch.repositories.blobstore.BlobStoreRepository;
import org.graylog.shaded.opensearch2.org.opensearch.threadpool.ThreadPool;

public class RemoteFsTranslog
extends Translog {
    private final Logger logger;
    protected final TranslogTransferManager translogTransferManager;
    protected final FileTransferTracker fileTransferTracker;
    protected final BooleanSupplier startedPrimarySupplier;
    private final RemoteTranslogTransferTracker remoteTranslogTransferTracker;
    private volatile long maxRemoteTranslogGenerationUploaded;
    private volatile long minSeqNoToKeep;
    protected volatile long minRemoteGenReferenced;
    protected volatile long globalCheckpointSynced;
    protected final SetOnce<Boolean> olderPrimaryCleaned = new SetOnce();
    protected static final int REMOTE_DELETION_PERMITS = 2;
    private static final int DOWNLOAD_RETRIES = 2;
    protected final Semaphore remoteGenerationDeletionPermits = new Semaphore(2);
    private static final int SYNC_PERMIT = 1;
    private final Semaphore syncPermit = new Semaphore(1);
    protected final AtomicBoolean pauseSync = new AtomicBoolean(false);
    private final boolean isTranslogMetadataEnabled;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RemoteFsTranslog(TranslogConfig config, String translogUUID, TranslogDeletionPolicy deletionPolicy, LongSupplier globalCheckpointSupplier, LongSupplier primaryTermSupplier, LongConsumer persistedSequenceNumberConsumer, BlobStoreRepository blobStoreRepository, ThreadPool threadPool, BooleanSupplier startedPrimarySupplier, RemoteTranslogTransferTracker remoteTranslogTransferTracker, RemoteStoreSettings remoteStoreSettings) throws IOException {
        super(config, translogUUID, deletionPolicy, globalCheckpointSupplier, primaryTermSupplier, persistedSequenceNumberConsumer);
        this.logger = Loggers.getLogger(this.getClass(), this.shardId, new String[0]);
        this.startedPrimarySupplier = startedPrimarySupplier;
        this.remoteTranslogTransferTracker = remoteTranslogTransferTracker;
        this.fileTransferTracker = new FileTransferTracker(this.shardId, remoteTranslogTransferTracker);
        this.isTranslogMetadataEnabled = this.indexSettings().isTranslogMetadataEnabled();
        this.translogTransferManager = RemoteFsTranslog.buildTranslogTransferManager(blobStoreRepository, threadPool, this.shardId, this.fileTransferTracker, remoteTranslogTransferTracker, this.indexSettings().getRemoteStorePathStrategy(), remoteStoreSettings, this.isTranslogMetadataEnabled);
        try {
            if (config.downloadRemoteTranslogOnInit()) {
                RemoteFsTranslog.download(this.translogTransferManager, this.location, this.logger, config.shouldSeedRemote(), 0L);
            }
            Checkpoint checkpoint = RemoteFsTranslog.readCheckpoint(this.location);
            this.logger.info("Downloaded data from remote translog till maxSeqNo = {}", (Object)checkpoint.maxSeqNo);
            this.readers.addAll(this.recoverFromFiles(checkpoint));
            if (this.readers.isEmpty()) {
                String errorMsg = String.format(Locale.ROOT, "%s at least one reader must be recovered", this.shardId);
                this.logger.error(errorMsg);
                throw new IllegalStateException(errorMsg);
            }
            if (!config.downloadRemoteTranslogOnInit()) {
                this.translogTransferManager.populateFileTrackerWithLocalState(this.readers);
            }
            boolean success = false;
            this.current = null;
            try {
                this.current = this.createWriter(checkpoint.generation + 1L, this.getMinFileGeneration(), checkpoint.globalCheckpoint, persistedSequenceNumberConsumer);
                success = true;
            }
            finally {
                if (!success) {
                    IOUtils.closeWhileHandlingException(this.readers);
                }
            }
        }
        catch (Exception e) {
            IOUtils.closeWhileHandlingException((Closeable)this.current);
            IOUtils.closeWhileHandlingException(this.readers);
            throw e;
        }
    }

    RemoteTranslogTransferTracker getRemoteTranslogTracker() {
        return this.remoteTranslogTransferTracker;
    }

    public static void download(Repository repository, ShardId shardId, ThreadPool threadPool, Path location, RemoteStorePathStrategy pathStrategy, RemoteStoreSettings remoteStoreSettings, Logger logger, boolean seedRemote, boolean isTranslogMetadataEnabled, long timestamp) throws IOException {
        assert (repository instanceof BlobStoreRepository) : String.format(Locale.ROOT, "%s repository should be instance of BlobStoreRepository", shardId);
        BlobStoreRepository blobStoreRepository = (BlobStoreRepository)repository;
        RemoteTranslogTransferTracker remoteTranslogTransferTracker = new RemoteTranslogTransferTracker(shardId, 1000);
        FileTransferTracker fileTransferTracker = new FileTransferTracker(shardId, remoteTranslogTransferTracker);
        TranslogTransferManager translogTransferManager = RemoteFsTranslog.buildTranslogTransferManager(blobStoreRepository, threadPool, shardId, fileTransferTracker, remoteTranslogTransferTracker, pathStrategy, remoteStoreSettings, isTranslogMetadataEnabled);
        RemoteFsTranslog.download(translogTransferManager, location, logger, seedRemote, timestamp);
        logger.trace(remoteTranslogTransferTracker.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void download(TranslogTransferManager translogTransferManager, Path location, Logger logger, boolean seedRemote, long timestamp) throws IOException {
        IOException ex = null;
        for (int i = 0; i <= 2; ++i) {
            boolean success = false;
            long startTimeMs = System.currentTimeMillis();
            try {
                RemoteFsTranslog.downloadOnce(translogTransferManager, location, logger, seedRemote, timestamp);
                success = true;
                return;
            }
            catch (FileNotFoundException | NoSuchFileException e) {
                ex = e;
                continue;
            }
            finally {
                logger.trace("downloadOnce success={} timeElapsed={}", (Object)success, (Object)(System.currentTimeMillis() - startTimeMs));
            }
        }
        logger.info("Exhausted all download retries during translog/checkpoint file download");
        throw ex;
    }

    private static void downloadOnce(TranslogTransferManager translogTransferManager, Path location, Logger logger, boolean seedRemote, long timestamp) throws IOException {
        logger.debug("Downloading translog files from remote");
        RemoteTranslogTransferTracker statsTracker = translogTransferManager.getRemoteTranslogTransferTracker();
        long prevDownloadBytesSucceeded = statsTracker.getDownloadBytesSucceeded();
        long prevDownloadTimeInMillis = statsTracker.getTotalDownloadTimeInMillis();
        TranslogTransferMetadata translogMetadata = translogTransferManager.readMetadata(timestamp);
        if (translogMetadata != null) {
            if (Files.notExists(location, new LinkOption[0])) {
                Files.createDirectories(location, new FileAttribute[0]);
            }
            for (Path file : FileSystemUtils.files(location)) {
                Files.delete(file);
            }
            Map<String, String> generationToPrimaryTermMapper = translogMetadata.getGenerationToPrimaryTermMapper();
            for (long i = translogMetadata.getGeneration(); i >= translogMetadata.getMinTranslogGeneration(); --i) {
                String generation = Long.toString(i);
                translogTransferManager.downloadTranslog(generationToPrimaryTermMapper.get(generation), generation, location);
            }
            logger.info("Downloaded translog and checkpoint files from={} to={}", (Object)translogMetadata.getMinTranslogGeneration(), (Object)translogMetadata.getGeneration());
            statsTracker.recordDownloadStats(prevDownloadBytesSucceeded, prevDownloadTimeInMillis);
            Files.copy(location.resolve(Translog.getCommitCheckpointFileName(translogMetadata.getGeneration())), location.resolve("translog.ckp"), new CopyOption[0]);
        } else {
            logger.debug("No translog files found on remote, checking local filesystem for cleanup");
            if (FileSystemUtils.exists(location.resolve("translog.ckp"))) {
                Checkpoint checkpoint = RemoteFsTranslog.readCheckpoint(location);
                if (seedRemote) {
                    logger.debug("Remote migration ongoing. Retaining the translog on local, skipping clean-up");
                } else if (!RemoteFsTranslog.isEmptyTranslog(checkpoint)) {
                    logger.debug("Translog files exist on local without any metadata in remote, cleaning up these files");
                    Translog.createEmptyTranslog(location, translogTransferManager.getShardId(), checkpoint);
                } else {
                    logger.debug("Empty translog on local, skipping clean-up");
                }
            }
        }
        logger.debug("downloadOnce execution completed");
    }

    private static boolean isEmptyTranslog(Checkpoint checkpoint) {
        return checkpoint.generation == checkpoint.minTranslogGeneration && checkpoint.minSeqNo == -1L && checkpoint.maxSeqNo == -1L && checkpoint.numOps == 0;
    }

    public static TranslogTransferManager buildTranslogTransferManager(BlobStoreRepository blobStoreRepository, ThreadPool threadPool, ShardId shardId, FileTransferTracker fileTransferTracker, RemoteTranslogTransferTracker tracker, RemoteStorePathStrategy pathStrategy, RemoteStoreSettings remoteStoreSettings, boolean isTranslogMetadataEnabled) {
        assert (Objects.nonNull(pathStrategy));
        String indexUUID = shardId.getIndex().getUUID();
        String shardIdStr = String.valueOf(shardId.id());
        RemoteStorePathStrategy.PathInput dataPathInput = ((RemoteStorePathStrategy.PathInput.Builder)RemoteStorePathStrategy.PathInput.builder().basePath(blobStoreRepository.basePath()).indexUUID(indexUUID).shardId(shardIdStr).dataCategory(RemoteStoreEnums.DataCategory.TRANSLOG).dataType(RemoteStoreEnums.DataType.DATA).fixedPrefix(remoteStoreSettings.getTranslogPathFixedPrefix())).build();
        BlobPath dataPath = pathStrategy.generatePath(dataPathInput);
        RemoteStorePathStrategy.PathInput mdPathInput = ((RemoteStorePathStrategy.PathInput.Builder)RemoteStorePathStrategy.PathInput.builder().basePath(blobStoreRepository.basePath()).indexUUID(indexUUID).shardId(shardIdStr).dataCategory(RemoteStoreEnums.DataCategory.TRANSLOG).dataType(RemoteStoreEnums.DataType.METADATA).fixedPrefix(remoteStoreSettings.getTranslogPathFixedPrefix())).build();
        BlobPath mdPath = pathStrategy.generatePath(mdPathInput);
        BlobStoreTransferService transferService = new BlobStoreTransferService(blobStoreRepository.blobStore(), threadPool);
        return new TranslogTransferManager(shardId, transferService, dataPath, mdPath, fileTransferTracker, tracker, remoteStoreSettings, isTranslogMetadataEnabled);
    }

    @Override
    public boolean ensureSynced(Translog.Location location) throws IOException {
        assert (location.generation <= this.current.getGeneration());
        if (location.generation == this.current.getGeneration()) {
            this.ensureOpen();
            return this.prepareAndUpload(this.primaryTermSupplier.getAsLong(), location.generation);
        }
        return false;
    }

    @Override
    public void rollGeneration() throws IOException {
        this.syncBeforeRollGeneration();
        if (this.current.totalOperations() == 0 && this.primaryTermSupplier.getAsLong() == this.current.getPrimaryTerm()) {
            return;
        }
        this.prepareAndUpload(this.primaryTermSupplier.getAsLong(), null);
    }

    private boolean prepareAndUpload(Long primaryTerm, Long generation) throws IOException {
        ReleasableLock ignored;
        long maxSeqNo;
        block34: {
            if (!this.startedPrimarySupplier.getAsBoolean() || !this.syncPermit.tryAcquire(1)) {
                this.logger.debug("skipped uploading translog for {} {} syncPermits={}", (Object)primaryTerm, (Object)generation, (Object)this.syncPermit.availablePermits());
                return false;
            }
            maxSeqNo = -1L;
            ignored = this.writeLock.acquire();
            try {
                if (generation == null || generation.longValue() == this.current.getGeneration()) {
                    try {
                        if (!this.closed.get()) {
                            maxSeqNo = this.getMaxSeqNo();
                        }
                        TranslogReader reader = this.current.closeIntoReader();
                        this.readers.add(reader);
                        this.copyCheckpointTo(this.location.resolve(RemoteFsTranslog.getCommitCheckpointFileName(this.current.getGeneration())));
                        if (!this.closed.get()) {
                            this.logger.trace("Creating new writer for gen: [{}]", (Object)(this.current.getGeneration() + 1L));
                            this.current = this.createWriter(this.current.getGeneration() + 1L);
                        }
                        assert (this.writeLock.isHeldByCurrentThread()) : "Write lock must be held before we acquire the read lock";
                        this.readLock.acquire();
                        break block34;
                    }
                    catch (Exception e) {
                        this.tragedy.setTragicException(e);
                        this.closeOnTragicEvent(e);
                        throw e;
                    }
                }
                if (generation < this.current.getGeneration()) {
                    boolean e = false;
                    return e;
                }
            }
            finally {
                if (ignored != null) {
                    ignored.close();
                }
            }
        }
        assert (this.readLock.isHeldByCurrentThread());
        ignored = this.readLock;
        try {
            Releasable ignoredGenLock;
            block35: {
                block36: {
                    ignoredGenLock = this.deletionPolicy.acquireTranslogGen(this.getMinFileGeneration());
                    try {
                        if (generation != null) break block35;
                        if (this.closed.get()) break block36;
                        boolean bl = this.upload(primaryTerm, this.current.getGeneration() - 1L, maxSeqNo);
                        if (ignoredGenLock != null) {
                            ignoredGenLock.close();
                        }
                        return bl;
                    }
                    catch (Throwable throwable) {
                        if (ignoredGenLock != null) {
                            try {
                                ignoredGenLock.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                }
                boolean bl = this.upload(primaryTerm, this.current.getGeneration(), maxSeqNo);
                if (ignoredGenLock != null) {
                    ignoredGenLock.close();
                }
                return bl;
            }
            boolean bl = this.upload(primaryTerm, generation, maxSeqNo);
            if (ignoredGenLock != null) {
                ignoredGenLock.close();
            }
            return bl;
        }
        finally {
            if (ignored != null) {
                ignored.close();
            }
        }
    }

    private boolean upload(long primaryTerm, long generation, long maxSeqNo) throws IOException {
        this.logger.trace("uploading translog for primary term {} generation {}", (Object)primaryTerm, (Object)generation);
        try {
            boolean bl;
            block9: {
                TranslogCheckpointTransferSnapshot transferSnapshotProvider = new TranslogCheckpointTransferSnapshot.Builder(primaryTerm, generation, this.location, this.readers, Translog::getCommitCheckpointFileName, this.config.getNodeId()).build();
                try {
                    Checkpoint checkpoint = this.current.getLastSyncedCheckpoint();
                    bl = this.translogTransferManager.transferSnapshot(transferSnapshotProvider, new RemoteFsTranslogTransferListener(generation, primaryTerm, maxSeqNo, checkpoint.globalCheckpoint));
                    if (transferSnapshotProvider == null) break block9;
                }
                catch (Throwable throwable) {
                    if (transferSnapshotProvider != null) {
                        try {
                            transferSnapshotProvider.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                transferSnapshotProvider.close();
            }
            return bl;
        }
        finally {
            this.syncPermit.release(1);
        }
    }

    public Set<String> allUploaded() {
        return this.fileTransferTracker.allUploaded();
    }

    private boolean syncToDisk() throws IOException {
        ReleasableLock lock = this.readLock.acquire();
        try {
            boolean bl = this.current.sync();
            if (lock != null) {
                lock.close();
            }
            return bl;
        }
        catch (Throwable throwable) {
            try {
                if (lock != null) {
                    try {
                        lock.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (Exception ex) {
                this.closeOnTragicEvent(ex);
                throw ex;
            }
        }
    }

    @Override
    public void sync() throws IOException {
        if (this.syncToDisk() || this.syncNeeded()) {
            this.prepareAndUpload(this.primaryTermSupplier.getAsLong(), null);
        }
    }

    @Override
    public boolean syncNeeded() {
        try (ReleasableLock lock = this.readLock.acquire();){
            boolean bl = this.current.syncNeeded() || this.maxRemoteTranslogGenerationUploaded + 1L < this.currentFileGeneration() && this.current.totalOperations() == 0 || this.current.getLastSyncedCheckpoint().globalCheckpoint > this.globalCheckpointSynced;
            return bl;
        }
    }

    @Override
    public void close() throws IOException {
        block10: {
            assert (Translog.calledFromOutsideOrViaTragedyClose()) : String.valueOf(this.shardId) + "Translog.close method is called from inside Translog, but not via closeOnTragicEvent method";
            try (ReleasableLock lock = this.writeLock.acquire();){
                if (!this.closed.compareAndSet(false, true)) break block10;
                try {
                    this.sync();
                }
                finally {
                    this.logger.debug("translog closed");
                    this.closeFilesIfNoPendingRetentionLocks();
                }
            }
        }
    }

    @Override
    protected long getMinReferencedGen() throws IOException {
        assert (this.readLock.isHeldByCurrentThread() || this.writeLock.isHeldByCurrentThread());
        long minReferencedGen = Math.min(this.deletionPolicy.minTranslogGenRequired(this.readers, this.current), RemoteFsTranslog.minGenerationForSeqNo(this.minSeqNoToKeep, this.current, this.readers));
        assert (minReferencedGen >= this.getMinFileGeneration()) : String.valueOf(this.shardId) + " deletion policy requires a minReferenceGen of [" + minReferencedGen + "] but the lowest gen available is [" + this.getMinFileGeneration() + "]";
        assert (minReferencedGen <= this.currentFileGeneration()) : String.valueOf(this.shardId) + " deletion policy requires a minReferenceGen of [" + minReferencedGen + "] which is higher than the current generation [" + this.currentFileGeneration() + "]";
        return minReferencedGen;
    }

    @Override
    protected void setMinSeqNoToKeep(long seqNo) {
        if (seqNo < this.minSeqNoToKeep) {
            throw new IllegalArgumentException(String.valueOf(this.shardId) + " min seq number required can't go backwards: current [" + this.minSeqNoToKeep + "] new [" + seqNo + "]");
        }
        this.minSeqNoToKeep = seqNo;
    }

    @Override
    protected Releasable drainSync() {
        try {
            if (this.syncPermit.tryAcquire(1, 1L, TimeUnit.MINUTES)) {
                boolean result = this.pauseSync.compareAndSet(false, true);
                assert (result && this.syncPermit.availablePermits() == 0);
                this.logger.info("All inflight remote translog syncs finished and further syncs paused");
                return Releasables.releaseOnce(() -> {
                    this.syncPermit.release(1);
                    boolean wasSyncPaused = this.pauseSync.getAndSet(false);
                    assert (this.syncPermit.availablePermits() == 1) : "Available permits is " + this.syncPermit.availablePermits();
                    assert (wasSyncPaused) : "RemoteFsTranslog sync was not paused before re-enabling it";
                    this.logger.info("Resumed remote translog sync back on relocation failure");
                });
            }
            throw new TimeoutException("Timeout while acquiring all permits");
        }
        catch (InterruptedException | TimeoutException e) {
            throw new RuntimeException("Failed to acquire all permits", e);
        }
    }

    @Override
    public void trimUnreferencedReaders() throws IOException {
        this.trimUnreferencedReaders(false);
    }

    protected void trimUnreferencedReaders(boolean onlyTrimLocal) throws IOException {
        super.trimUnreferencedReaders();
        if (onlyTrimLocal) {
            return;
        }
        if (!this.startedPrimarySupplier.getAsBoolean() || this.pauseSync.get()) {
            return;
        }
        if (!this.remoteGenerationDeletionPermits.tryAcquire(2)) {
            return;
        }
        HashSet<Long> generationsToDelete = new HashSet<Long>();
        for (long generation = this.minRemoteGenReferenced - 1L - (long)this.indexSettings().getRemoteTranslogExtraKeep(); generation >= 0L && this.fileTransferTracker.uploaded(Translog.getFilename(generation)); --generation) {
            generationsToDelete.add(generation);
        }
        if (!generationsToDelete.isEmpty()) {
            try {
                this.deleteRemoteGeneration(generationsToDelete);
            }
            catch (Exception e) {
                this.logger.error("Exception in delete generations flow", (Throwable)e);
                this.remoteGenerationDeletionPermits.release();
                return;
            }
            this.translogTransferManager.deleteStaleTranslogMetadataFilesAsync(this.remoteGenerationDeletionPermits::release);
            this.deleteStaleRemotePrimaryTerms();
        } else {
            this.remoteGenerationDeletionPermits.release(2);
        }
    }

    private void deleteRemoteGeneration(Set<Long> generations) {
        this.translogTransferManager.deleteGenerationAsync(this.primaryTermSupplier.getAsLong(), generations, this.remoteGenerationDeletionPermits::release);
    }

    private void deleteStaleRemotePrimaryTerms() {
        if (this.olderPrimaryCleaned.trySet(Boolean.TRUE)) {
            if (this.readers.isEmpty()) {
                this.logger.trace("Translog reader list is empty, returning from deleteStaleRemotePrimaryTerms");
                return;
            }
            long minimumReferencedPrimaryTerm = this.readers.stream().map(BaseTranslogReader::getPrimaryTerm).min(Long::compare).get();
            this.translogTransferManager.deletePrimaryTermsAsync(minimumReferencedPrimaryTerm);
        }
    }

    public static void cleanup(Repository repository, ShardId shardId, ThreadPool threadPool, RemoteStorePathStrategy pathStrategy, RemoteStoreSettings remoteStoreSettings, boolean isTranslogMetadataEnabled) throws IOException {
        assert (repository instanceof BlobStoreRepository) : "repository should be instance of BlobStoreRepository";
        BlobStoreRepository blobStoreRepository = (BlobStoreRepository)repository;
        RemoteTranslogTransferTracker remoteTranslogTransferTracker = new RemoteTranslogTransferTracker(shardId, 1000);
        FileTransferTracker fileTransferTracker = new FileTransferTracker(shardId, remoteTranslogTransferTracker);
        TranslogTransferManager translogTransferManager = RemoteFsTranslog.buildTranslogTransferManager(blobStoreRepository, threadPool, shardId, fileTransferTracker, remoteTranslogTransferTracker, pathStrategy, remoteStoreSettings, isTranslogMetadataEnabled);
        translogTransferManager.deleteTranslogFiles();
    }

    @Override
    protected void onDelete() {
        ClusterService.assertClusterOrClusterManagerStateThread();
        this.translogTransferManager.delete();
    }

    boolean isRemoteGenerationDeletionPermitsAvailable() {
        return this.remoteGenerationDeletionPermits.availablePermits() == 2;
    }

    protected void onMinRemoteGenReferencedChange() {
    }

    @Override
    public long getMinUnreferencedSeqNoInSegments(long minUnrefCheckpointInLastCommit) {
        return this.minSeqNoToKeep;
    }

    int availablePermits() {
        return this.syncPermit.availablePermits();
    }

    @Override
    protected boolean shouldFlush() {
        int maxRemoteTlogReaders = this.translogTransferManager.getMaxRemoteTranslogReadersSettings();
        if (maxRemoteTlogReaders == -1) {
            return false;
        }
        return this.readers.size() >= maxRemoteTlogReaders;
    }

    private class RemoteFsTranslogTransferListener
    implements TranslogTransferListener {
        private final long generation;
        private final long primaryTerm;
        private final long maxSeqNo;
        private final long globalCheckpoint;

        RemoteFsTranslogTransferListener(long generation, long primaryTerm, long maxSeqNo, long globalCheckpoint) {
            this.generation = generation;
            this.primaryTerm = primaryTerm;
            this.maxSeqNo = maxSeqNo;
            this.globalCheckpoint = globalCheckpoint;
        }

        @Override
        public void onUploadComplete(TransferSnapshot transferSnapshot) throws IOException {
            RemoteFsTranslog.this.maxRemoteTranslogGenerationUploaded = this.generation;
            long previousMinRemoteGenReferenced = RemoteFsTranslog.this.minRemoteGenReferenced;
            RemoteFsTranslog.this.minRemoteGenReferenced = RemoteFsTranslog.this.getMinFileGeneration();
            if (this.globalCheckpoint > RemoteFsTranslog.this.globalCheckpointSynced) {
                RemoteFsTranslog.this.globalCheckpointSynced = this.globalCheckpoint;
            }
            if (previousMinRemoteGenReferenced != RemoteFsTranslog.this.minRemoteGenReferenced) {
                RemoteFsTranslog.this.onMinRemoteGenReferencedChange();
            }
            RemoteFsTranslog.this.logger.debug("Successfully uploaded translog for primary term = {}, generation = {}, maxSeqNo = {}, minRemoteGenReferenced = {}", (Object)this.primaryTerm, (Object)this.generation, (Object)this.maxSeqNo, (Object)RemoteFsTranslog.this.minRemoteGenReferenced);
        }

        @Override
        public void onUploadFailed(TransferSnapshot transferSnapshot, Exception ex) throws IOException {
            if (ex instanceof IOException) {
                throw (IOException)ex;
            }
            throw (RuntimeException)ex;
        }
    }
}

