/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.index.translog;

import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.DirectoryReader;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.IndexCommit;
import org.graylog.shaded.opensearch2.org.apache.lucene.store.Directory;
import org.graylog.shaded.opensearch2.org.opensearch.OpenSearchException;
import org.graylog.shaded.opensearch2.org.opensearch.cli.Terminal;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.ClusterState;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.metadata.IndexMetadata;
import org.graylog.shaded.opensearch2.org.opensearch.common.UUIDs;
import org.graylog.shaded.opensearch2.org.opensearch.common.collect.Tuple;
import org.graylog.shaded.opensearch2.org.opensearch.common.settings.Settings;
import org.graylog.shaded.opensearch2.org.opensearch.common.util.BigArrays;
import org.graylog.shaded.opensearch2.org.opensearch.common.util.io.IOUtils;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.NamedXContentRegistry;
import org.graylog.shaded.opensearch2.org.opensearch.index.IndexNotFoundException;
import org.graylog.shaded.opensearch2.org.opensearch.index.IndexSettings;
import org.graylog.shaded.opensearch2.org.opensearch.index.shard.RemoveCorruptedShardDataCommand;
import org.graylog.shaded.opensearch2.org.opensearch.index.shard.ShardPath;
import org.graylog.shaded.opensearch2.org.opensearch.index.translog.Checkpoint;
import org.graylog.shaded.opensearch2.org.opensearch.index.translog.DefaultTranslogDeletionPolicy;
import org.graylog.shaded.opensearch2.org.opensearch.index.translog.LocalTranslog;
import org.graylog.shaded.opensearch2.org.opensearch.index.translog.Translog;
import org.graylog.shaded.opensearch2.org.opensearch.index.translog.TranslogConfig;
import org.graylog.shaded.opensearch2.org.opensearch.index.translog.TranslogCorruptedException;
import org.graylog.shaded.opensearch2.org.opensearch.index.translog.TranslogHeader;
import org.graylog.shaded.opensearch2.org.opensearch.index.translog.TranslogReader;
import org.graylog.shaded.opensearch2.org.opensearch.index.translog.TranslogWriter;

public class TruncateTranslogAction {
    protected static final Logger logger = LogManager.getLogger(TruncateTranslogAction.class);
    private final NamedXContentRegistry namedXContentRegistry;

    public TruncateTranslogAction(NamedXContentRegistry namedXContentRegistry) {
        this.namedXContentRegistry = namedXContentRegistry;
    }

    public Tuple<RemoveCorruptedShardDataCommand.CleanStatus, String> getCleanStatus(ShardPath shardPath, ClusterState clusterState, Directory indexDirectory) throws IOException {
        Set<Path> translogFiles;
        List<IndexCommit> commits;
        Path indexPath = shardPath.resolveIndex();
        Path translogPath = shardPath.resolveTranslog();
        try {
            commits = DirectoryReader.listCommits(indexDirectory);
        }
        catch (IndexNotFoundException infe) {
            throw new OpenSearchException("unable to find a valid shard at [" + String.valueOf(indexPath) + "]", (Throwable)infe, new Object[0]);
        }
        catch (IOException e) {
            throw new OpenSearchException("unable to list commits at [" + String.valueOf(indexPath) + "]", (Throwable)e, new Object[0]);
        }
        HashMap<String, String> commitData = new HashMap<String, String>(commits.get(commits.size() - 1).getUserData());
        String translogUUID = (String)commitData.get("translog_uuid");
        if (translogUUID == null) {
            throw new OpenSearchException("shard must have a valid translog UUID but got: [null]", new Object[0]);
        }
        boolean clean = this.isTranslogClean(shardPath, clusterState, translogUUID);
        if (clean) {
            return Tuple.tuple(RemoveCorruptedShardDataCommand.CleanStatus.CLEAN, null);
        }
        try {
            translogFiles = TruncateTranslogAction.filesInDirectory(translogPath);
        }
        catch (IOException e) {
            throw new OpenSearchException("failed to find existing translog files", (Throwable)e, new Object[0]);
        }
        String details = this.deletingFilesDetails(translogPath, translogFiles);
        return Tuple.tuple(RemoveCorruptedShardDataCommand.CleanStatus.CORRUPTED, details);
    }

    public void execute(Terminal terminal, ShardPath shardPath, Directory indexDirectory) throws IOException {
        List<IndexCommit> commits;
        Set<Path> translogFiles;
        Path indexPath = shardPath.resolveIndex();
        Path translogPath = shardPath.resolveTranslog();
        String historyUUID = UUIDs.randomBase64UUID();
        try {
            terminal.println("Checking existing translog files");
            translogFiles = TruncateTranslogAction.filesInDirectory(translogPath);
        }
        catch (IOException e) {
            terminal.println("encountered IOException while listing directory, aborting...");
            throw new OpenSearchException("failed to find existing translog files", (Throwable)e, new Object[0]);
        }
        try {
            terminal.println("Reading translog UUID information from Lucene commit from shard at [" + String.valueOf(indexPath) + "]");
            commits = DirectoryReader.listCommits(indexDirectory);
        }
        catch (IndexNotFoundException infe) {
            throw new OpenSearchException("unable to find a valid shard at [" + String.valueOf(indexPath) + "]", (Throwable)infe, new Object[0]);
        }
        Map<String, String> commitData = commits.get(commits.size() - 1).getUserData();
        String translogUUID = commitData.get("translog_uuid");
        if (translogUUID == null) {
            throw new OpenSearchException("shard must have a valid translog UUID", new Object[0]);
        }
        long globalCheckpoint = commitData.containsKey("max_seq_no") ? Long.parseLong(commitData.get("max_seq_no")) : -2L;
        terminal.println("Translog UUID      : " + translogUUID);
        terminal.println("History UUID       : " + historyUUID);
        Path tempEmptyCheckpoint = translogPath.resolve("temp-translog.ckp");
        Path realEmptyCheckpoint = translogPath.resolve("translog.ckp");
        long gen = 1L;
        Path tempEmptyTranslog = translogPath.resolve("temp-translog-1.tlog");
        Path realEmptyTranslog = translogPath.resolve("translog-1.tlog");
        int translogLen = TruncateTranslogAction.writeEmptyTranslog(tempEmptyTranslog, translogUUID);
        TruncateTranslogAction.writeEmptyCheckpoint(tempEmptyCheckpoint, translogLen, 1L, globalCheckpoint);
        terminal.println("Removing existing translog files");
        IOUtils.rm(translogFiles.toArray(new Path[0]));
        terminal.println("Creating new empty checkpoint at [" + String.valueOf(realEmptyCheckpoint) + "]");
        Files.move(tempEmptyCheckpoint, realEmptyCheckpoint, StandardCopyOption.ATOMIC_MOVE);
        terminal.println("Creating new empty translog at [" + String.valueOf(realEmptyTranslog) + "]");
        Files.move(tempEmptyTranslog, realEmptyTranslog, StandardCopyOption.ATOMIC_MOVE);
        IOUtils.fsync(translogPath, true);
    }

    private boolean isTranslogClean(ShardPath shardPath, ClusterState clusterState, String translogUUID) throws IOException {
        try {
            Path translogPath = shardPath.resolveTranslog();
            long translogGlobalCheckpoint = Translog.readGlobalCheckpoint(translogPath, translogUUID);
            IndexMetadata indexMetadata = clusterState.metadata().getIndexSafe(shardPath.getShardId().getIndex());
            IndexSettings indexSettings = new IndexSettings(indexMetadata, Settings.EMPTY);
            TranslogConfig translogConfig = new TranslogConfig(shardPath.getShardId(), translogPath, indexSettings, BigArrays.NON_RECYCLING_INSTANCE, "", false);
            long primaryTerm = indexSettings.getIndexMetadata().primaryTerm(shardPath.getShardId().id());
            DefaultTranslogDeletionPolicy retainAllTranslogPolicy = new DefaultTranslogDeletionPolicy(Long.MAX_VALUE, Long.MAX_VALUE, Integer.MAX_VALUE){

                @Override
                public long minTranslogGenRequired(List<TranslogReader> readers, TranslogWriter writer) {
                    long minGen = writer.generation;
                    for (TranslogReader reader : readers) {
                        minGen = Math.min(reader.generation, minGen);
                    }
                    return minGen;
                }
            };
            try (LocalTranslog translog = new LocalTranslog(translogConfig, translogUUID, retainAllTranslogPolicy, () -> translogGlobalCheckpoint, () -> primaryTerm, seqNo -> {});
                 Translog.Snapshot snapshot = translog.newSnapshot(0L, Long.MAX_VALUE);){
                while (snapshot.next() != null) {
                }
            }
            return true;
        }
        catch (TranslogCorruptedException e) {
            return false;
        }
    }

    private static void writeEmptyCheckpoint(Path filename, int translogLength, long translogGeneration, long globalCheckpoint) throws IOException {
        Checkpoint emptyCheckpoint = Checkpoint.emptyTranslogCheckpoint(translogLength, translogGeneration, globalCheckpoint, translogGeneration);
        Checkpoint.write(FileChannel::open, filename, emptyCheckpoint, StandardOpenOption.WRITE, StandardOpenOption.READ, StandardOpenOption.CREATE_NEW);
    }

    private static int writeEmptyTranslog(Path filename, String translogUUID) throws IOException {
        try (FileChannel fc = FileChannel.open(filename, StandardOpenOption.WRITE, StandardOpenOption.CREATE_NEW);){
            TranslogHeader header = new TranslogHeader(translogUUID, 0L);
            header.write(fc, true);
            int n = header.sizeInBytes();
            return n;
        }
    }

    private String deletingFilesDetails(Path translogPath, Set<Path> files) {
        StringBuilder builder = new StringBuilder();
        builder.append("Documents inside of translog files will be lost.\n").append("  The following files will be DELETED at ").append(translogPath).append("\n\n");
        Iterator<Path> it = files.iterator();
        while (it.hasNext()) {
            builder.append("  --> ").append(it.next().getFileName());
            if (!it.hasNext()) continue;
            builder.append("\n");
        }
        return builder.toString();
    }

    private static Set<Path> filesInDirectory(Path directory) throws IOException {
        TreeSet<Path> files = new TreeSet<Path>();
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(directory);){
            for (Path file : stream) {
                files.add(file);
            }
        }
        return files;
    }
}

